/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.regionerator;

import com.github.jikoo.regionerator.Regionerator;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FlaggingRunnable
extends BukkitRunnable {
    private final Regionerator plugin;

    FlaggingRunnable(Regionerator plugin) {
        this.plugin = plugin;
    }

    public void run() {
        final ArrayList<ChunkId> flagged = new ArrayList<ChunkId>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.getGameMode().name().equals("SPECTATOR") || !this.plugin.config().getWorlds().contains(player.getWorld().getName())) continue;
            flagged.add(new ChunkId(player.getLocation().getChunk()));
        }
        if (!flagged.isEmpty()) {
            new BukkitRunnable(){

                public void run() {
                    for (ChunkId chunk : flagged) {
                        FlaggingRunnable.this.plugin.getFlagger().flagChunksInRadius(chunk.worldName, chunk.chunkX, chunk.chunkZ);
                    }
                }
            }.runTaskAsynchronously((Plugin)this.plugin);
        }
        this.plugin.attemptDeletionActivation();
    }

    private static class ChunkId {
        private final String worldName;
        private final int chunkX;
        private final int chunkZ;

        private ChunkId(Chunk chunk) {
            this.worldName = chunk.getWorld().getName();
            this.chunkX = chunk.getX();
            this.chunkZ = chunk.getZ();
        }
    }
}

