/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.regionerator;

import com.github.jikoo.regionerator.Regionerator;
import com.github.jikoo.regionerator.database.DatabaseAdapter;
import com.github.jikoo.regionerator.util.BatchExpirationLoadingCache;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ChunkFlagger {
    private final Regionerator plugin;
    private final DatabaseAdapter adapter;
    private final BatchExpirationLoadingCache<String, FlagData> flagCache;

    ChunkFlagger(@NotNull Regionerator plugin) {
        this.plugin = plugin;
        try {
            this.adapter = DatabaseAdapter.getAdapter(plugin);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while setting up the database", e);
        }
        this.flagCache = new BatchExpirationLoadingCache<String, FlagData>(180000L, key -> {
            try {
                FlagData flagData = new FlagData((String)key, this.adapter.get((String)key));
                if (flagData.getLastVisit() == Long.MAX_VALUE && plugin.config().isDeleteFreshChunks()) {
                    flagData.setLastVisit(-1L);
                }
                return flagData;
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.WARNING, "Exception fetching chunk flags", e);
                return new FlagData((String)key, 0x7FFFFFFFFFFFFFFDL);
            }
        }, expiredData -> {
            expiredData.removeIf(next -> !((FlagData)next).isDirty() || next.getLastVisit() == 0x7FFFFFFFFFFFFFFDL);
            if (expiredData.isEmpty()) {
                return;
            }
            try {
                this.adapter.update((Collection<FlagData>)expiredData);
                expiredData.forEach(rec$ -> ((FlagData)rec$).wash());
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.SEVERE, "Exception updating chunk flags", e);
            }
        });
        this.convertOldFlagsFile();
        this.convertOldPerWorldFlagFiles();
        this.flagCache.lazyExpireAll();
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, this.flagCache::lazyExpireAll, 3600L, 3600L);
    }

    private void convertOldFlagsFile() {
        File oldFlagsFile = new File(this.plugin.getDataFolder(), "flags.yml");
        if (!oldFlagsFile.exists()) {
            return;
        }
        this.plugin.getLogger().info("Beginning converting flags.yml");
        YamlConfiguration oldFlags = YamlConfiguration.loadConfiguration((File)oldFlagsFile);
        for (String world : oldFlags.getKeys(false)) {
            ConfigurationSection worldSection;
            if (!oldFlags.isConfigurationSection(world) || (worldSection = oldFlags.getConfigurationSection(world)) == null) continue;
            for (String chunkPath : worldSection.getKeys(false)) {
                int chunkZ;
                int chunkX;
                String[] chunk;
                if (!worldSection.isLong(chunkPath) || (chunk = chunkPath.split("_")).length != 2) continue;
                try {
                    chunkX = Integer.parseInt(chunk[0]);
                    chunkZ = Integer.parseInt(chunk[1]);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                this.flagCache.get(this.getFlagDbId(world, chunkX, chunkZ)).thenAccept(flagData -> ((FlagData)flagData).importOldValue(worldSection.getLong(chunkPath)));
            }
        }
        if (oldFlagsFile.renameTo(new File(oldFlagsFile.getParentFile(), "flags.yml.bak"))) {
            this.plugin.getLogger().info("Finished converting flags.yml, renamed to flags.yml.bak. Delete at convenience if all appears well.");
        } else {
            this.plugin.getLogger().warning("Finished converting flags.yml but could not rename! Conversion will run again on startup.");
        }
    }

    private void convertOldPerWorldFlagFiles() {
        File oldFlagsFolder = new File(this.plugin.getDataFolder(), "flags");
        if (!oldFlagsFolder.exists() || !oldFlagsFolder.isDirectory()) {
            return;
        }
        this.plugin.getLogger().info("Beginning converting flags folder.");
        Pattern chunkCoordsSplitter = Pattern.compile("_");
        File[] worldDirectories = oldFlagsFolder.listFiles();
        if (worldDirectories == null) {
            return;
        }
        for (File worldFlagsFolder : worldDirectories) {
            if (!worldFlagsFolder.isDirectory()) continue;
            String worldName = worldFlagsFolder.getName();
            File[] regionFlagsFiles = worldFlagsFolder.listFiles();
            if (regionFlagsFiles == null) continue;
            for (File regionFlagsFile : regionFlagsFiles) {
                YamlConfiguration regionConfig = YamlConfiguration.loadConfiguration((File)regionFlagsFile);
                Map values = regionConfig.getValues(false);
                for (Map.Entry entry : values.entrySet()) {
                    String[] args = chunkCoordsSplitter.split((CharSequence)entry.getKey());
                    int chunkX = Integer.parseInt(args[0]);
                    int chunkZ = Integer.parseInt(args[1]);
                    this.flagCache.get(this.getFlagDbId(worldName, chunkX, chunkZ)).thenAccept(flagData -> ((FlagData)flagData).importOldValue((Long)entry.getValue()));
                }
            }
        }
        if (oldFlagsFolder.renameTo(new File(oldFlagsFolder.getParentFile(), "flags.bak"))) {
            this.plugin.getLogger().info("Finished converting flags folder, renamed to flags.bak. Delete at convenience if all appears well.");
        } else {
            this.plugin.getLogger().warning("Finished converting flags folder but could not rename! Conversion will run again on startup.");
        }
    }

    public void flagChunksInRadius(@NotNull String world, int chunkX, int chunkZ) {
        this.flagChunksInRadius(world, chunkX, chunkZ, this.plugin.config().getFlaggingRadius(), this.plugin.config().getFlagVisit());
    }

    public void flagChunksInRadius(@NotNull String world, int chunkX, int chunkZ, int radius, long flagTil) {
        for (int dX = -radius; dX <= radius; ++dX) {
            for (int dZ = -radius; dZ <= radius; ++dZ) {
                this.flagChunk(world, chunkX + dX, chunkZ + dZ, flagTil);
            }
        }
    }

    public void flagChunk(@NotNull String world, int chunkX, int chunkZ, long flagTil) {
        String flagDbId = this.getFlagDbId(world, chunkX, chunkZ);
        FlagData flagData = this.flagCache.getIfPresent(flagDbId);
        if (flagData != null) {
            long current = flagData.getLastVisit();
            if (current == 0x7FFFFFFFFFFFFFFEL) {
                return;
            }
            flagData.setLastVisit(flagTil);
        } else {
            flagData = new FlagData(flagDbId, flagTil, true);
            this.flagCache.put(flagDbId, flagData);
        }
    }

    @Deprecated
    public void unflagRegionByLowestChunk(@NotNull String world, int regionLowestChunkX, int regionLowestChunkZ) {
        for (int chunkX = regionLowestChunkX; chunkX < regionLowestChunkX + 32; ++chunkX) {
            for (int chunkZ = regionLowestChunkZ; chunkZ < regionLowestChunkZ + 32; ++chunkZ) {
                this.unflagChunk(world, chunkX, chunkZ);
            }
        }
    }

    public void unflagChunk(@NotNull String world, int chunkX, int chunkZ) {
        this.flagCache.computeIfAbsent(this.getFlagDbId(world, chunkX, chunkZ), key -> new FlagData((String)key, -1L, true)).setLastVisit(-1L);
    }

    void shutdown() {
        this.flagCache.expireAll();
        this.adapter.close();
    }

    public int getCached() {
        return this.flagCache.getCached();
    }

    public int getQueued() {
        return this.flagCache.getQueued();
    }

    public CompletableFuture<FlagData> getChunkFlag(@NotNull World world, int chunkX, int chunkZ) {
        return this.flagCache.get(this.getFlagDbId(world.getName(), chunkX, chunkZ));
    }

    public CompletableFuture<FlagData> getChunkFlagOnDelete(@NotNull World world, int chunkX, int chunkZ) {
        return this.flagCache.get(this.getFlagDbId(world.getName(), chunkX, chunkZ) + "_old");
    }

    @NotNull
    @Contract(pure=true)
    private String getFlagDbId(@NotNull String worldName, int chunkX, int chunkZ) {
        return worldName + "_" + chunkX + '_' + chunkZ;
    }

    public static class FlagData {
        private final String chunkId;
        private final AtomicLong lastVisit;
        private final AtomicBoolean dirty;

        private FlagData(@NotNull String chunkId, long lastVisit) {
            this(chunkId, lastVisit, false);
        }

        private FlagData(@NotNull String chunkId, long lastVisit, boolean dirty) {
            this.chunkId = chunkId;
            this.lastVisit = new AtomicLong(lastVisit);
            this.dirty = new AtomicBoolean(dirty);
        }

        @NotNull
        public String getChunkId() {
            return this.chunkId;
        }

        public long getLastVisit() {
            return this.lastVisit.get();
        }

        private void setLastVisit(long lastVisit) {
            if (this.lastVisit.getAndSet(lastVisit) != lastVisit) {
                this.dirty.set(true);
            }
        }

        private void importOldValue(long oldValue) {
            if (oldValue == -1L) {
                return;
            }
            if (oldValue == Long.MAX_VALUE) {
                if (this.lastVisit.compareAndSet(-1L, oldValue)) {
                    this.dirty.set(true);
                }
                return;
            }
            if (this.lastVisit.updateAndGet(currentValue -> Math.max(currentValue, oldValue)) == oldValue) {
                this.dirty.set(true);
            }
        }

        private boolean isDirty() {
            return this.dirty.get();
        }

        private void wash() {
            this.dirty.set(false);
        }

        public int hashCode() {
            return Objects.hash(this.chunkId, this.lastVisit, this.dirty);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FlagData other = (FlagData)obj;
            return this.lastVisit.equals(other.lastVisit) && this.dirty.equals(other.dirty) && this.chunkId.equals(other.chunkId);
        }
    }
}

