/*
 * Decompiled with CFR 0.152.
 */
package com.github.jenspiegsa.wiremockextension;

import com.github.jenspiegsa.wiremockextension.ConfigureWireMock;
import com.github.jenspiegsa.wiremockextension.InjectServer;
import com.github.jenspiegsa.wiremockextension.Managed;
import com.github.jenspiegsa.wiremockextension.ManagedWireMockServer;
import com.github.jenspiegsa.wiremockextension.WireMockSettings;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;

public class WireMockExtension
implements BeforeEachCallback,
AfterEachCallback,
TestInstancePostProcessor {
    private boolean generalFailOnUnmatchedRequests;
    private final Map<String, List<WireMockServer>> serversByTestId = new LinkedHashMap<String, List<WireMockServer>>();

    private WireMockExtension() {
        this(true);
    }

    public WireMockExtension(boolean failOnUnmatchedRequests) {
        this.generalFailOnUnmatchedRequests = failOnUnmatchedRequests;
    }

    /*
     * WARNING - void declaration
     */
    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        ArrayList<WireMockServer> servers = new ArrayList<WireMockServer>();
        for (Field field : WireMockExtension.retrieveAnnotatedFields(context, Managed.class, WireMockServer.class)) {
            servers.add((WireMockServer)Objects.requireNonNull(((Field)ReflectionUtils.makeAccessible((AccessibleObject)field)).get(testInstance)));
        }
        if (servers.isEmpty()) {
            WireMockConfiguration options = null;
            for (Field field : WireMockExtension.retrieveAnnotatedFields(context, ConfigureWireMock.class, Options.class)) {
                if (options == null) {
                    options = (Options)((Field)ReflectionUtils.makeAccessible((AccessibleObject)field)).get(testInstance);
                    continue;
                }
                throw new ExtensionConfigurationException("@ConfigureWireMock only valid once per class.");
            }
            if (options == null) {
                options = WireMockConfiguration.wireMockConfig();
            }
            Object var5_7 = null;
            for (Field field : WireMockExtension.retrieveAnnotatedFields(context, InjectServer.class, WireMockServer.class)) {
                void var5_8;
                if (var5_8 == null) {
                    WireMockServer wireMockServer = new WireMockServer((Options)options);
                    servers.add(wireMockServer);
                }
                ((Field)ReflectionUtils.makeAccessible((AccessibleObject)field)).set(testInstance, var5_8);
            }
        }
        this.serversByTestId.computeIfAbsent(context.getUniqueId(), k -> new ArrayList()).addAll(servers);
        for (WireMockServer wireMockServer : servers) {
            wireMockServer.start();
            WireMock.configureFor((String)"localhost", (int)wireMockServer.port());
        }
    }

    public void beforeEach(ExtensionContext context) {
        Optional<WireMockSettings> wireMockSettings = WireMockExtension.retrieveAnnotation(context, WireMockSettings.class);
        this.generalFailOnUnmatchedRequests = wireMockSettings.map(WireMockSettings::failOnUnmatchedRequests).orElse(this.generalFailOnUnmatchedRequests);
        if (this.isSimpleCase(context)) {
            WireMockServer server = new WireMockServer();
            this.serversByTestId.put(context.getUniqueId(), Collections.singletonList(server));
            server.start();
            WireMock.configureFor((String)"localhost", (int)server.port());
        }
    }

    private boolean isSimpleCase(ExtensionContext context) {
        boolean isSimpleCase = true;
        ExtensionContext currentContext = context;
        while (currentContext != null) {
            isSimpleCase &= this.serversByTestId.getOrDefault(currentContext.getUniqueId(), Collections.emptyList()).isEmpty();
            currentContext = currentContext.getParent().orElse(null);
        }
        return isSimpleCase;
    }

    public void afterEach(ExtensionContext context) {
        ExtensionContext currentContext = context;
        while (currentContext != null) {
            List<WireMockServer> servers = this.serversByTestId.get(currentContext.getUniqueId());
            if (servers != null) {
                servers.forEach(WireMockServer::stop);
            }
            this.checkForUnmatchedRequests(currentContext);
            currentContext = currentContext.getParent().orElse(null);
        }
    }

    private void checkForUnmatchedRequests(ExtensionContext context) {
        List<WireMockServer> servers = this.serversByTestId.get(context.getUniqueId());
        if (servers != null) {
            for (WireMockServer server : servers) {
                List unmatchedRequests;
                Boolean mustCheck = Optional.of(server).filter(ManagedWireMockServer.class::isInstance).map(ManagedWireMockServer.class::cast).map(ManagedWireMockServer::failOnUnmatchedRequests).orElse(this.generalFailOnUnmatchedRequests);
                if (!mustCheck.booleanValue() || (unmatchedRequests = server.findAllUnmatchedRequests()).isEmpty()) continue;
                List nearMisses = server.findNearMissesForAllUnmatchedRequests();
                throw nearMisses.isEmpty() ? VerificationException.forUnmatchedRequests((List)unmatchedRequests) : VerificationException.forUnmatchedNearMisses((List)nearMisses);
            }
        }
    }

    private static <A extends Annotation> Optional<A> retrieveAnnotation(ExtensionContext context, Class<A> annotationType) {
        Optional currentContext = Optional.of(context);
        Optional annotation = Optional.empty();
        while (currentContext.isPresent() && !annotation.isPresent()) {
            annotation = AnnotationSupport.findAnnotation((Optional)currentContext.get().getElement(), annotationType);
            currentContext = currentContext.get().getParent();
        }
        return annotation;
    }

    private static List<Field> retrieveAnnotatedFields(ExtensionContext context, Class<? extends Annotation> annotationType, Class<?> fieldType) {
        return context.getElement().filter(Class.class::isInstance).map(Class.class::cast).map(testInstanceClass -> AnnotationUtils.findAnnotatedFields((Class)testInstanceClass, (Class)annotationType, field -> fieldType.isAssignableFrom(field.getType()))).orElseGet(Collections::emptyList);
    }
}

