/*
 * Decompiled with CFR 0.152.
 */
package com.jaygoo.widget;

import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.jaygoo.widget.R;
import com.jaygoo.widget.RangeSeekBar;
import com.jaygoo.widget.SeekBar;
import com.jaygoo.widget.Utils;
import com.jaygoo.widget.VerticalRangeSeekBar;

public class VerticalSeekBar
extends SeekBar {
    private int indicatorTextOrientation;
    VerticalRangeSeekBar verticalSeekBar;

    public VerticalSeekBar(RangeSeekBar rangeSeekBar, AttributeSet attrs, boolean isLeft) {
        super(rangeSeekBar, attrs, isLeft);
        this.initAttrs(attrs);
        this.verticalSeekBar = (VerticalRangeSeekBar)rangeSeekBar;
    }

    private void initAttrs(AttributeSet attrs) {
        try {
            TypedArray t = this.getContext().obtainStyledAttributes(attrs, R.styleable.VerticalRangeSeekBar);
            this.indicatorTextOrientation = t.getInt(R.styleable.VerticalRangeSeekBar_rsb_indicator_text_orientation, 1);
            t.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onDrawIndicator(Canvas canvas, Paint paint, String text2Draw) {
        if (text2Draw == null) {
            return;
        }
        if (this.indicatorTextOrientation == 1) {
            this.drawVerticalIndicator(canvas, paint, text2Draw);
        } else {
            super.onDrawIndicator(canvas, paint, text2Draw);
        }
    }

    protected void drawVerticalIndicator(Canvas canvas, Paint paint, String text2Draw) {
        paint.setTextSize((float)this.getIndicatorTextSize());
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(this.getIndicatorBackgroundColor());
        paint.getTextBounds(text2Draw, 0, text2Draw.length(), this.indicatorTextRect);
        int realIndicatorWidth = this.indicatorTextRect.height() + this.getIndicatorPaddingLeft() + this.getIndicatorPaddingRight();
        if (this.getIndicatorWidth() > realIndicatorWidth) {
            realIndicatorWidth = this.getIndicatorWidth();
        }
        int realIndicatorHeight = this.indicatorTextRect.width() + this.getIndicatorPaddingTop() + this.getIndicatorPaddingBottom();
        if (this.getIndicatorHeight() > realIndicatorHeight) {
            realIndicatorHeight = this.getIndicatorHeight();
        }
        this.indicatorRect.left = this.scaleThumbWidth / 2 - realIndicatorWidth / 2;
        this.indicatorRect.top = this.bottom - realIndicatorHeight - this.scaleThumbHeight - this.getIndicatorMargin();
        this.indicatorRect.right = this.indicatorRect.left + realIndicatorWidth;
        this.indicatorRect.bottom = this.indicatorRect.top + realIndicatorHeight;
        if (this.indicatorBitmap == null) {
            int ax = this.scaleThumbWidth / 2;
            int ay = this.indicatorRect.bottom;
            int bx = ax - this.getIndicatorArrowSize();
            int by = ay - this.getIndicatorArrowSize();
            int cx = ax + this.getIndicatorArrowSize();
            this.indicatorArrowPath.reset();
            this.indicatorArrowPath.moveTo((float)ax, (float)ay);
            this.indicatorArrowPath.lineTo((float)bx, (float)by);
            this.indicatorArrowPath.lineTo((float)cx, (float)by);
            this.indicatorArrowPath.close();
            canvas.drawPath(this.indicatorArrowPath, paint);
            this.indicatorRect.bottom -= this.getIndicatorArrowSize();
            this.indicatorRect.top -= this.getIndicatorArrowSize();
        }
        int defaultPaddingOffset = Utils.dp2px(this.getContext(), 1.0f);
        int leftOffset = this.indicatorRect.width() / 2 - (int)((float)this.rangeSeekBar.getProgressWidth() * this.currPercent) - this.rangeSeekBar.getProgressLeft() + defaultPaddingOffset;
        int rightOffset = this.indicatorRect.width() / 2 - (int)((float)this.rangeSeekBar.getProgressWidth() * (1.0f - this.currPercent)) - this.rangeSeekBar.getProgressPaddingRight() + defaultPaddingOffset;
        if (leftOffset > 0) {
            this.indicatorRect.left += leftOffset;
            this.indicatorRect.right += leftOffset;
        } else if (rightOffset > 0) {
            this.indicatorRect.left -= rightOffset;
            this.indicatorRect.right -= rightOffset;
        }
        if (this.indicatorBitmap != null) {
            Utils.drawBitmap(canvas, paint, this.indicatorBitmap, this.indicatorRect);
        } else if (this.getIndicatorRadius() > 0.0f) {
            canvas.drawRoundRect(new RectF(this.indicatorRect), this.getIndicatorRadius(), this.getIndicatorRadius(), paint);
        } else {
            canvas.drawRect(this.indicatorRect, paint);
        }
        int tx = this.indicatorRect.left + (this.indicatorRect.width() - this.indicatorTextRect.width()) / 2 + this.getIndicatorPaddingLeft() - this.getIndicatorPaddingRight();
        int ty = this.indicatorRect.bottom - (this.indicatorRect.height() - this.indicatorTextRect.height()) / 2 + this.getIndicatorPaddingTop() - this.getIndicatorPaddingBottom();
        paint.setColor(this.getIndicatorTextColor());
        int degrees = 0;
        float rotateX = (float)tx + (float)this.indicatorTextRect.width() / 2.0f;
        float rotateY = (float)ty - (float)this.indicatorTextRect.height() / 2.0f;
        if (this.indicatorTextOrientation == 1) {
            if (this.verticalSeekBar.getOrientation() == 1) {
                degrees = 90;
            } else if (this.verticalSeekBar.getOrientation() == 2) {
                degrees = -90;
            }
        }
        if (degrees != 0) {
            canvas.rotate((float)degrees, rotateX, rotateY);
        }
        canvas.drawText(text2Draw, (float)tx, (float)ty, paint);
        if (degrees != 0) {
            canvas.rotate((float)(-degrees), rotateX, rotateY);
        }
    }

    public int getIndicatorTextOrientation() {
        return this.indicatorTextOrientation;
    }

    public void setIndicatorTextOrientation(int orientation) {
        this.indicatorTextOrientation = orientation;
    }
}

