/*
 * Decompiled with CFR 0.152.
 */
package com.jaygoo.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.jaygoo.widget.R;
import com.jaygoo.widget.RangeSeekBar;
import com.jaygoo.widget.SeekBarState;
import com.jaygoo.widget.Utils;
import com.jaygoo.widget.VerticalSeekBar;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class VerticalRangeSeekBar
extends RangeSeekBar {
    public static final int TEXT_DIRECTION_VERTICAL = 1;
    public static final int TEXT_DIRECTION_HORIZONTAL = 2;
    public static final int DIRECTION_LEFT = 1;
    public static final int DIRECTION_RIGHT = 2;
    private int orientation = 1;
    private int tickMarkDirection = 1;
    private int maxTickMarkWidth;

    public VerticalRangeSeekBar(Context context) {
        this(context, null);
    }

    public VerticalRangeSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(attrs);
        this.initSeekBar(attrs);
    }

    private void initAttrs(AttributeSet attrs) {
        try {
            TypedArray t = this.getContext().obtainStyledAttributes(attrs, R.styleable.VerticalRangeSeekBar);
            this.orientation = t.getInt(R.styleable.VerticalRangeSeekBar_rsb_orientation, 1);
            this.tickMarkDirection = t.getInt(R.styleable.VerticalRangeSeekBar_rsb_tick_mark_orientation, 1);
            t.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initSeekBar(AttributeSet attrs) {
        this.leftSB = new VerticalSeekBar(this, attrs, true);
        this.rightSB = new VerticalSeekBar(this, attrs, false);
        this.rightSB.setVisible(this.getSeekBarMode() != 1);
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(h, w, oldh, oldw);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        if (widthMode == 0x40000000) {
            widthSize = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)0x40000000);
        } else if (widthMode == Integer.MIN_VALUE && this.getParent() instanceof ViewGroup && widthSize == -1) {
            widthSize = View.MeasureSpec.makeMeasureSpec((int)((ViewGroup)this.getParent()).getMeasuredHeight(), (int)Integer.MIN_VALUE);
        } else {
            int heightNeeded = this.getGravity() == 2 ? 2 * this.getProgressTop() + this.getProgressHeight() : (int)this.getRawHeight();
            widthSize = View.MeasureSpec.makeMeasureSpec((int)heightNeeded, (int)0x40000000);
        }
        super.onMeasure(widthSize, heightMeasureSpec);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (this.orientation == 1) {
            canvas.rotate(-90.0f);
            canvas.translate((float)(-this.getHeight()), 0.0f);
        } else {
            canvas.rotate(90.0f);
            canvas.translate(0.0f, (float)(-this.getWidth()));
        }
        super.onDraw(canvas);
    }

    @Override
    protected void onDrawTickMark(Canvas canvas, Paint paint) {
        if (this.getTickMarkTextArray() != null) {
            int arrayLength = this.getTickMarkTextArray().length;
            int trickPartWidth = this.getProgressWidth() / (arrayLength - 1);
            for (int i = 0; i < arrayLength; ++i) {
                float x;
                String text2Draw = this.getTickMarkTextArray()[i].toString();
                if (TextUtils.isEmpty((CharSequence)text2Draw)) continue;
                paint.getTextBounds(text2Draw, 0, text2Draw.length(), this.tickMarkTextRect);
                paint.setColor(this.getTickMarkTextColor());
                if (this.getTickMarkMode() == 1) {
                    x = this.getTickMarkGravity() == 2 ? (float)(this.getProgressLeft() + i * trickPartWidth - this.tickMarkTextRect.width()) : (this.getTickMarkGravity() == 1 ? (float)(this.getProgressLeft() + i * trickPartWidth) - (float)this.tickMarkTextRect.width() / 2.0f : (float)(this.getProgressLeft() + i * trickPartWidth));
                } else {
                    float num = Utils.parseFloat(text2Draw);
                    SeekBarState[] states = this.getRangeSeekBarState();
                    if (Utils.compareFloat(num, states[0].value) != -1 && Utils.compareFloat(num, states[1].value) != 1 && this.getSeekBarMode() == 2) {
                        paint.setColor(this.getTickMarkInRangeTextColor());
                    }
                    x = (float)this.getProgressLeft() + (float)this.getProgressWidth() * (num - this.getMinProgress()) / (this.getMaxProgress() - this.getMinProgress()) - (float)this.tickMarkTextRect.width() / 2.0f;
                }
                float y = this.getTickMarkLayoutGravity() == 0 ? (float)(this.getProgressTop() - this.getTickMarkTextMargin()) : (float)(this.getProgressBottom() + this.getTickMarkTextMargin() + this.tickMarkTextRect.height());
                int degrees = 0;
                float rotateX = x + (float)this.tickMarkTextRect.width() / 2.0f;
                float rotateY = y - (float)this.tickMarkTextRect.height() / 2.0f;
                if (this.tickMarkDirection == 1) {
                    if (this.orientation == 1) {
                        degrees = 90;
                    } else if (this.orientation == 2) {
                        degrees = -90;
                    }
                }
                if (degrees != 0) {
                    canvas.rotate((float)degrees, rotateX, rotateY);
                }
                canvas.drawText(text2Draw, x, y, paint);
                if (degrees == 0) continue;
                canvas.rotate((float)(-degrees), rotateX, rotateY);
            }
        }
    }

    @Override
    protected int getTickMarkRawHeight() {
        if (this.maxTickMarkWidth > 0) {
            return this.getTickMarkTextMargin() + this.maxTickMarkWidth;
        }
        if (this.getTickMarkTextArray() != null && this.getTickMarkTextArray().length > 0) {
            int arrayLength = this.getTickMarkTextArray().length;
            this.maxTickMarkWidth = Utils.measureText(String.valueOf(this.getTickMarkTextArray()[0]), this.getTickMarkTextSize()).width();
            for (int i = 1; i < arrayLength; ++i) {
                int width = Utils.measureText(String.valueOf(this.getTickMarkTextArray()[i]), this.getTickMarkTextSize()).width();
                if (this.maxTickMarkWidth >= width) continue;
                this.maxTickMarkWidth = width;
            }
            return this.getTickMarkTextMargin() + this.maxTickMarkWidth;
        }
        return 0;
    }

    @Override
    public void setTickMarkTextSize(int tickMarkTextSize) {
        super.setTickMarkTextSize(tickMarkTextSize);
        this.maxTickMarkWidth = 0;
    }

    @Override
    public void setTickMarkTextArray(CharSequence[] tickMarkTextArray) {
        super.setTickMarkTextArray(tickMarkTextArray);
        this.maxTickMarkWidth = 0;
    }

    @Override
    protected float getEventX(MotionEvent event) {
        if (this.orientation == 1) {
            return (float)this.getHeight() - event.getY();
        }
        return event.getY();
    }

    @Override
    protected float getEventY(MotionEvent event) {
        if (this.orientation == 1) {
            return event.getX();
        }
        return -event.getX() + (float)this.getWidth();
    }

    @Override
    public VerticalSeekBar getLeftSeekBar() {
        return (VerticalSeekBar)this.leftSB;
    }

    @Override
    public VerticalSeekBar getRightSeekBar() {
        return (VerticalSeekBar)this.rightSB;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getTickMarkDirection() {
        return this.tickMarkDirection;
    }

    public void setTickMarkDirection(int tickMarkDirection) {
        this.tickMarkDirection = tickMarkDirection;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DirectionDef {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TextDirectionDef {
    }
}

