/*
 * Decompiled with CFR 0.152.
 */
package com.jaygoo.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.jaygoo.widget.R;
import com.jaygoo.widget.RangeSeekBar;
import com.jaygoo.widget.SeekBarState;
import com.jaygoo.widget.Utils;
import java.text.DecimalFormat;

public class SeekBar {
    public static final int INDICATOR_SHOW_WHEN_TOUCH = 0;
    public static final int INDICATOR_ALWAYS_HIDE = 1;
    public static final int INDICATOR_ALWAYS_SHOW_AFTER_TOUCH = 2;
    public static final int INDICATOR_ALWAYS_SHOW = 3;
    public static final int WRAP_CONTENT = -1;
    public static final int MATCH_PARENT = -2;
    private int indicatorShowMode;
    private int indicatorHeight;
    private int indicatorWidth;
    private int indicatorMargin;
    private int indicatorDrawableId;
    private int indicatorArrowSize;
    private int indicatorTextSize;
    private int indicatorTextColor;
    private float indicatorRadius;
    private int indicatorBackgroundColor;
    private int indicatorPaddingLeft;
    private int indicatorPaddingRight;
    private int indicatorPaddingTop;
    private int indicatorPaddingBottom;
    private int thumbDrawableId;
    private int thumbInactivatedDrawableId;
    private int thumbWidth;
    private int thumbHeight;
    float thumbScaleRatio;
    int left;
    int right;
    int top;
    int bottom;
    float currPercent;
    float material = 0.0f;
    private boolean isShowIndicator;
    boolean isLeft;
    Bitmap thumbBitmap;
    Bitmap thumbInactivatedBitmap;
    Bitmap indicatorBitmap;
    ValueAnimator anim;
    String userText2Draw;
    boolean isActivate = false;
    boolean isVisible = true;
    RangeSeekBar rangeSeekBar;
    String indicatorTextStringFormat;
    Path indicatorArrowPath = new Path();
    Rect indicatorTextRect = new Rect();
    Rect indicatorRect = new Rect();
    Paint paint = new Paint(1);
    DecimalFormat indicatorTextDecimalFormat;
    int scaleThumbWidth;
    int scaleThumbHeight;

    public SeekBar(RangeSeekBar rangeSeekBar, AttributeSet attrs, boolean isLeft) {
        this.rangeSeekBar = rangeSeekBar;
        this.isLeft = isLeft;
        this.initAttrs(attrs);
        this.initBitmap();
        this.initVariables();
    }

    private void initAttrs(AttributeSet attrs) {
        TypedArray t = this.getContext().obtainStyledAttributes(attrs, R.styleable.RangeSeekBar);
        if (t == null) {
            return;
        }
        this.indicatorMargin = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_indicator_margin, 0.0f);
        this.indicatorDrawableId = t.getResourceId(R.styleable.RangeSeekBar_rsb_indicator_drawable, 0);
        this.indicatorShowMode = t.getInt(R.styleable.RangeSeekBar_rsb_indicator_show_mode, 1);
        this.indicatorHeight = t.getLayoutDimension(R.styleable.RangeSeekBar_rsb_indicator_height, -1);
        this.indicatorWidth = t.getLayoutDimension(R.styleable.RangeSeekBar_rsb_indicator_width, -1);
        this.indicatorTextSize = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_indicator_text_size, (float)Utils.dp2px(this.getContext(), 14.0f));
        this.indicatorTextColor = t.getColor(R.styleable.RangeSeekBar_rsb_indicator_text_color, -1);
        this.indicatorBackgroundColor = t.getColor(R.styleable.RangeSeekBar_rsb_indicator_background_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.colorAccent));
        this.indicatorPaddingLeft = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_indicator_padding_left, 0.0f);
        this.indicatorPaddingRight = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_indicator_padding_right, 0.0f);
        this.indicatorPaddingTop = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_indicator_padding_top, 0.0f);
        this.indicatorPaddingBottom = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_indicator_padding_bottom, 0.0f);
        this.indicatorArrowSize = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_indicator_arrow_size, 0.0f);
        this.thumbDrawableId = t.getResourceId(R.styleable.RangeSeekBar_rsb_thumb_drawable, R.drawable.rsb_default_thumb);
        this.thumbInactivatedDrawableId = t.getResourceId(R.styleable.RangeSeekBar_rsb_thumb_inactivated_drawable, 0);
        this.thumbWidth = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_thumb_width, (float)Utils.dp2px(this.getContext(), 26.0f));
        this.thumbHeight = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_thumb_height, (float)Utils.dp2px(this.getContext(), 26.0f));
        this.thumbScaleRatio = t.getFloat(R.styleable.RangeSeekBar_rsb_thumb_scale_ratio, 1.0f);
        this.indicatorRadius = t.getDimension(R.styleable.RangeSeekBar_rsb_indicator_radius, 0.0f);
        t.recycle();
    }

    protected void initVariables() {
        this.scaleThumbWidth = this.thumbWidth;
        this.scaleThumbHeight = this.thumbHeight;
        if (this.indicatorHeight == -1) {
            this.indicatorHeight = Utils.measureText("8", this.indicatorTextSize).height() + this.indicatorPaddingTop + this.indicatorPaddingBottom;
        }
        if (this.indicatorArrowSize <= 0) {
            this.indicatorArrowSize = this.thumbWidth / 4;
        }
    }

    public Context getContext() {
        return this.rangeSeekBar.getContext();
    }

    public Resources getResources() {
        if (this.getContext() != null) {
            return this.getContext().getResources();
        }
        return null;
    }

    private void initBitmap() {
        this.setIndicatorDrawableId(this.indicatorDrawableId);
        this.setThumbDrawableId(this.thumbDrawableId, this.thumbWidth, this.thumbHeight);
        this.setThumbInactivatedDrawableId(this.thumbInactivatedDrawableId, this.thumbWidth, this.thumbHeight);
    }

    protected void onSizeChanged(int x, int y) {
        this.initVariables();
        this.initBitmap();
        this.left = (int)((float)x - this.getThumbScaleWidth() / 2.0f);
        this.right = (int)((float)x + this.getThumbScaleWidth() / 2.0f);
        this.top = y - this.getThumbHeight() / 2;
        this.bottom = y + this.getThumbHeight() / 2;
    }

    public void scaleThumb() {
        this.scaleThumbWidth = (int)this.getThumbScaleWidth();
        this.scaleThumbHeight = (int)this.getThumbScaleHeight();
        int y = this.rangeSeekBar.getProgressBottom();
        this.top = y - this.scaleThumbHeight / 2;
        this.bottom = y + this.scaleThumbHeight / 2;
        this.setThumbDrawableId(this.thumbDrawableId, this.scaleThumbWidth, this.scaleThumbHeight);
    }

    public void resetThumb() {
        this.scaleThumbWidth = this.getThumbWidth();
        this.scaleThumbHeight = this.getThumbHeight();
        int y = this.rangeSeekBar.getProgressBottom();
        this.top = y - this.scaleThumbHeight / 2;
        this.bottom = y + this.scaleThumbHeight / 2;
        this.setThumbDrawableId(this.thumbDrawableId, this.scaleThumbWidth, this.scaleThumbHeight);
    }

    public float getRawHeight() {
        return (float)(this.getIndicatorHeight() + this.getIndicatorArrowSize() + this.getIndicatorMargin()) + this.getThumbScaleHeight();
    }

    protected void draw(Canvas canvas) {
        if (!this.isVisible) {
            return;
        }
        int offset = (int)((float)this.rangeSeekBar.getProgressWidth() * this.currPercent);
        canvas.save();
        canvas.translate((float)offset, 0.0f);
        canvas.translate((float)this.left, 0.0f);
        if (this.isShowIndicator) {
            this.onDrawIndicator(canvas, this.paint, this.formatCurrentIndicatorText(this.userText2Draw));
        }
        this.onDrawThumb(canvas);
        canvas.restore();
    }

    protected void onDrawThumb(Canvas canvas) {
        if (this.thumbInactivatedBitmap != null && !this.isActivate) {
            canvas.drawBitmap(this.thumbInactivatedBitmap, 0.0f, (float)this.rangeSeekBar.getProgressTop() + (float)(this.rangeSeekBar.getProgressHeight() - this.scaleThumbHeight) / 2.0f, null);
        } else if (this.thumbBitmap != null) {
            canvas.drawBitmap(this.thumbBitmap, 0.0f, (float)this.rangeSeekBar.getProgressTop() + (float)(this.rangeSeekBar.getProgressHeight() - this.scaleThumbHeight) / 2.0f, null);
        }
    }

    protected String formatCurrentIndicatorText(String text2Draw) {
        SeekBarState[] states = this.rangeSeekBar.getRangeSeekBarState();
        if (TextUtils.isEmpty((CharSequence)text2Draw)) {
            text2Draw = this.isLeft ? (this.indicatorTextDecimalFormat != null ? this.indicatorTextDecimalFormat.format(states[0].value) : states[0].indicatorText) : (this.indicatorTextDecimalFormat != null ? this.indicatorTextDecimalFormat.format(states[1].value) : states[1].indicatorText);
        }
        if (this.indicatorTextStringFormat != null) {
            text2Draw = String.format(this.indicatorTextStringFormat, text2Draw);
        }
        return text2Draw;
    }

    protected void onDrawIndicator(Canvas canvas, Paint paint, String text2Draw) {
        int realIndicatorHeight;
        if (text2Draw == null) {
            return;
        }
        paint.setTextSize((float)this.indicatorTextSize);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(this.indicatorBackgroundColor);
        paint.getTextBounds(text2Draw, 0, text2Draw.length(), this.indicatorTextRect);
        int realIndicatorWidth = this.indicatorTextRect.width() + this.indicatorPaddingLeft + this.indicatorPaddingRight;
        if (this.indicatorWidth > realIndicatorWidth) {
            realIndicatorWidth = this.indicatorWidth;
        }
        if (this.indicatorHeight > (realIndicatorHeight = this.indicatorTextRect.height() + this.indicatorPaddingTop + this.indicatorPaddingBottom)) {
            realIndicatorHeight = this.indicatorHeight;
        }
        this.indicatorRect.left = (int)((float)this.scaleThumbWidth / 2.0f - (float)realIndicatorWidth / 2.0f);
        this.indicatorRect.top = this.bottom - realIndicatorHeight - this.scaleThumbHeight - this.indicatorMargin;
        this.indicatorRect.right = this.indicatorRect.left + realIndicatorWidth;
        this.indicatorRect.bottom = this.indicatorRect.top + realIndicatorHeight;
        if (this.indicatorBitmap == null) {
            int ax = this.scaleThumbWidth / 2;
            int ay = this.indicatorRect.bottom;
            int bx = ax - this.indicatorArrowSize;
            int by = ay - this.indicatorArrowSize;
            int cx = ax + this.indicatorArrowSize;
            this.indicatorArrowPath.reset();
            this.indicatorArrowPath.moveTo((float)ax, (float)ay);
            this.indicatorArrowPath.lineTo((float)bx, (float)by);
            this.indicatorArrowPath.lineTo((float)cx, (float)by);
            this.indicatorArrowPath.close();
            canvas.drawPath(this.indicatorArrowPath, paint);
            this.indicatorRect.bottom -= this.indicatorArrowSize;
            this.indicatorRect.top -= this.indicatorArrowSize;
        }
        int defaultPaddingOffset = Utils.dp2px(this.getContext(), 1.0f);
        int leftOffset = this.indicatorRect.width() / 2 - (int)((float)this.rangeSeekBar.getProgressWidth() * this.currPercent) - this.rangeSeekBar.getProgressLeft() + defaultPaddingOffset;
        int rightOffset = this.indicatorRect.width() / 2 - (int)((float)this.rangeSeekBar.getProgressWidth() * (1.0f - this.currPercent)) - this.rangeSeekBar.getProgressPaddingRight() + defaultPaddingOffset;
        if (leftOffset > 0) {
            this.indicatorRect.left += leftOffset;
            this.indicatorRect.right += leftOffset;
        } else if (rightOffset > 0) {
            this.indicatorRect.left -= rightOffset;
            this.indicatorRect.right -= rightOffset;
        }
        if (this.indicatorBitmap != null) {
            Utils.drawBitmap(canvas, paint, this.indicatorBitmap, this.indicatorRect);
        } else if (this.indicatorRadius > 0.0f) {
            canvas.drawRoundRect(new RectF(this.indicatorRect), this.indicatorRadius, this.indicatorRadius, paint);
        } else {
            canvas.drawRect(this.indicatorRect, paint);
        }
        int tx = this.indicatorPaddingLeft > 0 ? this.indicatorRect.left + this.indicatorPaddingLeft : (this.indicatorPaddingRight > 0 ? this.indicatorRect.right - this.indicatorPaddingRight - this.indicatorTextRect.width() : this.indicatorRect.left + (realIndicatorWidth - this.indicatorTextRect.width()) / 2);
        int ty = this.indicatorPaddingTop > 0 ? this.indicatorRect.top + this.indicatorTextRect.height() + this.indicatorPaddingTop : (this.indicatorPaddingBottom > 0 ? this.indicatorRect.bottom - this.indicatorTextRect.height() - this.indicatorPaddingBottom : this.indicatorRect.bottom - (realIndicatorHeight - this.indicatorTextRect.height()) / 2 + 1);
        paint.setColor(this.indicatorTextColor);
        canvas.drawText(text2Draw, (float)tx, (float)ty, paint);
    }

    protected boolean collide(float x, float y) {
        int offset = (int)((float)this.rangeSeekBar.getProgressWidth() * this.currPercent);
        return x > (float)(this.left + offset) && x < (float)(this.right + offset) && y > (float)this.top && y < (float)this.bottom;
    }

    protected void slide(float percent) {
        if (percent < 0.0f) {
            percent = 0.0f;
        } else if (percent > 1.0f) {
            percent = 1.0f;
        }
        this.currPercent = percent;
    }

    protected void setShowIndicatorEnable(boolean isEnable) {
        switch (this.indicatorShowMode) {
            case 0: {
                this.isShowIndicator = isEnable;
                break;
            }
            case 2: 
            case 3: {
                this.isShowIndicator = true;
                break;
            }
            case 1: {
                this.isShowIndicator = false;
            }
        }
    }

    public void materialRestore() {
        if (this.anim != null) {
            this.anim.cancel();
        }
        this.anim = ValueAnimator.ofFloat((float[])new float[]{this.material, 0.0f});
        this.anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SeekBar.this.material = ((Float)animation.getAnimatedValue()).floatValue();
                if (SeekBar.this.rangeSeekBar != null) {
                    SeekBar.this.rangeSeekBar.invalidate();
                }
            }
        });
        this.anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                SeekBar.this.material = 0.0f;
                if (SeekBar.this.rangeSeekBar != null) {
                    SeekBar.this.rangeSeekBar.invalidate();
                }
            }
        });
        this.anim.start();
    }

    public void setIndicatorText(String text) {
        this.userText2Draw = text;
    }

    public void setIndicatorTextDecimalFormat(String formatPattern) {
        this.indicatorTextDecimalFormat = new DecimalFormat(formatPattern);
    }

    public DecimalFormat getIndicatorTextDecimalFormat() {
        return this.indicatorTextDecimalFormat;
    }

    public void setIndicatorTextStringFormat(String formatPattern) {
        this.indicatorTextStringFormat = formatPattern;
    }

    public int getIndicatorDrawableId() {
        return this.indicatorDrawableId;
    }

    public void setIndicatorDrawableId(@DrawableRes int indicatorDrawableId) {
        if (indicatorDrawableId != 0) {
            this.indicatorDrawableId = indicatorDrawableId;
            this.indicatorBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)indicatorDrawableId);
        }
    }

    public int getIndicatorArrowSize() {
        return this.indicatorArrowSize;
    }

    public void setIndicatorArrowSize(int indicatorArrowSize) {
        this.indicatorArrowSize = indicatorArrowSize;
    }

    public int getIndicatorPaddingLeft() {
        return this.indicatorPaddingLeft;
    }

    public void setIndicatorPaddingLeft(int indicatorPaddingLeft) {
        this.indicatorPaddingLeft = indicatorPaddingLeft;
    }

    public int getIndicatorPaddingRight() {
        return this.indicatorPaddingRight;
    }

    public void setIndicatorPaddingRight(int indicatorPaddingRight) {
        this.indicatorPaddingRight = indicatorPaddingRight;
    }

    public int getIndicatorPaddingTop() {
        return this.indicatorPaddingTop;
    }

    public void setIndicatorPaddingTop(int indicatorPaddingTop) {
        this.indicatorPaddingTop = indicatorPaddingTop;
    }

    public int getIndicatorPaddingBottom() {
        return this.indicatorPaddingBottom;
    }

    public void setIndicatorPaddingBottom(int indicatorPaddingBottom) {
        this.indicatorPaddingBottom = indicatorPaddingBottom;
    }

    public int getIndicatorMargin() {
        return this.indicatorMargin;
    }

    public void setIndicatorMargin(int indicatorMargin) {
        this.indicatorMargin = indicatorMargin;
    }

    public int getIndicatorShowMode() {
        return this.indicatorShowMode;
    }

    public void setIndicatorShowMode(@IndicatorModeDef int indicatorShowMode) {
        this.indicatorShowMode = indicatorShowMode;
    }

    public void showIndicator(boolean isShown) {
        this.isShowIndicator = isShown;
    }

    public boolean isShowIndicator() {
        return this.isShowIndicator;
    }

    public int getIndicatorRawHeight() {
        if (this.indicatorHeight > 0) {
            if (this.indicatorBitmap != null) {
                return this.indicatorHeight + this.indicatorMargin;
            }
            return this.indicatorHeight + this.indicatorArrowSize + this.indicatorMargin;
        }
        if (this.indicatorBitmap != null) {
            return Utils.measureText("8", this.indicatorTextSize).height() + this.indicatorPaddingTop + this.indicatorPaddingBottom + this.indicatorMargin;
        }
        return Utils.measureText("8", this.indicatorTextSize).height() + this.indicatorPaddingTop + this.indicatorPaddingBottom + this.indicatorMargin + this.indicatorArrowSize;
    }

    public int getIndicatorHeight() {
        return this.indicatorHeight;
    }

    public void setIndicatorHeight(int indicatorHeight) {
        this.indicatorHeight = indicatorHeight;
    }

    public int getIndicatorWidth() {
        return this.indicatorWidth;
    }

    public void setIndicatorWidth(int indicatorWidth) {
        this.indicatorWidth = indicatorWidth;
    }

    public int getIndicatorTextSize() {
        return this.indicatorTextSize;
    }

    public void setIndicatorTextSize(int indicatorTextSize) {
        this.indicatorTextSize = indicatorTextSize;
    }

    public int getIndicatorTextColor() {
        return this.indicatorTextColor;
    }

    public void setIndicatorTextColor(@ColorInt int indicatorTextColor) {
        this.indicatorTextColor = indicatorTextColor;
    }

    public int getIndicatorBackgroundColor() {
        return this.indicatorBackgroundColor;
    }

    public void setIndicatorBackgroundColor(@ColorInt int indicatorBackgroundColor) {
        this.indicatorBackgroundColor = indicatorBackgroundColor;
    }

    public int getThumbInactivatedDrawableId() {
        return this.thumbInactivatedDrawableId;
    }

    public void setThumbInactivatedDrawableId(@DrawableRes int thumbInactivatedDrawableId, int width, int height) {
        if (thumbInactivatedDrawableId != 0 && this.getResources() != null) {
            this.thumbInactivatedDrawableId = thumbInactivatedDrawableId;
            this.thumbInactivatedBitmap = Build.VERSION.SDK_INT >= 21 ? Utils.drawableToBitmap(width, height, this.getResources().getDrawable(thumbInactivatedDrawableId, null)) : Utils.drawableToBitmap(width, height, this.getResources().getDrawable(thumbInactivatedDrawableId));
        }
    }

    public int getThumbDrawableId() {
        return this.thumbDrawableId;
    }

    public void setThumbDrawableId(@DrawableRes int thumbDrawableId, int width, int height) {
        if (thumbDrawableId != 0 && this.getResources() != null && width > 0 && height > 0) {
            this.thumbDrawableId = thumbDrawableId;
            this.thumbBitmap = Build.VERSION.SDK_INT >= 21 ? Utils.drawableToBitmap(width, height, this.getResources().getDrawable(thumbDrawableId, null)) : Utils.drawableToBitmap(width, height, this.getResources().getDrawable(thumbDrawableId));
        }
    }

    public void setThumbDrawableId(@DrawableRes int thumbDrawableId) {
        if (this.thumbWidth <= 0 || this.thumbHeight <= 0) {
            throw new IllegalArgumentException("please set thumbWidth and thumbHeight first!");
        }
        if (thumbDrawableId != 0 && this.getResources() != null) {
            this.thumbDrawableId = thumbDrawableId;
            this.thumbBitmap = Build.VERSION.SDK_INT >= 21 ? Utils.drawableToBitmap(this.thumbWidth, this.thumbHeight, this.getResources().getDrawable(thumbDrawableId, null)) : Utils.drawableToBitmap(this.thumbWidth, this.thumbHeight, this.getResources().getDrawable(thumbDrawableId));
        }
    }

    public int getThumbWidth() {
        return this.thumbWidth;
    }

    public void setThumbWidth(int thumbWidth) {
        this.thumbWidth = thumbWidth;
    }

    public float getThumbScaleHeight() {
        return (float)this.thumbHeight * this.thumbScaleRatio;
    }

    public float getThumbScaleWidth() {
        return (float)this.thumbWidth * this.thumbScaleRatio;
    }

    public int getThumbHeight() {
        return this.thumbHeight;
    }

    public void setThumbHeight(int thumbHeight) {
        this.thumbHeight = thumbHeight;
    }

    public float getIndicatorRadius() {
        return this.indicatorRadius;
    }

    public void setIndicatorRadius(float indicatorRadius) {
        this.indicatorRadius = indicatorRadius;
    }

    protected boolean getActivate() {
        return this.isActivate;
    }

    protected void setActivate(boolean activate) {
        this.isActivate = activate;
    }

    public void setTypeface(Typeface typeFace) {
        this.paint.setTypeface(typeFace);
    }

    public float getThumbScaleRatio() {
        return this.thumbScaleRatio;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public float getProgress() {
        float range = this.rangeSeekBar.getMaxProgress() - this.rangeSeekBar.getMinProgress();
        return this.rangeSeekBar.getMinProgress() + range * this.currPercent;
    }

    public static @interface IndicatorModeDef {
    }
}

