/*
 * Decompiled with CFR 0.152.
 */
package com.noober.background.drawable;

import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import com.noober.background.R;
import com.noober.background.drawable.DrawableFactory;
import com.noober.background.drawable.ICreateDrawable;

public class PressDrawableCreator
implements ICreateDrawable {
    private GradientDrawable drawable;
    private TypedArray pressTa;
    private TypedArray typedArray;

    PressDrawableCreator(GradientDrawable drawable, TypedArray typedArray, TypedArray pressTa) {
        this.drawable = drawable;
        this.pressTa = pressTa;
        this.typedArray = typedArray;
    }

    @Override
    public Drawable create() throws Exception {
        StateListDrawable stateListDrawable = new StateListDrawable();
        for (int i = 0; i < this.pressTa.getIndexCount(); ++i) {
            int color;
            int attr2 = this.pressTa.getIndex(i);
            if (attr2 == R.styleable.background_press_bl_pressed_color) {
                color = this.pressTa.getColor(attr2, 0);
                GradientDrawable pressDrawable = DrawableFactory.getDrawable(this.typedArray);
                pressDrawable.setColor(color);
                stateListDrawable.addState(new int[]{16842919}, (Drawable)pressDrawable);
                continue;
            }
            if (attr2 != R.styleable.background_press_bl_unpressed_color) continue;
            color = this.pressTa.getColor(attr2, 0);
            this.drawable.setColor(color);
            stateListDrawable.addState(new int[]{-16842919}, (Drawable)this.drawable);
        }
        return stateListDrawable;
    }
}

