/*
 * Decompiled with CFR 0.152.
 */
package com.eden.common.json;

import com.eden.common.util.EdenUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONElement {
    private Object element;

    public JSONElement(JSONObject object) {
        this.element = object;
    }

    public JSONElement(JSONArray object) {
        this.element = object;
    }

    public JSONElement(String object) {
        this.element = object;
    }

    public JSONElement(byte object) {
        this.element = object;
    }

    public JSONElement(short object) {
        this.element = object;
    }

    public JSONElement(int object) {
        this.element = object;
    }

    public JSONElement(long object) {
        this.element = object;
    }

    public JSONElement(float object) {
        this.element = Float.valueOf(object);
    }

    public JSONElement(double object) {
        this.element = object;
    }

    public JSONElement(boolean object) {
        this.element = object;
    }

    public JSONElement(JSONElement object) {
        this(object.getElement());
    }

    public JSONElement(Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("A JSONElement cannot be null");
        }
        if (!EdenUtils.isJsonAware(object)) {
            throw new IllegalArgumentException("A JSONElement must be an object that is json-aware (JSONObject, JSONArray, JSONElement, String, or primitive)");
        }
        this.element = object;
    }

    public Object getElement() {
        return this.element;
    }

    public String toString() {
        return this.element.toString();
    }

    public JSONElement query(String pointer) {
        try {
            if (!EdenUtils.isEmpty(pointer)) {
                if (!(pointer = pointer.replaceAll("\\.", "/")).startsWith("/")) {
                    pointer = "/" + pointer;
                }
                Object result = null;
                if (this.element instanceof JSONObject) {
                    result = ((JSONObject)this.element).query(pointer);
                } else if (this.element instanceof JSONArray) {
                    result = ((JSONArray)this.element).query(pointer);
                }
                if (result != null) {
                    return new JSONElement(result);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

