/*
 * Decompiled with CFR 0.152.
 */
package com.caseyjbrooks.clog.parseltongue;

import com.caseyjbrooks.clog.Clog;
import com.caseyjbrooks.clog.parseltongue.Spell;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import org.fusesource.jansi.Ansi;

public class TheStandardBookOfSpells {
    @Spell(name="uppercase")
    public static String toUpper(Object data) {
        return data.toString().toUpperCase();
    }

    @Spell(name="lowercase")
    public static String toLower(Object data) {
        return data.toString().toLowerCase();
    }

    @Spell(name="trim")
    public static String trim(Object data) {
        return data.toString().trim();
    }

    @Spell(name="split")
    public static String[] split(Object data, String delimiter) {
        return data.toString().split(delimiter);
    }

    @Spell(name="capitalize")
    public static String capitalize(Object data) {
        String input = data.toString();
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    @Spell(name="repeat")
    public static String repeat(Object[] data, String template) {
        StringBuilder sb = new StringBuilder();
        for (Object token : data) {
            sb.append(Clog.format(template, token));
        }
        return sb.toString();
    }

    @Spell(name="repeat")
    public static String repeat(Iterable data, String template) {
        StringBuilder sb = new StringBuilder();
        for (Object token : data) {
            sb.append(Clog.format(template, token));
        }
        return sb.toString();
    }

    @Spell(name="join")
    public static String join(Object[] data, String separator) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : data) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(separator);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    @Spell(name="join")
    public static String join(Iterable data, String separator) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : data) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(separator);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    @Spell(name="className")
    public static String getClassName(Object data) {
        return data.getClass().getSimpleName();
    }

    @Spell(name="length")
    public static int length(String data) {
        return data.length();
    }

    @Spell(name="length")
    public static int length(Object[] data) {
        return data.length;
    }

    @Spell(name="length")
    public static int length(Collection data) {
        return data.size();
    }

    @Spell(name="date")
    public static Object date(Calendar data) {
        return TheStandardBookOfSpells.date(data, "yyyy/MM/dd HH:mm:ss");
    }

    @Spell(name="date")
    public static Object date(Calendar data, String formatString) {
        if (data == null) {
            data = Calendar.getInstance();
        }
        if (formatString == null || formatString.length() == 0) {
            formatString = "yyyy/MM/dd HH:mm:ss";
        }
        return new SimpleDateFormat(formatString).format(data.getTime());
    }

    @Spell(name="fg")
    public static Object ansiForegroundColorStart(Object data, String color) {
        Ansi.Color ansiColor = Ansi.Color.valueOf((String)color.toUpperCase());
        if (ansiColor != null) {
            return Ansi.ansi().fg(ansiColor);
        }
        return "";
    }

    @Spell(name="bg")
    public static Object ansiBackgroundColorStart(Object data, String color) {
        Ansi.Color ansiColor = Ansi.Color.valueOf((String)color.toUpperCase());
        if (ansiColor != null) {
            return Ansi.ansi().bg(ansiColor);
        }
        return "";
    }

    @Spell(name="reset")
    public static Object ansiStop(Object data) {
        return Ansi.ansi().reset();
    }
}

