/*
 * Decompiled with CFR 0.152.
 */
package com.github.JanLoebel.jsonschemavalidation.provider;

import com.github.JanLoebel.jsonschemavalidation.JsonSchemaValidationException;
import com.github.JanLoebel.jsonschemavalidation.provider.JsonSchemaProvider;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import org.springframework.util.ResourceUtils;

@ConditionalOnProperty(prefix="json.schema.validation", name={"schemaProvider"}, havingValue="default")
@Component
public class DefaultJsonSchemaProvider
implements JsonSchemaProvider {
    @Override
    public JsonSchema loadSchema(String url) {
        InputStream inputStream = this.createInputStream(url);
        JsonSchemaFactory jsonSchemaFactory = this.getJsonSchemaFactory();
        return jsonSchemaFactory.getSchema(inputStream, this.getSchemaValidatorsConfig());
    }

    @Override
    public void handleValidationMessages(Collection<ValidationMessage> validationMessages) {
        if (!validationMessages.isEmpty()) {
            throw new JsonSchemaValidationException(validationMessages);
        }
    }

    protected SchemaValidatorsConfig getSchemaValidatorsConfig() {
        SchemaValidatorsConfig config = new SchemaValidatorsConfig();
        config.setFailFast(false);
        config.setTypeLoose(true);
        config.setHandleNullableField(true);
        return config;
    }

    protected JsonSchemaFactory getJsonSchemaFactory() {
        return JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7);
    }

    private InputStream createInputStream(String url) {
        try {
            if (url.toLowerCase().startsWith("http://") || url.toLowerCase().startsWith("https://")) {
                return new FileInputStream(new File(url));
            }
            if (url.toLowerCase().startsWith("classpath:")) {
                return new ClassPathResource(url.substring("classpath:".length())).getInputStream();
            }
            return new FileInputStream(ResourceUtils.getFile((String)url));
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load url: " + url, e);
        }
    }
}

