/*
 * Decompiled with CFR 0.152.
 */
package com.github.JanLoebel.jsonschemavalidation.advice;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.JanLoebel.jsonschemavalidation.JsonSchemaValidation;
import com.github.JanLoebel.jsonschemavalidation.provider.JsonSchemaProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

@ControllerAdvice
public class JsonValidationRequestBodyControllerAdvice
implements RequestBodyAdvice {
    private ObjectMapper objectMapper;
    private JsonSchemaProvider jsonSchemaProvider;

    public JsonValidationRequestBodyControllerAdvice(ObjectMapper objectMapper, JsonSchemaProvider jsonSchemaProvider) {
        this.objectMapper = objectMapper;
        this.jsonSchemaProvider = jsonSchemaProvider;
    }

    public boolean supports(MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return parameter.hasParameterAnnotation(JsonSchemaValidation.class) || parameter.getNestedParameterType().isAnnotationPresent(JsonSchemaValidation.class);
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        String body = this.toString(inputMessage);
        String uri = this.extractSchemaUri(parameter);
        JsonNode jsonNode = this.objectMapper.readTree(body);
        Set validationMessages = this.jsonSchemaProvider.loadSchema(uri).validate(jsonNode);
        this.jsonSchemaProvider.handleValidationMessages(validationMessages);
        return this.buildHttpInputMessage(body, inputMessage.getHeaders());
    }

    private String extractSchemaUri(MethodParameter parameter) {
        JsonSchemaValidation annotation;
        if (parameter.hasParameterAnnotation(JsonSchemaValidation.class)) {
            annotation = (JsonSchemaValidation)parameter.getParameterAnnotation(JsonSchemaValidation.class);
        } else if (parameter.getNestedParameterType().isAnnotationPresent(JsonSchemaValidation.class)) {
            annotation = parameter.getNestedParameterType().getAnnotation(JsonSchemaValidation.class);
        } else {
            throw new IllegalArgumentException(String.valueOf(parameter));
        }
        return annotation.value();
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    private String toString(HttpInputMessage inputMessage) throws IOException {
        InputStream inputStream = inputMessage.getBody();
        return StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
    }

    private InputStream fromString(String body) {
        return new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8));
    }

    private HttpInputMessage buildHttpInputMessage(final String body, final HttpHeaders httpHeaders) {
        return new HttpInputMessage(){

            public InputStream getBody() {
                return JsonValidationRequestBodyControllerAdvice.this.fromString(body);
            }

            public HttpHeaders getHeaders() {
                return httpHeaders;
            }
        };
    }
}

