/*
 * Decompiled with CFR 0.152.
 */
package com.github.JanLoebel.jsonschemavalidation.provider;

import com.github.JanLoebel.jsonschemavalidation.provider.DefaultJsonSchemaProvider;
import com.networknt.schema.JsonSchema;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CacheableJsonSchemaProvider
extends DefaultJsonSchemaProvider {
    private final Map<String, JsonSchema> cache = new ConcurrentHashMap<String, JsonSchema>();

    @Override
    public JsonSchema loadSchema(String url) {
        if (this.cache.containsKey(url)) {
            return this.cache.get(url);
        }
        return this.putToCache(url, super.loadSchema(url));
    }

    private JsonSchema putToCache(String url, JsonSchema jsonSchema) {
        this.cache.put(url, jsonSchema);
        return jsonSchema;
    }
}

