/*
 * Decompiled with CFR 0.152.
 */
package com.github.ivanshafran.sharedpreferencesmock.internal;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import com.github.ivanshafran.sharedpreferencesmock.internal.SharedPreferencesFactory;
import java.util.HashMap;
import java.util.Map;

public class SPContextWrapperMock
extends ContextWrapper {
    private final Map<String, SharedPreferences> preferencesMap = new HashMap<String, SharedPreferences>();
    private final SharedPreferencesFactory factory;

    public SPContextWrapperMock(@NonNull Context base, @NonNull SharedPreferencesFactory factory) {
        super(base);
        this.factory = factory;
    }

    public SharedPreferences getSharedPreferences(String name, int mode) {
        if (this.preferencesMap.containsKey(name)) {
            return this.preferencesMap.get(name);
        }
        SharedPreferences sharedPreferences = this.factory.create();
        this.preferencesMap.put(name, sharedPreferences);
        return sharedPreferences;
    }

    public boolean deleteSharedPreferences(String name) {
        this.preferencesMap.remove(name);
        return true;
    }
}

