/*
 * Decompiled with CFR 0.152.
 */
package com.github.ivanshafran.sharedpreferencesmock;

import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class SharedPreferencesMock
implements SharedPreferences {
    private final Map<String, Object> preferencesMap = new HashMap<String, Object>();
    private final Set<SharedPreferences.OnSharedPreferenceChangeListener> listeners = new HashSet<SharedPreferences.OnSharedPreferenceChangeListener>();

    SharedPreferencesMock() {
    }

    public Map<String, ?> getAll() {
        return new HashMap<String, Object>(this.preferencesMap);
    }

    @Nullable
    public String getString(String key, @Nullable String defValue) {
        String string = (String)this.preferencesMap.get(key);
        return string != null ? string : defValue;
    }

    @Nullable
    public Set<String> getStringSet(String key, @Nullable Set<String> defValues) {
        Set<String> stringSet = (Set<String>)this.preferencesMap.get(key);
        return stringSet != null ? stringSet : defValues;
    }

    public int getInt(String key, int defValue) {
        Integer integer = (Integer)this.preferencesMap.get(key);
        return integer != null ? integer : defValue;
    }

    public long getLong(String key, long defValue) {
        Long longValue = (Long)this.preferencesMap.get(key);
        return longValue != null ? longValue : defValue;
    }

    public float getFloat(String key, float defValue) {
        Float floatValue = (Float)this.preferencesMap.get(key);
        return floatValue != null ? floatValue.floatValue() : defValue;
    }

    public boolean getBoolean(String key, boolean defValue) {
        Boolean booleanValue = (Boolean)this.preferencesMap.get(key);
        return booleanValue != null ? booleanValue : defValue;
    }

    public boolean contains(String key) {
        return this.preferencesMap.containsKey(key);
    }

    public SharedPreferences.Editor edit() {
        return new EditorImpl();
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.listeners.remove(listener);
    }

    public class EditorImpl
    implements SharedPreferences.Editor {
        private final Map<String, Object> newValuesMap = new HashMap<String, Object>();
        private boolean shouldClear = false;

        public SharedPreferences.Editor putString(String key, @Nullable String value) {
            this.newValuesMap.put(key, value);
            return this;
        }

        public SharedPreferences.Editor putStringSet(String key, @Nullable Set<String> values) {
            this.newValuesMap.put(key, values != null ? new HashSet<String>(values) : null);
            return this;
        }

        public SharedPreferences.Editor putInt(String key, int value) {
            this.newValuesMap.put(key, value);
            return this;
        }

        public SharedPreferences.Editor putLong(String key, long value) {
            this.newValuesMap.put(key, value);
            return this;
        }

        public SharedPreferences.Editor putFloat(String key, float value) {
            this.newValuesMap.put(key, Float.valueOf(value));
            return this;
        }

        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            this.newValuesMap.put(key, value);
            return this;
        }

        public SharedPreferences.Editor remove(String key) {
            this.newValuesMap.put(key, this);
            return this;
        }

        public SharedPreferences.Editor clear() {
            this.shouldClear = true;
            return this;
        }

        public boolean commit() {
            this.apply();
            return true;
        }

        public void apply() {
            this.clearIfNeeded();
            List<String> changedKeys = this.applyNewValues();
            this.notifyListeners(changedKeys);
        }

        private void clearIfNeeded() {
            if (this.shouldClear) {
                this.shouldClear = false;
                SharedPreferencesMock.this.preferencesMap.clear();
            }
        }

        private List<String> applyNewValues() {
            ArrayList<String> changedKeys = new ArrayList<String>();
            for (Map.Entry<String, Object> entry : this.newValuesMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                boolean isSomethingChanged = this.isRemoveValue(value) ? this.removeIfNeeded(key) : this.putValueIfNeeded(key, value);
                if (!isSomethingChanged) continue;
                changedKeys.add(key);
            }
            this.newValuesMap.clear();
            return changedKeys;
        }

        private boolean isRemoveValue(@Nullable Object value) {
            return value == this || value == null;
        }

        private boolean removeIfNeeded(@Nullable String key) {
            if (SharedPreferencesMock.this.preferencesMap.containsKey(key)) {
                SharedPreferencesMock.this.preferencesMap.remove(key);
                return true;
            }
            return false;
        }

        private boolean putValueIfNeeded(@Nullable String key, @NonNull Object value) {
            Object oldValue;
            if (SharedPreferencesMock.this.preferencesMap.containsKey(key) && value.equals(oldValue = SharedPreferencesMock.this.preferencesMap.get(key))) {
                return false;
            }
            SharedPreferencesMock.this.preferencesMap.put(key, value);
            return true;
        }

        private void notifyListeners(@NonNull List<String> changedKeys) {
            for (int i = changedKeys.size() - 1; i >= 0; --i) {
                for (SharedPreferences.OnSharedPreferenceChangeListener listener : SharedPreferencesMock.this.listeners) {
                    listener.onSharedPreferenceChanged((SharedPreferences)SharedPreferencesMock.this, changedKeys.get(i));
                }
            }
            changedKeys.clear();
        }
    }
}

