/*
 * Decompiled with CFR 0.152.
 */
package com.github.islamkhsh.viewpager2;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.github.islamkhsh.R;
import com.github.islamkhsh.viewpager2.CompositeOnPageChangeCallback;
import com.github.islamkhsh.viewpager2.FakeDrag;
import com.github.islamkhsh.viewpager2.PageTransformerAdapter;
import com.github.islamkhsh.viewpager2.ScrollEventAdapter;
import com.github.islamkhsh.viewpager2.StatefulAdapter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ViewPager2
extends ViewGroup {
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SETTLING = 2;
    public static final int OFFSCREEN_PAGE_LIMIT_DEFAULT = 0;
    private final Rect mTmpContainerRect = new Rect();
    private final Rect mTmpChildRect = new Rect();
    private CompositeOnPageChangeCallback mExternalPageChangeCallbacks = new CompositeOnPageChangeCallback(3);
    int mCurrentItem;
    private int mPendingCurrentItem = -1;
    private Parcelable mPendingAdapterState;
    private RecyclerView mRecyclerView;
    private LinearLayoutManager mLayoutManager;
    private PagerSnapHelper mPagerSnapHelper;
    private ScrollEventAdapter mScrollEventAdapter;
    private FakeDrag mFakeDragger;
    private PageTransformerAdapter mPageTransformerAdapter;
    private boolean mUserInputEnabled = true;
    private int mOffscreenPageLimit = 0;

    public ViewPager2(@NonNull Context context) {
        super(context);
        this.initialize(context, null);
    }

    public ViewPager2(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs);
    }

    public ViewPager2(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs);
    }

    @RequiresApi(value=21)
    public ViewPager2(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initialize(context, attrs);
    }

    private void initialize(Context context, AttributeSet attrs) {
        this.mRecyclerView = new RecyclerViewImpl(context);
        this.mRecyclerView.setId(ViewCompat.generateViewId());
        this.mLayoutManager = new LinearLayoutManagerImpl(context);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
        this.setOrientation(context, attrs);
        this.mRecyclerView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mRecyclerView.addOnChildAttachStateChangeListener(this.enforceChildFillListener());
        this.mScrollEventAdapter = new ScrollEventAdapter(this.mLayoutManager);
        this.mFakeDragger = new FakeDrag(this, this.mScrollEventAdapter, this.mRecyclerView);
        this.mPagerSnapHelper = new PagerSnapHelperImpl();
        this.mPagerSnapHelper.attachToRecyclerView(this.mRecyclerView);
        this.mRecyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.mScrollEventAdapter);
        CompositeOnPageChangeCallback pageChangeEventDispatcher = new CompositeOnPageChangeCallback(3);
        this.mScrollEventAdapter.setOnPageChangeCallback(pageChangeEventDispatcher);
        OnPageChangeCallback currentItemUpdater = new OnPageChangeCallback(){

            @Override
            public void onPageSelected(int position) {
                ViewPager2.this.mCurrentItem = position;
            }
        };
        pageChangeEventDispatcher.addOnPageChangeCallback(currentItemUpdater);
        pageChangeEventDispatcher.addOnPageChangeCallback(this.mExternalPageChangeCallbacks);
        this.mPageTransformerAdapter = new PageTransformerAdapter(this.mLayoutManager);
        pageChangeEventDispatcher.addOnPageChangeCallback(this.mPageTransformerAdapter);
        this.attachViewToParent((View)this.mRecyclerView, 0, this.mRecyclerView.getLayoutParams());
    }

    private RecyclerView.OnChildAttachStateChangeListener enforceChildFillListener() {
        return new RecyclerView.OnChildAttachStateChangeListener(){

            public void onChildViewAttachedToWindow(@NonNull View view) {
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
                if (layoutParams.width != -1 || layoutParams.height != -1) {
                    throw new IllegalStateException("Pages must fill the whole ViewPager2 (use match_parent)");
                }
            }

            public void onChildViewDetachedFromWindow(@NonNull View view) {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOrientation(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ViewPager2);
        try {
            this.setOrientation(a.getInt(R.styleable.ViewPager2_android_orientation, 0));
        }
        finally {
            a.recycle();
        }
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.mRecyclerViewId = this.mRecyclerView.getId();
        int n = ss.mCurrentItem = this.mPendingCurrentItem == -1 ? this.mCurrentItem : this.mPendingCurrentItem;
        if (this.mPendingAdapterState != null) {
            ss.mAdapterState = this.mPendingAdapterState;
        } else {
            RecyclerView.Adapter adapter = this.mRecyclerView.getAdapter();
            if (adapter instanceof StatefulAdapter) {
                ss.mAdapterState = ((StatefulAdapter)adapter).saveState();
            }
        }
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mPendingCurrentItem = ss.mCurrentItem;
        this.mPendingAdapterState = ss.mAdapterState;
    }

    private void restorePendingState() {
        if (this.mPendingCurrentItem == -1) {
            return;
        }
        RecyclerView.Adapter adapter = this.getAdapter();
        if (adapter == null) {
            return;
        }
        if (this.mPendingAdapterState != null) {
            if (adapter instanceof StatefulAdapter) {
                ((StatefulAdapter)adapter).restoreState(this.mPendingAdapterState);
            }
            this.mPendingAdapterState = null;
        }
        this.mCurrentItem = Math.max(0, Math.min(this.mPendingCurrentItem, adapter.getItemCount() - 1));
        this.mPendingCurrentItem = -1;
        this.mRecyclerView.scrollToPosition(this.mCurrentItem);
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        Parcelable state = (Parcelable)container.get(this.getId());
        if (state instanceof SavedState) {
            int previousRvId = ((SavedState)state).mRecyclerViewId;
            int currentRvId = this.mRecyclerView.getId();
            container.put(currentRvId, container.get(previousRvId));
            container.remove(previousRvId);
        }
        super.dispatchRestoreInstanceState(container);
        this.restorePendingState();
    }

    public void setAdapter(@Nullable RecyclerView.Adapter adapter) {
        this.mRecyclerView.setAdapter(adapter);
        this.restorePendingState();
    }

    @Nullable
    public RecyclerView.Adapter getAdapter() {
        return this.mRecyclerView.getAdapter();
    }

    public void onViewAdded(View child) {
        throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " does not support direct child views");
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureChild((View)this.mRecyclerView, widthMeasureSpec, heightMeasureSpec);
        int width = this.mRecyclerView.getMeasuredWidth();
        int height = this.mRecyclerView.getMeasuredHeight();
        int childState = this.mRecyclerView.getMeasuredState();
        width += this.getPaddingLeft() + this.getPaddingRight();
        height += this.getPaddingTop() + this.getPaddingBottom();
        width = Math.max(width, this.getSuggestedMinimumWidth());
        height = Math.max(height, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(ViewPager2.resolveSizeAndState((int)width, (int)widthMeasureSpec, (int)childState), ViewPager2.resolveSizeAndState((int)height, (int)heightMeasureSpec, (int)(childState << 16)));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = this.mRecyclerView.getMeasuredWidth();
        int height = this.mRecyclerView.getMeasuredHeight();
        this.mTmpContainerRect.left = this.getPaddingLeft();
        this.mTmpContainerRect.right = r - l - this.getPaddingRight();
        this.mTmpContainerRect.top = this.getPaddingTop();
        this.mTmpContainerRect.bottom = b - t - this.getPaddingBottom();
        Gravity.apply((int)0x800033, (int)width, (int)height, (Rect)this.mTmpContainerRect, (Rect)this.mTmpChildRect);
        this.mRecyclerView.layout(this.mTmpChildRect.left, this.mTmpChildRect.top, this.mTmpChildRect.right, this.mTmpChildRect.bottom);
    }

    int getPageSize() {
        return this.getOrientation() == 0 ? this.getWidth() - this.getPaddingLeft() - this.getPaddingRight() : this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
    }

    public void setOrientation(int orientation) {
        this.mLayoutManager.setOrientation(orientation);
    }

    public int getOrientation() {
        return this.mLayoutManager.getOrientation();
    }

    public void setCurrentItem(int item) {
        this.setCurrentItem(item, true);
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        if (this.isFakeDragging()) {
            throw new IllegalStateException("Cannot change current item when ViewPager2 is fake dragging");
        }
        RecyclerView.Adapter adapter = this.getAdapter();
        if (adapter == null) {
            if (this.mPendingCurrentItem != -1) {
                this.mPendingCurrentItem = Math.max(item, 0);
            }
            return;
        }
        if (adapter.getItemCount() <= 0) {
            return;
        }
        item = Math.max(item, 0);
        if ((item = Math.min(item, adapter.getItemCount() - 1)) == this.mCurrentItem && this.mScrollEventAdapter.isIdle()) {
            return;
        }
        if (item == this.mCurrentItem && smoothScroll) {
            return;
        }
        float previousItem = this.mCurrentItem;
        this.mCurrentItem = item;
        if (!this.mScrollEventAdapter.isIdle()) {
            previousItem = this.mScrollEventAdapter.getRelativeScrollPosition();
        }
        this.mScrollEventAdapter.notifyProgrammaticScroll(item, smoothScroll);
        if (!smoothScroll) {
            this.mRecyclerView.scrollToPosition(item);
            return;
        }
        if (Math.abs((float)item - previousItem) > 3.0f) {
            this.mRecyclerView.scrollToPosition((float)item > previousItem ? item - 3 : item + 3);
            this.mRecyclerView.post((Runnable)new SmoothScrollToPosition(item, this.mRecyclerView));
        } else {
            this.mRecyclerView.smoothScrollToPosition(item);
        }
    }

    public int getCurrentItem() {
        return this.mCurrentItem;
    }

    public int getScrollState() {
        return this.mScrollEventAdapter.getScrollState();
    }

    public boolean beginFakeDrag() {
        return this.mFakeDragger.beginFakeDrag();
    }

    public boolean fakeDragBy(float offsetPxFloat) {
        return this.mFakeDragger.fakeDragBy(offsetPxFloat);
    }

    public boolean endFakeDrag() {
        return this.mFakeDragger.endFakeDrag();
    }

    public boolean isFakeDragging() {
        return this.mFakeDragger.isFakeDragging();
    }

    void snapToPage() {
        View view = this.mPagerSnapHelper.findSnapView((RecyclerView.LayoutManager)this.mLayoutManager);
        if (view == null) {
            return;
        }
        int[] snapDistance = this.mPagerSnapHelper.calculateDistanceToFinalSnap((RecyclerView.LayoutManager)this.mLayoutManager, view);
        if (snapDistance[0] != 0 || snapDistance[1] != 0) {
            this.mRecyclerView.smoothScrollBy(snapDistance[0], snapDistance[1]);
        }
    }

    public void setUserInputEnabled(boolean enabled) {
        this.mUserInputEnabled = enabled;
    }

    public boolean isUserInputEnabled() {
        return this.mUserInputEnabled;
    }

    public void setOffscreenPageLimit(int limit) {
        if (limit < 1 && limit != 0) {
            throw new IllegalArgumentException("Offscreen page limit must be OFFSCREEN_PAGE_LIMIT_DEFAULT or a number > 0");
        }
        this.mOffscreenPageLimit = limit;
        this.mRecyclerView.requestLayout();
    }

    public int getOffscreenPageLimit() {
        return this.mOffscreenPageLimit;
    }

    public void registerOnPageChangeCallback(@NonNull OnPageChangeCallback callback) {
        this.mExternalPageChangeCallbacks.addOnPageChangeCallback(callback);
    }

    public void unregisterOnPageChangeCallback(@NonNull OnPageChangeCallback callback) {
        this.mExternalPageChangeCallbacks.removeOnPageChangeCallback(callback);
    }

    public void setPageTransformer(@Nullable PageTransformer transformer) {
        if (transformer == this.mPageTransformerAdapter.getPageTransformer()) {
            return;
        }
        this.mPageTransformerAdapter.setPageTransformer(transformer);
        this.requestTransform();
    }

    public void requestTransform() {
        if (this.mPageTransformerAdapter.getPageTransformer() == null) {
            return;
        }
        float relativePosition = this.mScrollEventAdapter.getRelativeScrollPosition();
        int position = (int)relativePosition;
        float positionOffset = relativePosition - (float)position;
        int positionOffsetPx = Math.round((float)this.getPageSize() * positionOffset);
        this.mPageTransformerAdapter.onPageScrolled(position, positionOffset, positionOffsetPx);
    }

    public static interface PageTransformer {
        public void transformPage(@NonNull View var1, float var2);
    }

    public static abstract class OnPageChangeCallback {
        public void onPageScrolled(int position, float positionOffset, @Px int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
        }

        public void onPageScrollStateChanged(int state) {
        }
    }

    private static class SmoothScrollToPosition
    implements Runnable {
        private final int mPosition;
        private final RecyclerView mRecyclerView;

        SmoothScrollToPosition(int position, RecyclerView recyclerView) {
            this.mPosition = position;
            this.mRecyclerView = recyclerView;
        }

        @Override
        public void run() {
            this.mRecyclerView.smoothScrollToPosition(this.mPosition);
        }
    }

    private class PagerSnapHelperImpl
    extends PagerSnapHelper {
        PagerSnapHelperImpl() {
        }

        @Nullable
        public View findSnapView(RecyclerView.LayoutManager layoutManager) {
            return ViewPager2.this.isFakeDragging() ? null : super.findSnapView(layoutManager);
        }
    }

    private class LinearLayoutManagerImpl
    extends LinearLayoutManager {
        LinearLayoutManagerImpl(Context context) {
            super(context);
        }

        public boolean performAccessibilityAction(@NonNull RecyclerView.Recycler recycler, @NonNull RecyclerView.State state, int action, @Nullable Bundle args) {
            switch (action) {
                case 4096: 
                case 8192: {
                    if (ViewPager2.this.isUserInputEnabled()) break;
                    return false;
                }
            }
            return super.performAccessibilityAction(recycler, state, action, args);
        }

        public void onInitializeAccessibilityNodeInfo(@NonNull RecyclerView.Recycler recycler, @NonNull RecyclerView.State state, @NonNull AccessibilityNodeInfoCompat info) {
            super.onInitializeAccessibilityNodeInfo(recycler, state, info);
            if (!ViewPager2.this.isUserInputEnabled()) {
                info.removeAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_BACKWARD);
                info.removeAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_FORWARD);
                info.setScrollable(false);
            }
        }

        protected void calculateExtraLayoutSpace(@NonNull RecyclerView.State state, @NonNull int[] extraLayoutSpace) {
            int offscreenSpace;
            int pageLimit = ViewPager2.this.getOffscreenPageLimit();
            if (pageLimit == 0) {
                super.calculateExtraLayoutSpace(state, extraLayoutSpace);
                return;
            }
            extraLayoutSpace[0] = offscreenSpace = ViewPager2.this.getPageSize() * pageLimit;
            extraLayoutSpace[1] = offscreenSpace;
        }
    }

    private class RecyclerViewImpl
    extends RecyclerView {
        RecyclerViewImpl(Context context) {
            super(context);
        }

        public CharSequence getAccessibilityClassName() {
            return "androidx.viewpager.widget.ViewPager";
        }

        public void onInitializeAccessibilityEvent(@NonNull AccessibilityEvent event) {
            super.onInitializeAccessibilityEvent(event);
            event.setFromIndex(ViewPager2.this.mCurrentItem);
            event.setToIndex(ViewPager2.this.mCurrentItem);
        }

        @SuppressLint(value={"ClickableViewAccessibility"})
        public boolean onTouchEvent(MotionEvent event) {
            return ViewPager2.this.isUserInputEnabled() && super.onTouchEvent(event);
        }

        public boolean onInterceptTouchEvent(MotionEvent ev) {
            return ViewPager2.this.isUserInputEnabled() && super.onInterceptTouchEvent(ev);
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        int mRecyclerViewId;
        int mCurrentItem;
        Parcelable mAdapterState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel source, ClassLoader loader) {
                return Build.VERSION.SDK_INT >= 24 ? new SavedState(source, loader) : new SavedState(source);
            }

            public SavedState createFromParcel(Parcel source) {
                return this.createFromParcel(source, null);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        @RequiresApi(value=24)
        SavedState(Parcel source, ClassLoader loader) {
            super(source, loader);
            this.readValues(source, loader);
        }

        SavedState(Parcel source) {
            super(source);
            this.readValues(source, null);
        }

        SavedState(Parcelable superState) {
            super(superState);
        }

        private void readValues(Parcel source, ClassLoader loader) {
            this.mRecyclerViewId = source.readInt();
            this.mCurrentItem = source.readInt();
            this.mAdapterState = source.readParcelable(loader);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.mRecyclerViewId);
            out.writeInt(this.mCurrentItem);
            out.writeParcelable(this.mAdapterState, flags);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScrollState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Orientation {
    }
}

