/*
 * Decompiled with CFR 0.152.
 */
package com.infomaniak.lib.pdfview.util;

import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;

public class TouchUtils {
    public static final int DIRECTION_SCROLLING_LEFT = -1;
    public static final int DIRECTION_SCROLLING_RIGHT = 1;
    static final int DIRECTION_SCROLLING_TOP = -1;
    static final int DIRECTION_SCROLLING_BOTTOM = 1;

    private TouchUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void handleTouchPriority(MotionEvent event, View view, int pointerCount, boolean shouldOverrideTouchPriority, boolean isZooming) {
        boolean canScrollVertically;
        ViewParent viewToDisableTouch = TouchUtils.getViewToDisableTouch(view);
        if (viewToDisableTouch == null) {
            return;
        }
        boolean canScrollHorizontally = view.canScrollHorizontally(1) && view.canScrollHorizontally(-1);
        boolean bl = canScrollVertically = view.canScrollVertically(-1) && view.canScrollVertically(1);
        if (shouldOverrideTouchPriority) {
            viewToDisableTouch.requestDisallowInterceptTouchEvent(false);
            ViewParent viewPager = TouchUtils.getViewPager(view);
            if (viewPager != null) {
                viewPager.requestDisallowInterceptTouchEvent(true);
            }
        } else if (event.getPointerCount() >= pointerCount || canScrollHorizontally || canScrollVertically) {
            int action = event.getAction();
            if (action == 1) {
                viewToDisableTouch.requestDisallowInterceptTouchEvent(false);
            } else if (action == 0 || action == 2 || isZooming) {
                viewToDisableTouch.requestDisallowInterceptTouchEvent(true);
            }
        }
    }

    private static ViewParent getViewToDisableTouch(View startingView) {
        ViewParent parentView;
        for (parentView = startingView.getParent(); parentView != null && !(parentView instanceof RecyclerView); parentView = parentView.getParent()) {
        }
        return parentView;
    }

    private static ViewParent getViewPager(View startingView) {
        ViewParent parentView;
        for (parentView = startingView.getParent(); parentView != null && !(parentView instanceof ViewPager2); parentView = parentView.getParent()) {
        }
        return parentView;
    }
}

