/*
 * Decompiled with CFR 0.152.
 */
package com.infomaniak.lib.pdfview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.DrawFilter;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.HandlerThread;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.RelativeLayout;
import androidx.annotation.FloatRange;
import com.infomaniak.lib.pdfview.AnimationManager;
import com.infomaniak.lib.pdfview.CacheManager;
import com.infomaniak.lib.pdfview.DecodingAsyncTask;
import com.infomaniak.lib.pdfview.DragPinchManager;
import com.infomaniak.lib.pdfview.PagesLoader;
import com.infomaniak.lib.pdfview.PdfFile;
import com.infomaniak.lib.pdfview.RenderingHandler;
import com.infomaniak.lib.pdfview.exception.PageRenderingException;
import com.infomaniak.lib.pdfview.link.DefaultLinkHandler;
import com.infomaniak.lib.pdfview.link.LinkHandler;
import com.infomaniak.lib.pdfview.listener.Callbacks;
import com.infomaniak.lib.pdfview.listener.OnAttachCompleteListener;
import com.infomaniak.lib.pdfview.listener.OnDetachCompleteListener;
import com.infomaniak.lib.pdfview.listener.OnDrawListener;
import com.infomaniak.lib.pdfview.listener.OnErrorListener;
import com.infomaniak.lib.pdfview.listener.OnLoadCompleteListener;
import com.infomaniak.lib.pdfview.listener.OnLongPressListener;
import com.infomaniak.lib.pdfview.listener.OnPageChangeListener;
import com.infomaniak.lib.pdfview.listener.OnPageErrorListener;
import com.infomaniak.lib.pdfview.listener.OnPageScrollListener;
import com.infomaniak.lib.pdfview.listener.OnReadyForPrintingListener;
import com.infomaniak.lib.pdfview.listener.OnRenderListener;
import com.infomaniak.lib.pdfview.listener.OnTapListener;
import com.infomaniak.lib.pdfview.model.PagePart;
import com.infomaniak.lib.pdfview.scroll.ScrollHandle;
import com.infomaniak.lib.pdfview.source.AssetSource;
import com.infomaniak.lib.pdfview.source.ByteArraySource;
import com.infomaniak.lib.pdfview.source.DocumentSource;
import com.infomaniak.lib.pdfview.source.FileSource;
import com.infomaniak.lib.pdfview.source.InputStreamSource;
import com.infomaniak.lib.pdfview.source.UriSource;
import com.infomaniak.lib.pdfview.util.FitPolicy;
import com.infomaniak.lib.pdfview.util.MathUtils;
import com.infomaniak.lib.pdfview.util.SnapEdge;
import com.infomaniak.lib.pdfview.util.Util;
import com.shockwave.pdfium.PdfDocument;
import com.shockwave.pdfium.PdfiumCore;
import com.shockwave.pdfium.util.Size;
import com.shockwave.pdfium.util.SizeF;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PDFView
extends RelativeLayout {
    private static final String TAG = PDFView.class.getSimpleName();
    public static final float DEFAULT_MAX_SCALE = 3.0f;
    public static final float DEFAULT_MID_SCALE = 1.75f;
    public static final float DEFAULT_MIN_SCALE = 0.93f;
    private float minZoom = 0.93f;
    private float midZoom = 1.75f;
    private float maxZoom = 3.0f;
    private ScrollDir scrollDir = ScrollDir.NONE;
    CacheManager cacheManager;
    private AnimationManager animationManager;
    private DragPinchManager dragPinchManager;
    PdfFile pdfFile;
    private int currentPage;
    private float currentXOffset = 0.0f;
    private float currentYOffset = 0.0f;
    private float zoom = this.minZoom;
    private boolean recycled = true;
    private State state = State.DEFAULT;
    private DecodingAsyncTask decodingAsyncTask;
    private HandlerThread renderingHandlerThread;
    RenderingHandler renderingHandler;
    private PagesLoader pagesLoader;
    Callbacks callbacks = new Callbacks();
    private Paint paint;
    private Paint debugPaint;
    private FitPolicy pageFitPolicy = FitPolicy.WIDTH;
    private boolean fitEachPage = false;
    private int defaultPage = 0;
    private boolean swipeVertical = true;
    private boolean enableSwipe = true;
    private boolean doubleTapEnabled = true;
    private boolean nightMode = false;
    private boolean pageSnap = true;
    private PdfiumCore pdfiumCore;
    private ScrollHandle scrollHandle;
    private boolean isScrollHandleInit = false;
    private boolean bestQuality = false;
    private float thumbnailRatio = 0.3f;
    private int horizontalBorder = 0;
    private int verticalBorder = 0;
    private boolean annotationRendering = false;
    private boolean renderDuringScale = false;
    private boolean enableAntialiasing = true;
    private PaintFlagsDrawFilter antialiasFilter = new PaintFlagsDrawFilter(0, 3);
    private int pageSeparatorSpacing = 0;
    private int startSpacing = 0;
    private int endSpacing = 0;
    private boolean autoSpacing = false;
    private boolean pageFling = true;
    private List<Integer> onDrawPagesNums = new ArrayList<Integer>(10);
    private boolean hasSize = false;
    private Configurator waitingDocumentConfigurator;

    ScrollHandle getScrollHandle() {
        return this.scrollHandle;
    }

    public PDFView(Context context, AttributeSet set) {
        super(context, set);
        if (this.isInEditMode()) {
            return;
        }
        this.cacheManager = new CacheManager();
        this.animationManager = new AnimationManager(this);
        this.dragPinchManager = new DragPinchManager(this, this.animationManager);
        this.pagesLoader = new PagesLoader(this);
        this.paint = new Paint();
        this.debugPaint = new Paint();
        this.debugPaint.setStyle(Paint.Style.STROKE);
        this.pdfiumCore = new PdfiumCore(context);
        this.setWillNotDraw(false);
    }

    public List<Bitmap> getPagesAsBitmaps() {
        ArrayList<Bitmap> bitmaps = new ArrayList<Bitmap>();
        List<PagePart> pageParts = this.cacheManager.getThumbnails();
        for (int i = 0; i < pageParts.size(); ++i) {
            bitmaps.add(pageParts.get(i).getRenderedBitmap());
        }
        return bitmaps;
    }

    private void load(DocumentSource docSource, String password) {
        this.load(docSource, password, null);
    }

    private void load(DocumentSource docSource, String password, int[] userPages) {
        if (!this.recycled) {
            throw new IllegalStateException("Don't call load on a PDF View without recycling it first.");
        }
        this.recycled = false;
        this.decodingAsyncTask = new DecodingAsyncTask(docSource, password, userPages, this, this.pdfiumCore);
        this.decodingAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    public boolean isShown() {
        return this.state == State.SHOWN;
    }

    public void jumpTo(int page, boolean withAnimation) {
        if (this.pdfFile == null) {
            return;
        }
        page = this.pdfFile.determineValidPageNumberFrom(page);
        float offset = -this.pdfFile.getPageOffset(page, this.zoom) + (float)this.pageSeparatorSpacing + (float)this.startSpacing;
        if (this.swipeVertical) {
            if (withAnimation) {
                this.animationManager.startYAnimation(this.currentYOffset, offset);
            } else {
                this.moveTo(this.currentXOffset, offset, false);
            }
        } else if (withAnimation) {
            this.animationManager.startXAnimation(this.currentXOffset, offset);
        } else {
            this.moveTo(offset, this.currentYOffset, false);
        }
        this.showPage(page);
    }

    public void jumpTo(int page) {
        this.jumpTo(page, false);
    }

    void showPage(int pageNb) {
        if (this.recycled) {
            return;
        }
        this.currentPage = pageNb = this.pdfFile.determineValidPageNumberFrom(pageNb);
        this.loadPages();
        if (this.scrollHandle != null && !this.documentFitsView()) {
            this.scrollHandle.setPageNum(this.currentPage + 1);
        }
        this.callbacks.callOnPageChange(this.currentPage, this.pdfFile.getPagesCount());
    }

    public float getPositionOffset() {
        float offset = this.swipeVertical ? -this.currentYOffset / (this.pdfFile.getDocLen(this.zoom) - (float)this.getHeight()) : -this.currentXOffset / (this.pdfFile.getDocLen(this.zoom) - (float)this.getWidth());
        return MathUtils.limit(offset, 0.0f, 1.0f);
    }

    public void setPositionOffset(float progress, boolean moveHandle) {
        if (this.swipeVertical) {
            this.moveTo(this.currentXOffset, (-this.pdfFile.getDocLen(this.zoom) + (float)this.getHeight()) * progress, moveHandle);
        } else {
            this.moveTo((-this.pdfFile.getDocLen(this.zoom) + (float)this.getWidth()) * progress, this.currentYOffset, moveHandle);
        }
        this.loadPageByOffset();
    }

    public void setPositionOffset(float progress) {
        this.setPositionOffset(progress, true);
    }

    public void stopFling() {
        this.animationManager.stopFling();
    }

    public int getPageCount() {
        if (this.pdfFile == null) {
            return 0;
        }
        return this.pdfFile.getPagesCount();
    }

    public void setSwipeEnabled(boolean enableSwipe) {
        this.enableSwipe = enableSwipe;
    }

    public void setNightMode(boolean nightMode) {
        this.nightMode = nightMode;
        if (nightMode) {
            ColorMatrix colorMatrixInverted = new ColorMatrix(new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 255.0f, 0.0f, -1.0f, 0.0f, 0.0f, 255.0f, 0.0f, 0.0f, -1.0f, 0.0f, 255.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
            ColorMatrixColorFilter filter = new ColorMatrixColorFilter(colorMatrixInverted);
            this.paint.setColorFilter((ColorFilter)filter);
        } else {
            this.paint.setColorFilter(null);
        }
    }

    void enableDoubleTap(boolean enableDoubleTap) {
        this.doubleTapEnabled = enableDoubleTap;
    }

    boolean isDoubleTapEnabled() {
        return this.doubleTapEnabled;
    }

    void onPageError(PageRenderingException ex) {
        if (!this.callbacks.callOnPageError(ex.getPage(), ex.getCause())) {
            Log.e((String)TAG, (String)("Cannot open page " + ex.getPage()), (Throwable)ex.getCause());
        }
    }

    public void recycle() {
        this.waitingDocumentConfigurator = null;
        this.animationManager.stopAll();
        this.dragPinchManager.disable();
        if (this.renderingHandler != null) {
            this.renderingHandler.stop();
            this.renderingHandler.removeMessages(1);
        }
        if (this.decodingAsyncTask != null) {
            this.decodingAsyncTask.cancel(true);
        }
        this.cacheManager.recycle();
        if (this.scrollHandle != null && this.isScrollHandleInit) {
            this.scrollHandle.destroyLayout();
        }
        if (this.pdfFile != null) {
            this.pdfFile.dispose();
            this.pdfFile = null;
        }
        this.renderingHandler = null;
        this.scrollHandle = null;
        this.isScrollHandleInit = false;
        this.currentYOffset = 0.0f;
        this.currentXOffset = 0.0f;
        this.zoom = 0.93f;
        this.recycled = true;
        this.callbacks.clear();
        this.state = State.DEFAULT;
    }

    public boolean isRecycled() {
        return this.recycled;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.isInEditMode()) {
            return;
        }
        this.animationManager.computeFling();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.callbacks.callOnAttachComplete();
        if (this.renderingHandlerThread == null) {
            this.renderingHandlerThread = new HandlerThread("PDF renderer");
        }
    }

    protected void onDetachedFromWindow() {
        this.callbacks.callOnDetachComplete();
        this.recycle();
        if (this.renderingHandlerThread != null) {
            if (Build.VERSION.SDK_INT >= 18) {
                this.renderingHandlerThread.quitSafely();
            } else {
                this.renderingHandlerThread.quit();
            }
            this.renderingHandlerThread = null;
        }
        super.onDetachedFromWindow();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        float relativeCenterPointInStripYOffset;
        float relativeCenterPointInStripXOffset;
        this.hasSize = true;
        if (this.waitingDocumentConfigurator != null) {
            this.waitingDocumentConfigurator.load();
        }
        if (this.isInEditMode() || this.state != State.SHOWN) {
            return;
        }
        float centerPointInStripXOffset = -this.currentXOffset + (float)oldw * 0.5f;
        float centerPointInStripYOffset = -this.currentYOffset + (float)oldh * 0.5f;
        if (this.swipeVertical) {
            relativeCenterPointInStripXOffset = centerPointInStripXOffset / this.pdfFile.getMaxPageWidth();
            relativeCenterPointInStripYOffset = centerPointInStripYOffset / this.pdfFile.getDocLen(this.zoom);
        } else {
            relativeCenterPointInStripXOffset = centerPointInStripXOffset / this.pdfFile.getDocLen(this.zoom);
            relativeCenterPointInStripYOffset = centerPointInStripYOffset / this.pdfFile.getMaxPageHeight();
        }
        this.animationManager.stopAll();
        this.pdfFile.recalculatePageSizes(new Size(w, h));
        if (this.swipeVertical) {
            this.currentXOffset = -relativeCenterPointInStripXOffset * this.pdfFile.getMaxPageWidth() + (float)w * 0.5f;
            this.currentYOffset = -relativeCenterPointInStripYOffset * this.pdfFile.getDocLen(this.zoom) + (float)h * 0.5f;
        } else {
            this.currentXOffset = -relativeCenterPointInStripXOffset * this.pdfFile.getDocLen(this.zoom) + (float)w * 0.5f;
            this.currentYOffset = -relativeCenterPointInStripYOffset * this.pdfFile.getMaxPageHeight() + (float)h * 0.5f;
        }
        this.moveTo(this.currentXOffset, this.currentYOffset);
        this.loadPageByOffset();
    }

    public boolean canScrollHorizontally(int direction) {
        if (this.pdfFile == null) {
            return true;
        }
        if (this.swipeVertical) {
            if (direction < 0 && this.currentXOffset < 0.0f) {
                return true;
            }
            if (direction > 0 && this.currentXOffset + this.toCurrentScale(this.pdfFile.getMaxPageWidth()) > (float)this.getWidth()) {
                return true;
            }
        } else {
            if (direction < 0 && this.currentXOffset < 0.0f) {
                return true;
            }
            if (direction > 0 && this.currentXOffset + this.pdfFile.getDocLen(this.zoom) > (float)this.getWidth()) {
                return true;
            }
        }
        return false;
    }

    public boolean canScrollVertically(int direction) {
        if (this.pdfFile == null) {
            return true;
        }
        if (this.swipeVertical) {
            if (direction < 0 && this.currentYOffset < 0.0f) {
                return true;
            }
            if (direction > 0 && this.currentYOffset + this.pdfFile.getDocLen(this.zoom) > (float)this.getHeight()) {
                return true;
            }
        } else {
            if (direction < 0 && this.currentYOffset < 0.0f) {
                return true;
            }
            if (direction > 0 && this.currentYOffset + this.toCurrentScale(this.pdfFile.getMaxPageHeight()) > (float)this.getHeight()) {
                return true;
            }
        }
        return false;
    }

    protected void onDraw(Canvas canvas) {
        Drawable bg;
        if (this.isInEditMode()) {
            return;
        }
        if (this.enableAntialiasing) {
            canvas.setDrawFilter((DrawFilter)this.antialiasFilter);
        }
        if ((bg = this.getBackground()) == null) {
            canvas.drawColor(this.nightMode ? -16777216 : -1);
        } else {
            bg.draw(canvas);
        }
        if (this.recycled) {
            return;
        }
        if (this.state != State.SHOWN) {
            return;
        }
        canvas.translate(this.currentXOffset, this.currentYOffset);
        for (PagePart part : this.cacheManager.getThumbnails()) {
            this.drawPart(canvas, part);
        }
        for (PagePart part : this.cacheManager.getPageParts()) {
            this.drawPart(canvas, part);
            if (this.callbacks.getOnDrawAll() == null || this.onDrawPagesNums.contains(part.getPage())) continue;
            this.onDrawPagesNums.add(part.getPage());
        }
        for (Integer page : this.onDrawPagesNums) {
            this.drawWithListener(canvas, page, this.callbacks.getOnDrawAll());
        }
        this.onDrawPagesNums.clear();
        this.drawWithListener(canvas, this.currentPage, this.callbacks.getOnDraw());
        canvas.translate(-this.currentXOffset, -this.currentYOffset);
    }

    private void drawWithListener(Canvas canvas, int page, OnDrawListener listener) {
        if (listener != null) {
            float translateY;
            float translateX;
            if (this.swipeVertical) {
                translateX = 0.0f;
                translateY = this.pdfFile.getPageOffset(page, this.zoom);
            } else {
                translateY = 0.0f;
                translateX = this.pdfFile.getPageOffset(page, this.zoom);
            }
            canvas.translate(translateX, translateY);
            SizeF size = this.pdfFile.getPageSize(page);
            listener.onLayerDrawn(canvas, this.toCurrentScale(size.getWidth()), this.toCurrentScale(size.getHeight()), page);
            canvas.translate(-translateX, -translateY);
        }
    }

    private void drawPart(Canvas canvas, PagePart part) {
        RectF pageRelativeBounds = part.getPageRelativeBounds();
        Bitmap renderedBitmap = part.getRenderedBitmap();
        if (renderedBitmap.isRecycled()) {
            return;
        }
        float localTranslationX = 0.0f;
        float localTranslationY = 0.0f;
        SizeF size = this.pdfFile.getPageSize(part.getPage());
        if (this.swipeVertical) {
            localTranslationY = this.pdfFile.getPageOffset(part.getPage(), this.zoom);
            float maxWidth = this.pdfFile.getMaxPageWidth();
            localTranslationX = this.toCurrentScale(maxWidth - size.getWidth()) / 2.0f;
        } else {
            localTranslationX = this.pdfFile.getPageOffset(part.getPage(), this.zoom);
            float maxHeight = this.pdfFile.getMaxPageHeight();
            localTranslationY = this.toCurrentScale(maxHeight - size.getHeight()) / 2.0f;
        }
        canvas.translate(localTranslationX, localTranslationY);
        Rect srcRect = new Rect(0, 0, renderedBitmap.getWidth(), renderedBitmap.getHeight());
        float offsetX = this.toCurrentScale(pageRelativeBounds.left * size.getWidth());
        float offsetY = this.toCurrentScale(pageRelativeBounds.top * size.getHeight());
        float width = this.toCurrentScale(pageRelativeBounds.width() * size.getWidth());
        float height = this.toCurrentScale(pageRelativeBounds.height() * size.getHeight());
        RectF dstRect = new RectF((float)((int)offsetX), (float)((int)offsetY), (float)((int)(offsetX + width)), (float)((int)(offsetY + height)));
        float translationX = this.currentXOffset + localTranslationX;
        float translationY = this.currentYOffset + localTranslationY;
        if (translationX + dstRect.left >= (float)this.getWidth() || translationX + dstRect.right <= 0.0f || translationY + dstRect.top >= (float)this.getHeight() || translationY + dstRect.bottom <= 0.0f) {
            canvas.translate(-localTranslationX, -localTranslationY);
            return;
        }
        canvas.drawBitmap(renderedBitmap, srcRect, dstRect, this.paint);
        canvas.translate(-localTranslationX, -localTranslationY);
    }

    public void loadPages() {
        if (this.pdfFile == null || this.renderingHandler == null) {
            return;
        }
        this.renderingHandler.removeMessages(1);
        this.cacheManager.makeANewSet();
        this.pagesLoader.loadPages();
        this.redraw();
    }

    public void loadPagesForPrinting() {
        if (this.pdfFile == null || this.renderingHandler == null) {
            return;
        }
        this.renderingHandler.removeMessages(1);
        this.cacheManager.makeANewSet();
        this.pagesLoader.loadPagesForPrinting(this.getPageCount());
    }

    void loadComplete(PdfFile pdfFile) {
        this.state = State.LOADED;
        this.pdfFile = pdfFile;
        if (this.renderingHandlerThread == null) {
            return;
        }
        if (!this.renderingHandlerThread.isAlive()) {
            this.renderingHandlerThread.start();
        }
        this.renderingHandler = new RenderingHandler(this.renderingHandlerThread.getLooper(), this);
        this.renderingHandler.start();
        if (this.scrollHandle != null) {
            this.scrollHandle.setupLayout(this);
            this.isScrollHandleInit = true;
        }
        this.dragPinchManager.enable();
        this.callbacks.callOnLoadComplete(pdfFile.getPagesCount());
        this.jumpTo(this.defaultPage, false);
    }

    void loadError(Throwable t) {
        this.state = State.ERROR;
        OnErrorListener onErrorListener = this.callbacks.getOnError();
        this.recycle();
        this.invalidate();
        if (onErrorListener != null) {
            onErrorListener.onError(t);
        } else {
            Log.e((String)"PDFView", (String)"load pdf error", (Throwable)t);
        }
    }

    void redraw() {
        this.invalidate();
    }

    public void onBitmapRendered(PagePart part, boolean isForPrinting) {
        if (this.state == State.LOADED) {
            this.state = State.SHOWN;
            this.callbacks.callOnRender(this.pdfFile.getPagesCount());
        }
        if (part.isThumbnail()) {
            this.cacheManager.cacheThumbnail(part, isForPrinting);
            if (isForPrinting && this.pdfFile.getPagesCount() - 1 == part.getPage()) {
                this.callbacks.callsOnReadyForPrinting(this.getPagesAsBitmaps());
            }
        } else {
            this.cacheManager.cachePart(part);
        }
        this.redraw();
    }

    public void moveTo(float offsetX, float offsetY) {
        this.moveTo(offsetX, offsetY, true);
    }

    public void moveTo(float offsetX, float offsetY, boolean moveHandle) {
        if (this.swipeVertical) {
            float scaledPageWidth = this.toCurrentScale(this.pdfFile.getMaxPageWidth());
            if (scaledPageWidth < (float)this.getWidth()) {
                offsetX = (float)this.getWidth() / 2.0f - scaledPageWidth / 2.0f;
            } else if (offsetX > (float)this.horizontalBorder) {
                offsetX = this.horizontalBorder;
            } else if (offsetX + scaledPageWidth + (float)this.horizontalBorder < (float)this.getWidth()) {
                offsetX = (float)this.getWidth() - scaledPageWidth - (float)this.horizontalBorder;
            }
            float contentHeight = this.pdfFile.getDocLen(this.zoom);
            if (contentHeight < (float)this.getHeight()) {
                offsetY = ((float)this.getHeight() - contentHeight) / 2.0f;
            } else {
                float maxOffsetY = this.toCurrentScale((float)this.verticalBorder * 2.0f);
                if (offsetY > maxOffsetY) {
                    offsetY = maxOffsetY;
                } else if (offsetY < this.getMinOffsetY()) {
                    offsetY = this.getMinOffsetY();
                }
            }
            this.scrollDir = offsetY < this.currentYOffset ? ScrollDir.END : (offsetY > this.currentYOffset ? ScrollDir.START : ScrollDir.NONE);
        } else {
            float scaledPageHeight = this.toCurrentScale(this.pdfFile.getMaxPageHeight());
            if (scaledPageHeight < (float)this.getHeight()) {
                offsetY = (float)this.getHeight() / 2.0f - scaledPageHeight / 2.0f;
            } else if (offsetY > (float)this.horizontalBorder) {
                offsetY = this.horizontalBorder;
            } else if (offsetY + scaledPageHeight + (float)this.horizontalBorder < (float)this.getHeight()) {
                offsetY = (float)this.getHeight() - scaledPageHeight - (float)this.horizontalBorder;
            }
            float contentWidth = this.pdfFile.getDocLen(this.zoom);
            if (contentWidth < (float)this.getWidth()) {
                offsetX = ((float)this.getWidth() - contentWidth) / 2.0f;
            } else {
                float maxOffsetX = this.toCurrentScale((float)this.horizontalBorder * 2.0f);
                if (offsetX > maxOffsetX) {
                    offsetX = maxOffsetX;
                } else if (offsetX < this.getMinOffsetX()) {
                    offsetX = this.getMinOffsetX();
                }
            }
            this.scrollDir = offsetX < this.currentXOffset ? ScrollDir.END : (offsetX > this.currentXOffset ? ScrollDir.START : ScrollDir.NONE);
        }
        this.currentXOffset = offsetX;
        this.currentYOffset = offsetY;
        float positionOffset = this.getPositionOffset();
        if (moveHandle && this.scrollHandle != null && !this.documentFitsView()) {
            this.scrollHandle.setScroll(positionOffset);
        }
        this.callbacks.callOnPageScroll(this.getCurrentPage(), positionOffset);
        this.redraw();
    }

    void loadPageByOffset() {
        float screenCenter;
        float offset;
        if (0 == this.pdfFile.getPagesCount()) {
            return;
        }
        if (this.swipeVertical) {
            offset = this.currentYOffset;
            screenCenter = (float)this.getHeight() / 2.0f;
        } else {
            offset = this.currentXOffset;
            screenCenter = (float)this.getWidth() / 2.0f;
        }
        int page = this.pdfFile.getPageAtOffset(-(offset - screenCenter), this.zoom);
        if (page >= 0 && page <= this.pdfFile.getPagesCount() - 1 && page != this.getCurrentPage()) {
            this.showPage(page);
        } else {
            this.loadPages();
        }
    }

    private float getMinOffsetX() {
        return (float)this.getWidth() - this.toCurrentScale(this.endSpacing) - this.toCurrentScale((float)this.horizontalBorder * 2.0f) - this.pdfFile.getDocLen(this.zoom);
    }

    private float getMinOffsetY() {
        return (float)this.getHeight() - this.toCurrentScale(this.endSpacing) - this.toCurrentScale((float)this.verticalBorder * 2.0f) - this.pdfFile.getDocLen(this.zoom);
    }

    public int getDocumentLength() {
        if (this.swipeVertical) {
            return (int)((float)this.getHeight() - this.pdfFile.getDocLen(this.zoom));
        }
        return (int)((float)this.getWidth() - this.pdfFile.getDocLen(this.zoom));
    }

    public void performPageSnap() {
        if (!this.pageSnap || this.pdfFile == null || this.pdfFile.getPagesCount() == 0) {
            return;
        }
        int centerPage = this.findFocusPage(this.currentXOffset, this.currentYOffset);
        SnapEdge edge = this.findSnapEdge(centerPage);
        if (edge == SnapEdge.NONE) {
            return;
        }
        float offset = this.snapOffsetForPage(centerPage, edge);
        if (this.swipeVertical) {
            this.animationManager.startYAnimation(this.currentYOffset, -offset);
        } else {
            this.animationManager.startXAnimation(this.currentXOffset, -offset);
        }
    }

    SnapEdge findSnapEdge(int page) {
        float pageLength;
        if (!this.pageSnap || page < 0) {
            return SnapEdge.NONE;
        }
        float currentOffset = this.swipeVertical ? this.currentYOffset : this.currentXOffset;
        float offset = -this.pdfFile.getPageOffset(page, this.zoom);
        int length = this.swipeVertical ? this.getHeight() : this.getWidth();
        if ((float)length >= (pageLength = this.pdfFile.getPageLength(page, this.zoom))) {
            return SnapEdge.CENTER;
        }
        if (currentOffset >= offset) {
            return SnapEdge.START;
        }
        if (offset - pageLength > currentOffset - (float)length) {
            return SnapEdge.END;
        }
        return SnapEdge.NONE;
    }

    float snapOffsetForPage(int pageIndex, SnapEdge edge) {
        float offset = this.pdfFile.getPageOffset(pageIndex, this.zoom);
        float length = this.swipeVertical ? (float)this.getHeight() : (float)this.getWidth();
        float pageLength = this.pdfFile.getPageLength(pageIndex, this.zoom);
        if (edge == SnapEdge.CENTER) {
            offset = offset - length / 2.0f + pageLength / 2.0f;
        } else if (edge == SnapEdge.END) {
            offset = offset - length + pageLength;
        }
        return offset;
    }

    int findFocusPage(float xOffset, float yOffset) {
        float length;
        float currOffset = this.swipeVertical ? yOffset : xOffset;
        float f = length = this.swipeVertical ? (float)this.getHeight() : (float)this.getWidth();
        if (currOffset > -1.0f) {
            return 0;
        }
        if (currOffset < -this.pdfFile.getDocLen(this.zoom) + length + 1.0f) {
            return this.pdfFile.getPagesCount() - 1;
        }
        float center = currOffset - length / 2.0f;
        return this.pdfFile.getPageAtOffset(-center, this.zoom);
    }

    public void setTouchPriority(boolean hasPriority) {
        this.dragPinchManager.setHasTouchPriority(hasPriority);
    }

    public boolean pageFillsScreen() {
        float start = -this.pdfFile.getPageOffset(this.currentPage, this.zoom);
        float end = start - this.pdfFile.getPageLength(this.currentPage, this.zoom);
        if (this.isSwipeVertical()) {
            return start > this.currentYOffset && end < this.currentYOffset - (float)this.getHeight();
        }
        return start > this.currentXOffset && end < this.currentXOffset - (float)this.getWidth();
    }

    public void moveRelativeTo(float dx, float dy) {
        this.moveTo(this.currentXOffset + dx, this.currentYOffset + dy);
    }

    public void zoomTo(float zoom) {
        this.zoom = zoom;
    }

    public void zoomCenteredTo(float zoom, PointF pivot) {
        float dzoom = zoom / this.zoom;
        this.zoomTo(zoom);
        float baseX = this.currentXOffset * dzoom;
        float baseY = this.currentYOffset * dzoom;
        this.moveTo(baseX += pivot.x - pivot.x * dzoom, baseY += pivot.y - pivot.y * dzoom);
    }

    public void zoomCenteredRelativeTo(float dzoom, PointF pivot) {
        this.zoomCenteredTo(this.zoom * dzoom, pivot);
    }

    public boolean documentFitsView() {
        float len = this.pdfFile.getDocLen(1.0f);
        if (this.swipeVertical) {
            return len < (float)this.getHeight();
        }
        return len < (float)this.getWidth();
    }

    public void fitToWidth(int page) {
        if (this.state != State.SHOWN) {
            Log.e((String)TAG, (String)"Cannot fit, document not rendered yet");
            return;
        }
        this.zoomTo((float)this.getWidth() / this.pdfFile.getPageSize(page).getWidth());
        this.jumpTo(page);
    }

    public SizeF getPageSize(int pageIndex) {
        if (this.pdfFile == null) {
            return new SizeF(0.0f, 0.0f);
        }
        return this.pdfFile.getPageSize(pageIndex);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public float getCurrentXOffset() {
        return this.currentXOffset;
    }

    public float getCurrentYOffset() {
        return this.currentYOffset;
    }

    public float toRealScale(float size) {
        return size / this.zoom;
    }

    public float toCurrentScale(float size) {
        return size * this.zoom;
    }

    public float getZoom() {
        return this.zoom;
    }

    public boolean isZooming() {
        return this.zoom != this.minZoom;
    }

    private void setDefaultPage(int defaultPage) {
        this.defaultPage = defaultPage;
    }

    public void resetZoom() {
        this.zoomTo(this.minZoom);
    }

    public void resetZoomWithAnimation() {
        this.zoomWithAnimation(this.minZoom);
    }

    public void zoomWithAnimation(float centerX, float centerY, float scale) {
        this.animationManager.startZoomAnimation(centerX, centerY, this.zoom, scale);
    }

    public void zoomWithAnimation(float scale) {
        this.animationManager.startZoomAnimation(this.getWidth() / 2, this.getHeight() / 2, this.zoom, scale);
    }

    private void setScrollHandle(ScrollHandle scrollHandle) {
        this.scrollHandle = scrollHandle;
    }

    public int getPageAtPositionOffset(float positionOffset) {
        return this.pdfFile.getPageAtOffset(this.pdfFile.getDocLen(this.zoom) * positionOffset, this.zoom);
    }

    public float getMinZoom() {
        return this.minZoom;
    }

    public void setMinZoom(float minZoom) {
        this.minZoom = minZoom;
    }

    public float getMidZoom() {
        return this.midZoom;
    }

    public void setMidZoom(float midZoom) {
        this.midZoom = midZoom;
    }

    public float getMaxZoom() {
        return this.maxZoom;
    }

    public void setMaxZoom(float maxZoom) {
        this.maxZoom = maxZoom;
    }

    public void useBestQuality(boolean bestQuality) {
        this.bestQuality = bestQuality;
    }

    public boolean isBestQuality() {
        return this.bestQuality;
    }

    public void setThumbnailRatio(float thumbnailRatio) {
        if (thumbnailRatio == 0.0f) {
            throw new IllegalArgumentException("thumbnailRatio must be greater than 0");
        }
        this.thumbnailRatio = thumbnailRatio;
    }

    public float getThumbnailRatio() {
        return this.thumbnailRatio;
    }

    public void setHorizontalBorder(int horizontalBorderDP) {
        this.horizontalBorder = Util.getDP(this.getContext(), horizontalBorderDP);
    }

    public void setVerticalBorder(int verticalBorderDp) {
        this.verticalBorder = Util.getDP(this.getContext(), verticalBorderDp);
    }

    public boolean isSwipeVertical() {
        return this.swipeVertical;
    }

    public boolean isSwipeEnabled() {
        return this.enableSwipe;
    }

    private void setSwipeVertical(boolean swipeVertical) {
        this.swipeVertical = swipeVertical;
    }

    public void enableAnnotationRendering(boolean annotationRendering) {
        this.annotationRendering = annotationRendering;
    }

    public boolean isAnnotationRendering() {
        return this.annotationRendering;
    }

    public void enableRenderDuringScale(boolean renderDuringScale) {
        this.renderDuringScale = renderDuringScale;
    }

    public boolean isAntialiasing() {
        return this.enableAntialiasing;
    }

    public void enableAntialiasing(boolean enableAntialiasing) {
        this.enableAntialiasing = enableAntialiasing;
    }

    public int getPageSeparatorSpacing() {
        return this.pageSeparatorSpacing;
    }

    public int getStartSpacing() {
        return this.startSpacing;
    }

    public int getEndSpacing() {
        return this.endSpacing;
    }

    public boolean isAutoSpacingEnabled() {
        return this.autoSpacing;
    }

    public void setPageFling(boolean pageFling) {
        this.pageFling = pageFling;
    }

    public boolean isPageFlingEnabled() {
        return this.pageFling;
    }

    private void setAutoSpacing(boolean autoSpacing) {
        this.autoSpacing = autoSpacing;
    }

    private void setPageFitPolicy(FitPolicy pageFitPolicy) {
        this.pageFitPolicy = pageFitPolicy;
    }

    public FitPolicy getPageFitPolicy() {
        return this.pageFitPolicy;
    }

    private void setFitEachPage(boolean fitEachPage) {
        this.fitEachPage = fitEachPage;
    }

    public boolean isFitEachPage() {
        return this.fitEachPage;
    }

    public boolean isPageSnap() {
        return this.pageSnap;
    }

    public void setPageSnap(boolean pageSnap) {
        this.pageSnap = pageSnap;
    }

    public boolean doRenderDuringScale() {
        return this.renderDuringScale;
    }

    public PdfDocument.Meta getDocumentMeta() {
        if (this.pdfFile == null) {
            return null;
        }
        return this.pdfFile.getMetaData();
    }

    public List<PdfDocument.Bookmark> getTableOfContents() {
        if (this.pdfFile == null) {
            return Collections.emptyList();
        }
        return this.pdfFile.getBookmarks();
    }

    public List<PdfDocument.Link> getLinks(int page) {
        if (this.pdfFile == null) {
            return Collections.emptyList();
        }
        return this.pdfFile.getPageLinks(page);
    }

    public Configurator fromAsset(String assetName) {
        return new Configurator(new AssetSource(assetName));
    }

    public Configurator fromFile(File file) {
        return new Configurator(new FileSource(file));
    }

    public Configurator fromUri(Uri uri) {
        return new Configurator(new UriSource(uri));
    }

    public Configurator fromBytes(byte[] bytes) {
        return new Configurator(new ByteArraySource(bytes));
    }

    public Configurator fromStream(InputStream stream) {
        return new Configurator(new InputStreamSource(stream));
    }

    public Configurator fromSource(DocumentSource docSource) {
        return new Configurator(docSource);
    }

    static enum ScrollDir {
        NONE,
        START,
        END;

    }

    private static enum State {
        DEFAULT,
        LOADED,
        SHOWN,
        ERROR;

    }

    public class Configurator {
        private final DocumentSource documentSource;
        private int[] pageNumbers = null;
        private boolean enableSwipe = true;
        private boolean enableDoubletap = true;
        private OnDrawListener onDrawListener;
        private OnDrawListener onDrawAllListener;
        private OnReadyForPrintingListener onReadyForPrintingListener;
        private OnLoadCompleteListener onLoadCompleteListener;
        private OnAttachCompleteListener onAttachCompleteListener;
        private OnDetachCompleteListener onDetachCompleteListener;
        private OnErrorListener onErrorListener;
        private OnPageChangeListener onPageChangeListener;
        private OnPageScrollListener onPageScrollListener;
        private OnRenderListener onRenderListener;
        private OnTapListener onTapListener;
        private OnLongPressListener onLongPressListener;
        private OnPageErrorListener onPageErrorListener;
        private LinkHandler linkHandler = new DefaultLinkHandler(PDFView.this);
        private int defaultPage = 0;
        private boolean swipeHorizontal = false;
        private boolean annotationRendering = false;
        private String password = null;
        private ScrollHandle scrollHandle = null;
        private boolean antialiasing = true;
        private int pageSeparatorSpacing = 0;
        private int startSpacing = 0;
        private int endSpacing = 0;
        private float minZoom = 0.93f;
        private float midZoom = 1.75f;
        private float maxZoom = 3.0f;
        private boolean autoSpacing = false;
        private FitPolicy pageFitPolicy = FitPolicy.WIDTH;
        private boolean fitEachPage = false;
        private boolean pageFling = false;
        private boolean pageSnap = false;
        private boolean nightMode = false;
        private boolean touchPriority = false;
        private boolean useBestQuality = false;
        private float thumbnailRatio = 0.3f;
        private int horizontalBorder = 0;
        private int verticalBorder = 0;

        private Configurator(DocumentSource documentSource) {
            this.documentSource = documentSource;
        }

        public Configurator pages(int ... pageNumbers) {
            this.pageNumbers = pageNumbers;
            return this;
        }

        public Configurator enableSwipe(boolean enableSwipe) {
            this.enableSwipe = enableSwipe;
            return this;
        }

        public Configurator enableDoubletap(boolean enableDoubletap) {
            this.enableDoubletap = enableDoubletap;
            return this;
        }

        public Configurator enableAnnotationRendering(boolean annotationRendering) {
            this.annotationRendering = annotationRendering;
            return this;
        }

        public Configurator onDraw(OnDrawListener onDrawListener) {
            this.onDrawListener = onDrawListener;
            return this;
        }

        public Configurator onDrawAll(OnDrawListener onDrawAllListener) {
            this.onDrawAllListener = onDrawAllListener;
            return this;
        }

        public Configurator onReadyForPrinting(OnReadyForPrintingListener onReadyForPrintingListener) {
            this.onReadyForPrintingListener = onReadyForPrintingListener;
            return this;
        }

        public Configurator onLoad(OnLoadCompleteListener onLoadCompleteListener) {
            this.onLoadCompleteListener = onLoadCompleteListener;
            return this;
        }

        public Configurator onAttach(OnAttachCompleteListener onAttachCompleteListener) {
            this.onAttachCompleteListener = onAttachCompleteListener;
            return this;
        }

        public Configurator onDetach(OnDetachCompleteListener onDetachCompleteListener) {
            this.onDetachCompleteListener = onDetachCompleteListener;
            return this;
        }

        public Configurator onPageScroll(OnPageScrollListener onPageScrollListener) {
            this.onPageScrollListener = onPageScrollListener;
            return this;
        }

        public Configurator onError(OnErrorListener onErrorListener) {
            this.onErrorListener = onErrorListener;
            return this;
        }

        public Configurator onPageError(OnPageErrorListener onPageErrorListener) {
            this.onPageErrorListener = onPageErrorListener;
            return this;
        }

        public Configurator onPageChange(OnPageChangeListener onPageChangeListener) {
            this.onPageChangeListener = onPageChangeListener;
            return this;
        }

        public Configurator onRender(OnRenderListener onRenderListener) {
            this.onRenderListener = onRenderListener;
            return this;
        }

        public Configurator onTap(OnTapListener onTapListener) {
            this.onTapListener = onTapListener;
            return this;
        }

        public Configurator onLongPress(OnLongPressListener onLongPressListener) {
            this.onLongPressListener = onLongPressListener;
            return this;
        }

        public Configurator linkHandler(LinkHandler linkHandler) {
            this.linkHandler = linkHandler;
            return this;
        }

        public Configurator defaultPage(int defaultPage) {
            this.defaultPage = defaultPage;
            return this;
        }

        public Configurator swipeHorizontal(boolean swipeHorizontal) {
            this.swipeHorizontal = swipeHorizontal;
            return this;
        }

        public Configurator password(String password) {
            this.password = password;
            return this;
        }

        public Configurator scrollHandle(ScrollHandle scrollHandle) {
            this.scrollHandle = scrollHandle;
            return this;
        }

        public Configurator enableAntialiasing(boolean antialiasing) {
            this.antialiasing = antialiasing;
            return this;
        }

        public Configurator pageSeparatorSpacing(int pageSeparatorSpacing) {
            this.pageSeparatorSpacing = pageSeparatorSpacing;
            return this;
        }

        public Configurator startEndSpacing(int startSpacing, int endSpacing) {
            this.startSpacing = startSpacing;
            this.endSpacing = endSpacing;
            return this;
        }

        public Configurator zoom(float minZoom, float midZoom, float maxZoom) {
            this.minZoom = minZoom;
            this.midZoom = midZoom;
            this.maxZoom = maxZoom;
            return this;
        }

        public Configurator autoSpacing(boolean autoSpacing) {
            this.autoSpacing = autoSpacing;
            return this;
        }

        public Configurator pageFitPolicy(FitPolicy pageFitPolicy) {
            this.pageFitPolicy = pageFitPolicy;
            return this;
        }

        public Configurator fitEachPage(boolean fitEachPage) {
            this.fitEachPage = fitEachPage;
            return this;
        }

        public Configurator pageSnap(boolean pageSnap) {
            this.pageSnap = pageSnap;
            return this;
        }

        public Configurator pageFling(boolean pageFling) {
            this.pageFling = pageFling;
            return this;
        }

        public Configurator nightMode(boolean nightMode) {
            this.nightMode = nightMode;
            return this;
        }

        public Configurator disableLongPress() {
            PDFView.this.dragPinchManager.disableLongPress();
            return this;
        }

        public Configurator touchPriority(boolean hasPriority) {
            this.touchPriority = hasPriority;
            return this;
        }

        public Configurator renderDuringScale(boolean renderDuringScale) {
            PDFView.this.renderDuringScale = renderDuringScale;
            return this;
        }

        public Configurator useBestQuality(boolean useBestQuality) {
            this.useBestQuality = useBestQuality;
            return this;
        }

        public Configurator thumbnailRatio(@FloatRange(from=0.1, to=1.0) float thumbnailRatio) {
            this.thumbnailRatio = thumbnailRatio;
            return this;
        }

        public Configurator horizontalBorder(int horizontalBorder) {
            this.horizontalBorder = horizontalBorder;
            return this;
        }

        public Configurator verticalBorder(int verticalBorder) {
            this.verticalBorder = verticalBorder;
            return this;
        }

        public void load() {
            if (!PDFView.this.hasSize) {
                PDFView.this.waitingDocumentConfigurator = this;
                return;
            }
            PDFView.this.recycle();
            PDFView.this.callbacks.setOnReadyForPrinting(this.onReadyForPrintingListener);
            PDFView.this.callbacks.setOnLoadComplete(this.onLoadCompleteListener);
            PDFView.this.callbacks.setOnAttachCompleteListener(this.onAttachCompleteListener);
            PDFView.this.callbacks.setOnDetachCompleteListener(this.onDetachCompleteListener);
            PDFView.this.callbacks.setOnError(this.onErrorListener);
            PDFView.this.callbacks.setOnDraw(this.onDrawListener);
            PDFView.this.callbacks.setOnDrawAll(this.onDrawAllListener);
            PDFView.this.callbacks.setOnPageChange(this.onPageChangeListener);
            PDFView.this.callbacks.setOnPageScroll(this.onPageScrollListener);
            PDFView.this.callbacks.setOnRender(this.onRenderListener);
            PDFView.this.callbacks.setOnTap(this.onTapListener);
            PDFView.this.callbacks.setOnLongPress(this.onLongPressListener);
            PDFView.this.callbacks.setOnPageError(this.onPageErrorListener);
            PDFView.this.callbacks.setLinkHandler(this.linkHandler);
            PDFView.this.setSwipeEnabled(this.enableSwipe);
            PDFView.this.setNightMode(this.nightMode);
            PDFView.this.enableDoubleTap(this.enableDoubletap);
            PDFView.this.setDefaultPage(this.defaultPage);
            PDFView.this.setSwipeVertical(!this.swipeHorizontal);
            PDFView.this.enableAnnotationRendering(this.annotationRendering);
            PDFView.this.setScrollHandle(this.scrollHandle);
            PDFView.this.enableAntialiasing(this.antialiasing);
            PDFView.this.setAutoSpacing(this.autoSpacing);
            PDFView.this.setPageFitPolicy(this.pageFitPolicy);
            PDFView.this.setFitEachPage(this.fitEachPage);
            PDFView.this.setPageSnap(this.pageSnap);
            PDFView.this.setPageFling(this.pageFling);
            PDFView.this.setTouchPriority(this.touchPriority);
            PDFView.this.setMinZoom(this.minZoom);
            PDFView.this.setMidZoom(this.midZoom);
            PDFView.this.setMaxZoom(this.maxZoom);
            PDFView.this.useBestQuality(this.useBestQuality);
            PDFView.this.setThumbnailRatio(this.thumbnailRatio);
            PDFView.this.setHorizontalBorder(this.horizontalBorder);
            PDFView.this.setVerticalBorder(this.verticalBorder);
            this.renderDuringScale(PDFView.this.renderDuringScale);
            this.setPageSeparatorSpacing(this.pageSeparatorSpacing);
            this.setStartSpacing(this.startSpacing);
            this.setEndSpacing(this.endSpacing);
            if (this.pageNumbers != null) {
                PDFView.this.load(this.documentSource, this.password, this.pageNumbers);
            } else {
                PDFView.this.load(this.documentSource, this.password);
            }
        }

        private void setPageSeparatorSpacing(int pageSeparatorSpacingDp) {
            PDFView.this.pageSeparatorSpacing = Util.getDP(PDFView.this.getContext(), pageSeparatorSpacingDp);
        }

        private void setStartSpacing(int startSpacing) {
            PDFView.this.startSpacing = Util.getDP(PDFView.this.getContext(), startSpacing);
        }

        private void setEndSpacing(int endSpacing) {
            PDFView.this.endSpacing = Util.getDP(PDFView.this.getContext(), endSpacing);
        }
    }
}

