/*
 * Decompiled with CFR 0.152.
 */
package com.infomaniak.lib.pdfview;

import android.os.AsyncTask;
import com.infomaniak.lib.pdfview.DisplayOptions;
import com.infomaniak.lib.pdfview.PDFSpacing;
import com.infomaniak.lib.pdfview.PDFView;
import com.infomaniak.lib.pdfview.PdfFile;
import com.infomaniak.lib.pdfview.source.DocumentSource;
import com.shockwave.pdfium.PdfDocument;
import com.shockwave.pdfium.PdfiumCore;
import com.shockwave.pdfium.util.Size;
import java.lang.ref.WeakReference;

class DecodingAsyncTask
extends AsyncTask<Void, Void, Throwable> {
    private boolean cancelled;
    private WeakReference<PDFView> pdfViewReference;
    private PdfiumCore pdfiumCore;
    private String password;
    private DocumentSource docSource;
    private int[] userPages;
    private PdfFile pdfFile;

    DecodingAsyncTask(DocumentSource docSource, String password, int[] userPages, PDFView pdfView, PdfiumCore pdfiumCore) {
        this.docSource = docSource;
        this.userPages = userPages;
        this.cancelled = false;
        this.pdfViewReference = new WeakReference<PDFView>(pdfView);
        this.password = password;
        this.pdfiumCore = pdfiumCore;
    }

    protected Throwable doInBackground(Void ... params) {
        try {
            PDFView pdfView = (PDFView)((Object)this.pdfViewReference.get());
            if (pdfView != null) {
                PdfDocument pdfDocument = this.docSource.createDocument(pdfView.getContext(), this.pdfiumCore, this.password);
                PDFSpacing pdfSpacing = new PDFSpacing(pdfView.getPageSeparatorSpacing(), pdfView.getStartSpacing(), pdfView.getEndSpacing(), pdfView.isAutoSpacingEnabled());
                DisplayOptions displayOptions = new DisplayOptions(pdfView.isSwipeVertical(), pdfSpacing, pdfView.isFitEachPage(), this.getViewSize(pdfView), pdfView.getPageFitPolicy());
                this.pdfFile = new PdfFile(this.pdfiumCore, pdfDocument, this.userPages, displayOptions);
                return null;
            }
            return new NullPointerException("pdfView == null");
        }
        catch (Throwable t) {
            return t;
        }
    }

    private Size getViewSize(PDFView pdfView) {
        return new Size(pdfView.getWidth(), pdfView.getHeight());
    }

    protected void onPostExecute(Throwable t) {
        PDFView pdfView = (PDFView)((Object)this.pdfViewReference.get());
        if (pdfView != null) {
            if (t != null) {
                pdfView.loadError(t);
                return;
            }
            if (!this.cancelled) {
                pdfView.loadComplete(this.pdfFile);
            }
        }
    }

    protected void onCancelled() {
        this.cancelled = true;
    }
}

