/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.widgets;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.FormWidgetFactory;
import com.vijay.jsonwizard.interfaces.JsonApi;
import com.vijay.jsonwizard.utils.JsonFormUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ResourceViewerFactory
implements FormWidgetFactory {
    @Override
    public List<View> getViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) throws Exception {
        ArrayList<View> views = new ArrayList<View>(1);
        View parentView = LayoutInflater.from((Context)context).inflate(R.layout.item_resource_label, null);
        TextView label = (TextView)parentView.findViewById(R.id.label);
        label.setTag(R.id.type, (Object)"resource_view");
        String resource = jsonObject.getString("resource");
        String resourcePath = resourceResolver.resolvePath(context, resource);
        if (resourcePath != null && new File(resourcePath).exists()) {
            label.setTag(R.id.value, (Object)resourcePath);
        } else {
            label.setTag(R.id.value, (Object)resource);
        }
        String labelText = bundle.resolveKey(jsonObject.getString("label"));
        label.setTag(R.id.label, (Object)labelText);
        label.setText((CharSequence)labelText);
        label.setOnClickListener((View.OnClickListener)listener);
        if (jsonObject.has("config")) {
            JSONObject config;
            String expression = jsonObject.optString("config");
            if (resolver.isValidExpression(expression)) {
                JSONObject currentValues = this.getCurrentValues(context);
                config = resolver.resolveAsObject(expression, currentValues);
            } else {
                config = jsonObject.getJSONObject("config");
            }
            this.configureLabel(label, config);
        }
        views.add(parentView);
        return views;
    }

    private void configureLabel(TextView label, JSONObject config) {
        String alignment;
        String color2 = config.optString("color");
        if (color2 != null) {
            label.setTextColor(Color.parseColor((String)color2));
        } else {
            label.setTextColor(-16776961);
        }
        Double size = config.optDouble("size");
        if (size != null) {
            label.setTextSize(size.floatValue());
        }
        if ((alignment = config.optString("align")) != null) {
            switch (alignment) {
                case "end": {
                    label.setGravity(0x800005);
                    break;
                }
                case "center": {
                    label.setGravity(17);
                    break;
                }
                default: {
                    label.setGravity(0x800003);
                }
            }
        }
    }

    @Nullable
    private JSONObject getCurrentValues(Context context) throws JSONException {
        JSONObject currentValues = null;
        if (context instanceof JsonApi) {
            String currentJsonState = ((JsonApi)context).currentJsonState();
            JSONObject currentJsonObject = new JSONObject(currentJsonState);
            currentValues = JsonFormUtils.extractDataFromForm(currentJsonObject, false);
        }
        return currentValues;
    }
}

