/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.activities;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.demo.resources.AssetsResourceResolver;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.demo.resources.ResourceResolverFactory;
import com.vijay.jsonwizard.expressions.ExternalContentResolver;
import com.vijay.jsonwizard.expressions.ExternalContentResolverFactory;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.fragments.JsonFormFragment;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.JsonApi;
import com.vijay.jsonwizard.utils.JsonFormUtils;
import com.vijay.jsonwizard.utils.PropertiesUtils;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonFormActivity
extends AppCompatActivity
implements JsonApi {
    private static final String TAG = "JsonFormActivity";
    private Toolbar mToolbar;
    private JSONObject mJSONObject;
    private int mVisualizationMode;
    private JsonFormBundle mJsonBundle;
    private JsonExpressionResolver mResolver;
    private ResourceResolver mResourceResolver;
    private ExternalContentResolver mContentResolver;
    private String externalContentResolverClass;
    private String resourceResolverClass;

    public void init(String json, Integer visualizationMode, String externalContentResolverClass, String resourceResolverClass) {
        this.externalContentResolverClass = externalContentResolverClass;
        this.resourceResolverClass = resourceResolverClass;
        if (!TextUtils.isEmpty((CharSequence)externalContentResolverClass)) {
            this.mContentResolver = ExternalContentResolverFactory.getInstance((Context)this, externalContentResolverClass);
        }
        if (TextUtils.isEmpty((CharSequence)resourceResolverClass)) {
            this.resourceResolverClass = AssetsResourceResolver.class.getName();
        }
        this.mResourceResolver = ResourceResolverFactory.getInstance((Context)this, this.resourceResolverClass);
        this.init(json, visualizationMode);
    }

    public void init(String json, Integer visualizationMode) {
        try {
            this.mJSONObject = new JSONObject(json);
            this.mVisualizationMode = visualizationMode;
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)("Initialization error. JSON form definition is invalid : " + e.getMessage()));
            Intent data = new Intent();
            data.setData(Uri.parse((String)"Initialization error. JSON form definition is invalid"));
            this.setResult(-2, data);
            this.finish();
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.configureInputMethod();
        this.configureOrientation();
        this.initialize();
        this.createFragments(null);
    }

    protected void initialize() {
        this.setContentView(R.layout.activity_json_form);
        this.mToolbar = (Toolbar)this.findViewById(R.id.tb_top);
        this.setSupportActionBar(this.mToolbar);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createFragments(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            String contentResolver = this.getIntent().getStringExtra("resolver");
            String resourceResolver = this.getIntent().getStringExtra("resourceResolver");
            this.init(this.getIntent().getStringExtra("json"), this.getIntent().getIntExtra("visualization", 1), contentResolver, resourceResolver);
            if (this.mJSONObject == null) return;
            String step = "step1";
            String pausedStep = this.getIntent().getStringExtra("pausedStep");
            this.getSupportFragmentManager().beginTransaction().add(R.id.container, (Fragment)JsonFormFragment.getFormFragment(step)).commit();
            try {
                if (pausedStep == null || "".equals(pausedStep)) return;
                while (!pausedStep.equals(step)) {
                    step = JsonFormUtils.resolveNextStep(this.mJSONObject.getJSONObject(step), this.getExpressionResolver(), this.mJSONObject);
                    JsonFormFragment nStep = JsonFormFragment.getFormFragment(step);
                    this.getSupportFragmentManager().beginTransaction().replace(R.id.container, (Fragment)nStep).addToBackStack(nStep.getClass().getSimpleName()).commit();
                }
                return;
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"onNextClick: Error evaluating next step", (Throwable)e);
                return;
            }
        } else {
            this.init(savedInstanceState.getString("jsonState"), savedInstanceState.getInt("visualization"), savedInstanceState.getString("resolver"), savedInstanceState.getString("resourceResolver"));
        }
    }

    public Toolbar getToolbar() {
        return this.mToolbar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized JSONObject getStep(String name) {
        JSONObject jSONObject = this.mJSONObject;
        synchronized (jSONObject) {
            try {
                return this.mJSONObject.getJSONObject(name);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeValue(String stepName, String key, String value) throws JSONException {
        JSONObject jSONObject = this.mJSONObject;
        synchronized (jSONObject) {
            JSONObject jsonObject = this.mJSONObject.getJSONObject(stepName);
            JSONArray fields = jsonObject.getJSONArray("fields");
            for (int i = 0; i < fields.length(); ++i) {
                JSONObject item = fields.getJSONObject(i);
                String keyAtIndex = item.optString("key");
                if (!key.equals(keyAtIndex)) continue;
                item.put("value", (Object)value);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeValue(String stepName, String parentKey, String childObjectKey, String childKey, String value) throws JSONException {
        JSONObject jSONObject = this.mJSONObject;
        synchronized (jSONObject) {
            JSONObject jsonObject = this.mJSONObject.getJSONObject(stepName);
            JSONArray fields = jsonObject.getJSONArray("fields");
            for (int i = 0; i < fields.length(); ++i) {
                JSONObject item = fields.getJSONObject(i);
                String keyAtIndex = item.getString("key");
                if (!parentKey.equals(keyAtIndex)) continue;
                JSONArray jsonArray = item.getJSONArray(childObjectKey);
                for (int j = 0; j < jsonArray.length(); ++j) {
                    JSONObject innerItem = jsonArray.getJSONObject(j);
                    String anotherKeyAtIndex = innerItem.getString("key");
                    if (!childKey.equals(anotherKeyAtIndex)) continue;
                    if (value != null && !"".equals(value)) {
                        innerItem.put("value", (Object)value);
                    }
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String currentJsonState() {
        JSONObject jSONObject = this.mJSONObject;
        synchronized (jSONObject) {
            return this.mJSONObject.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCount() {
        JSONObject jSONObject = this.mJSONObject;
        synchronized (jSONObject) {
            return this.mJSONObject.optString("count");
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mJSONObject != null) {
            outState.putString("jsonState", this.mJSONObject.toString());
            outState.putInt("visualization", this.mVisualizationMode);
            outState.putString("resolver", this.externalContentResolverClass);
            outState.putString("resourceResolver", this.resourceResolverClass);
        }
    }

    @Override
    public int getVisualizationMode() {
        return this.mVisualizationMode;
    }

    @Override
    public JsonFormBundle getBundle(Locale locale) {
        if (this.mJsonBundle == null) {
            try {
                this.mJsonBundle = new JsonFormBundle(this.mJSONObject, locale);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
        }
        return this.mJsonBundle;
    }

    @Override
    public JsonExpressionResolver getExpressionResolver() {
        if (this.mResolver == null) {
            try {
                this.mResolver = this.mContentResolver != null ? new JsonExpressionResolver(this.mJSONObject, this.mContentResolver) : new JsonExpressionResolver(this.mJSONObject);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
        }
        return this.mResolver;
    }

    @Override
    public ResourceResolver getResourceResolver() {
        return this.mResourceResolver;
    }

    @Override
    public ExternalContentResolver getExternalContentResolver() {
        return this.mContentResolver;
    }

    private void configureInputMethod() {
        if (this.getIntent().hasExtra("input_method")) {
            int inputMethod = this.getIntent().getIntExtra("input_method", -1);
            if (inputMethod == 2) {
                this.getWindow().setSoftInputMode(4);
            } else if (inputMethod == 1) {
                this.getWindow().setSoftInputMode(2);
            }
        }
        if (1 != this.mVisualizationMode) {
            this.getWindow().setSoftInputMode(2);
        }
    }

    private void configureOrientation() {
        Intent intent = this.getIntent();
        boolean hasOrientationExtra = intent.hasExtra("screen_orientation");
        boolean hasCurrentOrientationExtra = intent.hasExtra("current_orientation");
        int currentOrientation = this.getResources().getConfiguration().orientation;
        int rotation = hasCurrentOrientationExtra ? this.getIntent().getIntExtra("current_orientation", currentOrientation) : this.getWindowManager().getDefaultDisplay().getRotation();
        if (hasOrientationExtra) {
            int orientation = this.getIntent().getIntExtra("screen_orientation", currentOrientation);
            if (2 == orientation) {
                if (rotation == 1) {
                    this.setRequestedOrientation(0);
                } else if (rotation == 3) {
                    this.setRequestedOrientation(8);
                }
            } else if (1 == orientation) {
                this.setRequestedOrientation(1);
            }
            this.getIntent().removeExtra("screen_orientation");
        }
    }

    public void onPause() {
        super.onPause();
        if (this.mVisualizationMode != 2) {
            Intent intent = new Intent("jsonFormPaused");
            intent.putExtra("json", this.mJSONObject.toString());
            intent.putExtra("pausedStep", PropertiesUtils.getInstance(this.getBaseContext()).getPausedStep());
            PropertiesUtils.getInstance(this.getBaseContext()).setPausedStep(null);
            this.sendBroadcast(intent);
        }
    }
}

