/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Environment;
import android.util.Base64;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageFileUtils {
    public static final int IMAGE_MAX_SIZE = 1600;
    public static final int IMAGE_COMPRESSION_RATIO = 80;
    private static final String TAG = "ImageFileUtils";

    public static String processImageFromFile(String filePath) {
        String content = null;
        Log.d((String)TAG, (String)("Processing " + filePath));
        File imagefile = new File(filePath);
        try (FileInputStream fis = new FileInputStream(imagefile);){
            Bitmap tempImage = BitmapFactory.decodeStream((InputStream)fis);
            Log.d((String)TAG, (String)"Process scale to fit");
            tempImage = ImageFileUtils.scaleToFit(tempImage, 1600);
            Log.d((String)TAG, (String)"Process compression");
            content = ImageFileUtils.compressToBase64(tempImage, 80);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error processing image from file", (Throwable)e);
        }
        return content;
    }

    public static String compressToBase64(Bitmap uncompressedBitmap, int compressRatio) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        uncompressedBitmap.compress(Bitmap.CompressFormat.JPEG, compressRatio, (OutputStream)byteArrayOutputStream);
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        return Base64.encodeToString((byte[])byteArray, (int)2);
    }

    public static Bitmap decodeFromBase64(String base64) {
        byte[] bytes = Base64.decode((String)base64, (int)2);
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    public static Bitmap scaleToFit(Bitmap unscaledBitmap, int maxSize) {
        Bitmap scaledBitmap = null;
        if (unscaledBitmap.getWidth() > maxSize || unscaledBitmap.getHeight() > maxSize) {
            Rect srcRect = ImageFileUtils.calculateSrcRect(unscaledBitmap.getWidth(), unscaledBitmap.getHeight(), maxSize, maxSize, ScalingLogic.FIT);
            Rect destRect = ImageFileUtils.calculateDestRect(unscaledBitmap.getWidth(), unscaledBitmap.getHeight(), maxSize, maxSize, ScalingLogic.FIT);
            scaledBitmap = Bitmap.createBitmap((int)destRect.width(), (int)destRect.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(scaledBitmap);
            canvas.drawBitmap(unscaledBitmap, srcRect, destRect, new Paint(2));
        } else {
            scaledBitmap = unscaledBitmap;
        }
        return scaledBitmap;
    }

    public static Rect calculateSrcRect(int srcWidth, int srcHeight, int dstWidth, int dstHeight, ScalingLogic scalingLogic) {
        if (scalingLogic == ScalingLogic.CROP) {
            float srcAspect = (float)srcWidth / (float)srcHeight;
            float dstAspect = (float)dstWidth / (float)dstHeight;
            if (srcAspect > dstAspect) {
                int srcRectWidth = (int)((float)srcHeight * dstAspect);
                int srcRectLeft = (srcWidth - srcRectWidth) / 2;
                return new Rect(srcRectLeft, 0, srcRectLeft + srcRectWidth, srcHeight);
            }
            int srcRectHeight = (int)((float)srcWidth / dstAspect);
            int scrRectTop = (srcHeight - srcRectHeight) / 2;
            return new Rect(0, scrRectTop, srcWidth, scrRectTop + srcRectHeight);
        }
        return new Rect(0, 0, srcWidth, srcHeight);
    }

    public static Rect calculateDestRect(int srcWidth, int srcHeight, int dstWidth, int dstHeight, ScalingLogic logic) {
        if (logic == ScalingLogic.FIT) {
            float srcAspect = (float)srcWidth / (float)srcHeight;
            float dstAspect = (float)dstWidth / (float)dstHeight;
            if (srcAspect > dstAspect) {
                return new Rect(0, 0, dstWidth, (int)((float)dstWidth / srcAspect));
            }
            return new Rect(0, 0, (int)((float)dstHeight * srcAspect), dstHeight);
        }
        return new Rect(0, 0, dstWidth, dstHeight);
    }

    public static Bitmap generateThumbNail(String path) {
        Bitmap bitmap = BitmapFactory.decodeFile((String)path);
        bitmap = ImageFileUtils.scaleToFit(bitmap, 200);
        return bitmap;
    }

    public static File writeToFile(byte[] array, String imageName) {
        String path = Environment.getExternalStorageDirectory() + "/temp/";
        try {
            File file;
            File dir = new File(path);
            if (!dir.exists()) {
                dir.mkdir();
            }
            if (!(file = new File(dir, imageName)).exists() && file.createNewFile()) {
                Log.d((String)TAG, (String)("New file created " + file.getAbsolutePath()));
            }
            try (FileOutputStream stream = new FileOutputStream(path + imageName);){
                stream.write(array);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Error writing to file", (Throwable)e);
            }
            return file;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error creating file " + path + imageName), (Throwable)e);
            return null;
        }
    }

    public static boolean deleteTemporalDir(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            if (files == null) {
                return true;
            }
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    ImageFileUtils.deleteTemporalDir(files[i]);
                    continue;
                }
                if (!files[i].delete()) continue;
                Log.d((String)TAG, (String)("Deleted file " + files[i].getAbsolutePath()));
            }
        }
        return path.delete();
    }

    public static enum ScalingLogic {
        CROP,
        FIT;

    }
}

