/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.activities;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import com.gu.toolargetool.TooLargeTool;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.demo.resources.AssetsResourceResolver;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.demo.resources.ResourceResolverFactory;
import com.vijay.jsonwizard.expressions.ExternalContentResolver;
import com.vijay.jsonwizard.expressions.ExternalContentResolverFactory;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.fragments.JsonFormFragment;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.JsonApi;
import com.vijay.jsonwizard.state.StateProvider;
import com.vijay.jsonwizard.utils.ExpressionResolverContextUtils;
import com.vijay.jsonwizard.utils.JsonFormUtils;
import com.vijay.jsonwizard.utils.PropertiesUtils;
import java.util.Iterator;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonFormActivity
extends AppCompatActivity
implements JsonApi {
    private static final String TAG = "JsonFormActivity";
    private static final String PROP_HISTORY = "_history";
    private Toolbar mToolbar;
    private JSONObject mJSONObject;
    private int mVisualizationMode;
    private JsonFormBundle mJsonBundle;
    private JsonExpressionResolver mResolver;
    private ResourceResolver mResourceResolver;
    private ExternalContentResolver mContentResolver;
    private String externalContentResolverClass;
    private String resourceResolverClass;
    private boolean mTrackHistory;

    public void init(String json, Integer visualizationMode, String externalContentResolverClass, String resourceResolverClass) {
        this.externalContentResolverClass = externalContentResolverClass;
        this.resourceResolverClass = resourceResolverClass;
        if (!TextUtils.isEmpty((CharSequence)externalContentResolverClass)) {
            this.mContentResolver = ExternalContentResolverFactory.getInstance((Context)this, externalContentResolverClass);
        }
        if (TextUtils.isEmpty((CharSequence)resourceResolverClass)) {
            this.resourceResolverClass = AssetsResourceResolver.class.getName();
        }
        this.mResourceResolver = ResourceResolverFactory.getInstance((Context)this, this.resourceResolverClass);
        this.init(json, visualizationMode);
    }

    public void init(String json, Integer visualizationMode) {
        try {
            this.mJSONObject = new JSONObject(json);
            this.mVisualizationMode = visualizationMode;
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)("Initialization error. JSON form definition is invalid : " + e.getMessage()));
            Intent data = new Intent();
            data.setData(Uri.parse((String)"Initialization error. JSON form definition is invalid"));
            this.setResult(-2, data);
            this.finish();
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        TooLargeTool.startLogging((Application)this.getApplication());
        this.configureInputMethod();
        this.configureOrientation();
        this.initialize();
        this.createFragments(savedInstanceState);
    }

    protected void initialize() {
        this.setContentView(R.layout.activity_json_form);
        this.mToolbar = (Toolbar)this.findViewById(R.id.tb_top);
        this.setSupportActionBar(this.mToolbar);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createFragments(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            this.mTrackHistory = this.getIntent().getBooleanExtra("trackHistory", false);
            String contentResolver = this.getIntent().getStringExtra("resolver");
            String resourceResolver = this.getIntent().getStringExtra("resourceResolver");
            String formJson = this.getIntent().getStringExtra("json");
            if (formJson == null && this.getIntent().getParcelableExtra("jsonUri") != null) {
                Uri jsonUri = (Uri)this.getIntent().getParcelableExtra("jsonUri");
                try (Cursor c = this.getContentResolver().query(jsonUri, null, null, null, null);){
                    if (c != null && c.moveToFirst()) {
                        formJson = c.getString(c.getColumnIndex("JSON"));
                    }
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("Could not resolve JsonForm URI: " + jsonUri), (Throwable)e);
                }
            }
            this.init(formJson, this.getIntent().getIntExtra("visualization", 1), contentResolver, resourceResolver);
            if (this.mJSONObject == null) return;
            String step = "step1";
            String pausedStep = this.getIntent().getStringExtra("pausedStep");
            this.getSupportFragmentManager().beginTransaction().add(R.id.container, (Fragment)JsonFormFragment.getFormFragment(step)).commit();
            try {
                if (pausedStep == null || "".equals(pausedStep)) return;
                while (!pausedStep.equals(step)) {
                    step = JsonFormUtils.resolveNextStep(this.mJSONObject.getJSONObject(step), this.getExpressionResolver(), this.mJSONObject);
                    JsonFormFragment nStep = JsonFormFragment.getFormFragment(step);
                    this.getSupportFragmentManager().beginTransaction().replace(R.id.container, (Fragment)nStep).addToBackStack(nStep.getClass().getSimpleName()).commit();
                }
                return;
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"onNextClick: Error evaluating next step", (Throwable)e);
                return;
            }
        }
        this.mTrackHistory = savedInstanceState.getBoolean("trackHistory");
        this.init(JsonFormUtils.readTempFormFromDisk((Context)this), savedInstanceState.getInt("visualization"), savedInstanceState.getString("resolver"), savedInstanceState.getString("resourceResolver"));
    }

    public Toolbar getToolbar() {
        return this.mToolbar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized JSONObject getStep(String name) {
        JSONObject jSONObject = this.mJSONObject;
        synchronized (jSONObject) {
            try {
                JSONObject step = this.mJSONObject.getJSONObject(name);
                if (!step.has("template")) {
                    return step;
                }
                return this.applyTemplateForStep(name, step);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private JSONObject applyTemplateForStep(String name, JSONObject step) throws JSONException {
        JSONObject template = this.findTemplateForStep(name, step);
        JSONObject newStep = new JSONObject(template.toString());
        if (step.has("next")) {
            newStep.put("next", step.get("next"));
        }
        if (step.has("title")) {
            newStep.put("title", step.get("title"));
        }
        JSONArray fields = newStep.getJSONArray("fields");
        for (int i = 0; i < fields.length(); ++i) {
            String stepValue;
            JSONObject item = fields.getJSONObject(i);
            String key = item.optString("key");
            String type = item.getString("type");
            if (key == null) continue;
            String newKey = name + "_" + key;
            item.put("key", (Object)newKey);
            if (type.equals("check_box")) {
                this.setOptionsValue(name, step, newKey, item);
                continue;
            }
            if (!step.has("fields") || (stepValue = this.findValue(step, newKey)) == null || "".equals(stepValue)) continue;
            item.put("value", (Object)stepValue);
        }
        if (step.has("template_params")) {
            JSONObject newParamsContainer = new JSONObject();
            JsonExpressionResolver expressionResolver = this.getExpressionResolver();
            JSONObject params = step.getJSONObject("template_params");
            Iterator it = params.keys();
            JSONObject currentValues = this.getCurrentValues();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = params.getString(key);
                if (expressionResolver.isValidExpression(value)) {
                    value = expressionResolver.resolveAsString(params.getString(key), currentValues);
                }
                newParamsContainer.put(key, (Object)value);
            }
            newStep.put("template_params", (Object)newParamsContainer);
        }
        return newStep;
    }

    private JSONObject getCurrentValues() throws JSONException {
        return JsonFormUtils.extractDataFromForm(this.mJSONObject, false);
    }

    private void setOptionsValue(String name, JSONObject step, String parentKey, JSONObject target) throws JSONException {
        JSONArray targetOptions;
        JSONObject field;
        JSONArray sourceOptions = new JSONArray();
        if (step.has("fields") && (sourceOptions = (field = JsonFormUtils.findFieldInJSON(step, parentKey)).optJSONArray("options")) == null) {
            sourceOptions = new JSONArray();
        }
        if ((targetOptions = target.optJSONArray("options")) == null) {
            return;
        }
        for (int i = 0; i < targetOptions.length(); ++i) {
            JSONObject targetOption = targetOptions.getJSONObject(i);
            String targetOptionKey = targetOption.getString("key");
            String newTargetOptionKey = name + "_" + targetOptionKey;
            targetOption.put("key", (Object)newTargetOptionKey);
            for (int j = 0; j < sourceOptions.length(); ++j) {
                JSONObject sourceOption = sourceOptions.getJSONObject(j);
                String sourceKey = sourceOption.getString("key");
                String sourceValue = sourceOption.optString("value");
                if (!newTargetOptionKey.equals(sourceKey) || sourceValue == null) continue;
                targetOption.put("value", (Object)sourceValue);
            }
        }
    }

    private String findValue(JSONObject jsonObject, String key) {
        try {
            JSONObject field = JsonFormUtils.findFieldInJSON(jsonObject, key);
            return field.optString("value");
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"No value found", (Throwable)e);
            return null;
        }
    }

    private JSONObject findTemplateForStep(String stepName, JSONObject step) throws JSONException {
        JSONObject template = null;
        String templateNameOrExpression = step.getString("template");
        JsonExpressionResolver resolver = this.getExpressionResolver();
        if (resolver != null && resolver.isValidExpression(templateNameOrExpression)) {
            JSONObject currentValues = ExpressionResolverContextUtils.getCurrentValues((Context)this, stepName);
            template = resolver.resolveAsObject(templateNameOrExpression, currentValues);
            if (template == null) {
                String templateName = resolver.resolveAsString(templateNameOrExpression, currentValues);
                template = this.findLocalTemplateForStep(templateName);
            }
        } else {
            template = this.findLocalTemplateForStep(templateNameOrExpression);
        }
        return template;
    }

    private JSONObject findLocalTemplateForStep(String stepName) throws JSONException {
        if (this.mJSONObject.has("templates")) {
            JSONObject templates = this.mJSONObject.getJSONObject("templates");
            return templates.getJSONObject(stepName);
        }
        Log.e((String)TAG, (String)("Template " + stepName + " could not be found in the form definition"));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeValue(String stepName, String key, String value) throws JSONException {
        JSONObject jSONObject = this.mJSONObject;
        synchronized (jSONObject) {
            JSONObject jsonObject = this.mJSONObject.getJSONObject(stepName);
            JSONArray fields = jsonObject.optJSONArray("fields");
            if (fields == null) {
                JSONArray emptyArray = new JSONArray();
                jsonObject.put("fields", (Object)emptyArray);
                fields = jsonObject.getJSONArray("fields");
            }
            boolean found = false;
            for (int i = 0; i < fields.length(); ++i) {
                JSONObject item = fields.getJSONObject(i);
                String keyAtIndex = item.optString("key");
                if (!key.equals(keyAtIndex)) continue;
                item.put("value", (Object)value);
                found = true;
                return;
            }
            if (!found) {
                JSONObject template = this.findTemplateForStep(stepName, jsonObject);
                String type = "edit-text";
                if (template != null) {
                    String templateFieldKey = key.substring(stepName.length() + 1);
                    JSONObject field = JsonFormUtils.findFieldInJSON(template, templateFieldKey);
                    type = field.getString("type");
                }
                JSONObject newValue = new JSONObject();
                newValue.put("key", (Object)key);
                newValue.put("value", (Object)value);
                newValue.put("type", (Object)type);
                fields.put((Object)newValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeValue(String stepName, String parentKey, String childObjectKey, String childKey, String value) throws JSONException {
        if (value == null || "".equals(value)) {
            return;
        }
        JSONObject jSONObject = this.mJSONObject;
        synchronized (jSONObject) {
            JSONObject jsonObject = this.mJSONObject.getJSONObject(stepName);
            JSONArray fields = jsonObject.optJSONArray("fields");
            if (fields == null) {
                JSONArray emptyArray = new JSONArray();
                jsonObject.put("fields", (Object)emptyArray);
                fields = jsonObject.getJSONArray("fields");
            }
            boolean found = false;
            for (int i = 0; i < fields.length(); ++i) {
                JSONObject item = fields.getJSONObject(i);
                String keyAtIndex = item.getString("key");
                if (!parentKey.equals(keyAtIndex)) continue;
                found = true;
                JSONArray jsonArray = item.getJSONArray(childObjectKey);
                boolean innerItemFound = false;
                for (int j = 0; j < jsonArray.length(); ++j) {
                    JSONObject innerItem = jsonArray.getJSONObject(j);
                    String anotherKeyAtIndex = innerItem.getString("key");
                    if (!childKey.equals(anotherKeyAtIndex)) continue;
                    if (!TextUtils.isEmpty((CharSequence)value)) {
                        innerItem.put("value", (Object)value);
                    }
                    innerItemFound = true;
                    return;
                }
                if (innerItemFound) continue;
                JSONObject innerValue = new JSONObject();
                innerValue.put("key", (Object)childKey);
                innerValue.put("value", (Object)value);
                jsonArray.put((Object)innerValue);
            }
            if (!found) {
                JSONObject template = this.findTemplateForStep(stepName, jsonObject);
                String type = "edit-text";
                if (template != null) {
                    String templateFieldKey = parentKey.substring(stepName.length() + 1);
                    JSONObject field = JsonFormUtils.findFieldInJSON(template, templateFieldKey);
                    type = field.getString("type");
                }
                JSONObject newValue = new JSONObject();
                newValue.put("key", (Object)parentKey);
                newValue.put("type", (Object)type);
                JSONArray childObjects = new JSONArray();
                newValue.put(childObjectKey, (Object)childObjects);
                JSONObject innerValue = new JSONObject();
                innerValue.put("key", (Object)childKey);
                innerValue.put("value", (Object)value);
                childObjects.put((Object)innerValue);
                fields.put((Object)newValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String currentJsonState() {
        JSONObject jSONObject = this.mJSONObject;
        synchronized (jSONObject) {
            return this.mJSONObject.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCount() {
        JSONObject jSONObject = this.mJSONObject;
        synchronized (jSONObject) {
            return this.mJSONObject.optString("count");
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mJSONObject != null) {
            JsonFormUtils.writeTempFormToDisk((Context)this, this.mJSONObject.toString());
            outState.putInt("visualization", this.mVisualizationMode);
            outState.putString("resolver", this.externalContentResolverClass);
            outState.putString("resourceResolver", this.resourceResolverClass);
            outState.putBoolean("trackHistory", this.mTrackHistory);
        }
    }

    @Override
    public int getVisualizationMode() {
        return this.mVisualizationMode;
    }

    @Override
    public JsonFormBundle getBundle(Locale locale) {
        if (this.mJsonBundle == null) {
            try {
                this.mJsonBundle = new JsonFormBundle(this.mJSONObject, locale);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
        }
        return this.mJsonBundle;
    }

    @Override
    public JsonExpressionResolver getExpressionResolver() {
        if (this.mResolver == null) {
            try {
                this.mResolver = this.mContentResolver != null ? new JsonExpressionResolver(this.mJSONObject, this.mContentResolver) : new JsonExpressionResolver(this.mJSONObject);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
        }
        return this.mResolver;
    }

    @Override
    public ResourceResolver getResourceResolver() {
        return this.mResourceResolver;
    }

    @Override
    public ExternalContentResolver getExternalContentResolver() {
        return this.mContentResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void historyPush(String stepName) throws JSONException {
        if (!this.mTrackHistory) {
            return;
        }
        JSONObject jSONObject = this.mJSONObject;
        synchronized (jSONObject) {
            JSONArray history = this.mJSONObject.optJSONArray(PROP_HISTORY);
            if (history == null) {
                history = new JSONArray();
                this.mJSONObject.put(PROP_HISTORY, (Object)history);
            }
            JSONObject slice = new JSONObject();
            slice.put("name", (Object)stepName);
            JSONObject stepState = this.mJSONObject.optJSONObject(stepName);
            if (stepState != null && stepState.has("fields")) {
                slice.put("state", (Object)stepState.optJSONArray("fields"));
            } else {
                slice.put("state", (Object)stepState);
            }
            history.put((Object)slice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void historyPop() {
        if (!this.mTrackHistory) {
            return;
        }
        JSONObject jSONObject = this.mJSONObject;
        synchronized (jSONObject) {
            JSONArray history = this.mJSONObject.optJSONArray(PROP_HISTORY);
            if (history != null) {
                history.remove(history.length() - 1);
            }
        }
    }

    private void configureInputMethod() {
        if (this.getIntent().hasExtra("input_method")) {
            int inputMethod = this.getIntent().getIntExtra("input_method", -1);
            if (inputMethod == 2) {
                this.getWindow().setSoftInputMode(4);
            } else if (inputMethod == 1) {
                this.getWindow().setSoftInputMode(2);
            }
        }
        if (1 != this.mVisualizationMode) {
            this.getWindow().setSoftInputMode(2);
        }
    }

    private void configureOrientation() {
        Intent intent = this.getIntent();
        boolean hasOrientationExtra = intent.hasExtra("screen_orientation");
        boolean hasCurrentOrientationExtra = intent.hasExtra("current_orientation");
        int currentOrientation = this.getResources().getConfiguration().orientation;
        int rotation = hasCurrentOrientationExtra ? this.getIntent().getIntExtra("current_orientation", currentOrientation) : this.getWindowManager().getDefaultDisplay().getRotation();
        if (hasOrientationExtra) {
            int orientation = this.getIntent().getIntExtra("screen_orientation", currentOrientation);
            if (2 == orientation) {
                if (rotation == 1) {
                    this.setRequestedOrientation(0);
                } else if (rotation == 3) {
                    this.setRequestedOrientation(8);
                }
            } else if (1 == orientation) {
                this.setRequestedOrientation(1);
            }
            this.getIntent().removeExtra("screen_orientation");
        }
    }

    public void onPause() {
        super.onPause();
        if (this.mVisualizationMode != 2) {
            Intent intent = new Intent("jsonFormPaused");
            String json = this.mJSONObject.toString();
            if (json != null && json.length() >= 200000) {
                Uri uri = StateProvider.saveState((Context)this, json);
                intent.putExtra("uri", (Parcelable)uri);
            } else {
                intent.putExtra("json", json);
            }
            intent.putExtra("pausedStep", PropertiesUtils.getInstance(this.getBaseContext()).getPausedStep());
            PropertiesUtils.getInstance(this.getBaseContext()).setPausedStep(null);
            this.sendBroadcast(intent);
        }
    }
}

