/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.customviews;

import android.content.Context;
import android.content.res.ColorStateList;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.textfield.TextInputLayout;
import com.vijay.jsonwizard.validators.textinputlayout.TILValidator;
import java.util.ArrayList;
import java.util.List;

public class MaterialTextInputLayout
extends TextInputLayout {
    private List<TILValidator> validators;

    public MaterialTextInputLayout(@NonNull Context context) {
        super(context);
    }

    public MaterialTextInputLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public MaterialTextInputLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public MaterialTextInputLayout addValidator(TILValidator validator) {
        if (this.validators == null) {
            this.validators = new ArrayList<TILValidator>();
        }
        this.validators.add(validator);
        return this;
    }

    public boolean validate() {
        if (this.validators != null && !this.validators.isEmpty()) {
            Editable text = this.getEditText().getText();
            boolean isEmpty = text.length() == 0;
            boolean isValid = true;
            for (TILValidator validator : this.validators) {
                if (isValid = isValid && validator.isValid((CharSequence)text, isEmpty)) continue;
                this.setError(validator.getErrorMessage());
                this.setErrorTextColor(this.getErrorColorStateList());
                break;
            }
            if (isValid) {
                this.setError(null);
            }
            this.postInvalidate();
            return isValid;
        }
        return true;
    }

    private ColorStateList getErrorColorStateList() {
        int[][] states = new int[][]{{-16842910}};
        int[] colors = new int[]{-65536};
        return new ColorStateList((int[][])states, colors);
    }

    public boolean hasValidators() {
        return this.validators != null && !this.validators.isEmpty();
    }

    public void initTextWatchers() {
        this.getEditText().addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                if (MaterialTextInputLayout.this.validators != null && !MaterialTextInputLayout.this.validators.isEmpty()) {
                    Editable text = MaterialTextInputLayout.this.getEditText().getText();
                    boolean isEmpty = text.length() == 0;
                    boolean isValid = true;
                    for (TILValidator validator : MaterialTextInputLayout.this.validators) {
                        boolean bl = isValid = isValid && validator.isValid((CharSequence)text, isEmpty);
                        if (!isValid) {
                            MaterialTextInputLayout.this.setError(validator.getErrorMessage());
                            break;
                        }
                        MaterialTextInputLayout.this.setError(null);
                    }
                }
            }
        });
    }
}

