/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.widgets;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentManager;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.timepicker.MaterialTimePicker;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.customviews.MaterialTextInputLayout;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.fragments.JsonFormFragment;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.ClickableFormWidget;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.FormWidgetFactory;
import com.vijay.jsonwizard.utils.DateUtils;
import com.vijay.jsonwizard.utils.ExpressionResolverContextUtils;
import com.vijay.jsonwizard.utils.ValidationStatus;
import com.vijay.jsonwizard.validators.textinputlayout.RequiredValidator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class TimePickerFactory
implements FormWidgetFactory,
ClickableFormWidget {
    private static final String TAG = "TimePickerFactory";

    public static ValidationStatus validate(MaterialTextInputLayout materialTextInputLayout) {
        boolean validate = materialTextInputLayout.validate();
        if (!validate) {
            return new ValidationStatus(false, materialTextInputLayout.getError().toString());
        }
        return new ValidationStatus(true, null);
    }

    @Override
    public List<View> getViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) throws JSONException {
        List<View> views = null;
        switch (visualizationMode) {
            case 2: {
                views = this.getReadOnlyViewsFromJson(context, jsonObject, bundle);
                break;
            }
            default: {
                views = this.getEditableViewsFromJson(stepName, context, jsonObject, bundle, resolver, listener);
            }
        }
        return views;
    }

    private List<View> getEditableViewsFromJson(String stepName, Context context, JSONObject jsonObject, JsonFormBundle bundle, JsonExpressionResolver resolver, CommonListener listener) throws JSONException {
        String requiredValue;
        JSONObject requiredObject;
        ArrayList<View> views = new ArrayList<View>(1);
        MaterialTextInputLayout materialTextInputLayout = (MaterialTextInputLayout)LayoutInflater.from((Context)context).inflate(R.layout.item_material_edit_text, null);
        EditText editText = materialTextInputLayout.getEditText();
        String hint = bundle.resolveKey(jsonObject.getString("hint"));
        materialTextInputLayout.setHint(hint);
        editText.setId(View.generateViewId());
        materialTextInputLayout.setTag(R.id.key, jsonObject.getString("key"));
        materialTextInputLayout.setTag(R.id.type, "time_picker");
        materialTextInputLayout.setTag(R.id.v_pattern, bundle.resolveKey(jsonObject.getString("pattern")));
        editText.setTag(R.id.key, (Object)jsonObject.getString("key"));
        editText.setTag(R.id.type, (Object)"time_picker");
        String widgetPattern = bundle.resolveKey(jsonObject.getString("pattern"));
        editText.setTag(R.id.v_pattern, (Object)bundle.resolveKey(jsonObject.getString("pattern")));
        materialTextInputLayout.setTag(R.id.v_pattern, bundle.resolveKey(jsonObject.getString("pattern")));
        String value = jsonObject.optString("value");
        if (!TextUtils.isEmpty((CharSequence)value)) {
            try {
                Date date = DateUtils.parseDate(value, widgetPattern);
                SimpleDateFormat dateFormatter = new SimpleDateFormat(widgetPattern);
                editText.setText((CharSequence)dateFormatter.format(date));
            }
            catch (IllegalArgumentException e) {
                Log.e((String)TAG, (String)("Error parsing " + value + ": " + e.getMessage()));
            }
        }
        if ((requiredObject = jsonObject.optJSONObject("v_required")) != null && !TextUtils.isEmpty((CharSequence)(requiredValue = requiredObject.getString("value")))) {
            boolean required = false;
            if (resolver.isValidExpression(requiredValue)) {
                JSONObject currentValues = this.getCurrentValues(context, stepName);
                required = resolver.existsExpression(requiredValue, currentValues);
            } else {
                required = Boolean.TRUE.toString().equalsIgnoreCase(requiredValue);
            }
            if (required) {
                materialTextInputLayout.addValidator(new RequiredValidator(bundle.resolveKey(requiredObject.getString("err"))));
            }
        }
        editText.setInputType(0);
        editText.setOnClickListener((View.OnClickListener)listener);
        editText.setOnFocusChangeListener((View.OnFocusChangeListener)listener);
        views.add((View)materialTextInputLayout);
        materialTextInputLayout.initTextWatchers();
        return views;
    }

    private List<View> getReadOnlyViewsFromJson(Context context, JSONObject jsonObject, JsonFormBundle bundle) throws JSONException {
        ArrayList<View> views = new ArrayList<View>(1);
        MaterialTextInputLayout textInputLayout = (MaterialTextInputLayout)LayoutInflater.from((Context)context).inflate(R.layout.item_edit_text, null);
        EditText editText = textInputLayout.getEditText();
        String hint = bundle.resolveKey(jsonObject.getString("hint"));
        textInputLayout.setHint(hint);
        textInputLayout.setId(View.generateViewId());
        textInputLayout.setTag(R.id.key, jsonObject.getString("key"));
        textInputLayout.setTag(R.id.type, jsonObject.getString("type"));
        editText.setId(View.generateViewId());
        editText.setTag(R.id.key, (Object)jsonObject.getString("key"));
        editText.setTag(R.id.type, (Object)jsonObject.getString("type"));
        String widgetPattern = bundle.resolveKey(jsonObject.getString("pattern"));
        editText.setTag(R.id.v_pattern, (Object)widgetPattern);
        textInputLayout.setTag(R.id.v_pattern, widgetPattern);
        String value = jsonObject.optString("value");
        if (!TextUtils.isEmpty((CharSequence)value)) {
            try {
                editText.setText((CharSequence)value);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)TAG, (String)("Error parsing " + value + ": " + e.getMessage()));
            }
        }
        editText.setEnabled(false);
        views.add((View)editText);
        return views;
    }

    @Nullable
    private JSONObject getCurrentValues(Context context, String stepName) throws JSONException {
        return ExpressionResolverContextUtils.getCurrentValues(context, stepName);
    }

    @Override
    public void onClick(JsonFormFragment jsonFormFragment, View v) {
        jsonFormFragment.hideKeyBoard();
        TimePickerListener timePickerListener = new TimePickerListener((TextInputEditText)v, (String)v.getTag(R.id.v_pattern), jsonFormFragment.getActivity().getSupportFragmentManager());
        timePickerListener.openTimePicker(v);
    }

    @Override
    public void onFocusChange(JsonFormFragment jsonFormFragment, boolean focus, View v) {
        if (focus) {
            jsonFormFragment.hideKeyBoard();
            TimePickerListener timePickerListener = new TimePickerListener((TextInputEditText)v, (String)v.getTag(R.id.v_pattern), jsonFormFragment.getActivity().getSupportFragmentManager());
            timePickerListener.openTimePicker(v);
        }
    }

    private class TimePickerListener {
        private MaterialTimePicker d;
        private TextInputEditText timeText;
        private static final String TAG = "TimePickerListener";
        private String formatString;
        private FragmentManager fragmentManager;

        private TimePickerListener(TextInputEditText textInputEditText, String formatString, FragmentManager fragmentManager) {
            this.timeText = textInputEditText;
            this.formatString = formatString;
            this.fragmentManager = fragmentManager;
        }

        private void openTimePicker(View view) {
            int hour = 0;
            int minute = 0;
            String timeStr = this.timeText.getText().toString();
            String pattern = (String)this.timeText.getTag(R.id.v_pattern);
            if (timeStr != null && !"".equals(timeStr)) {
                try {
                    SimpleDateFormat dateFormatter = new SimpleDateFormat(pattern);
                    Calendar c = Calendar.getInstance();
                    c.setTime(dateFormatter.parse(timeStr));
                    hour = c.get(11);
                    minute = c.get(12);
                }
                catch (ParseException e) {
                    Log.e((String)TAG, (String)("Error parsing " + timeStr + ": " + e.getMessage()));
                }
            } else {
                Calendar c = Calendar.getInstance();
                hour = c.get(11);
                minute = c.get(12);
            }
            MaterialTimePicker.Builder builder = new MaterialTimePicker.Builder().setTimeFormat(1).setHour(hour).setMinute(minute);
            this.d = builder.build();
            this.d.addOnPositiveButtonClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    TimePickerListener.this.timeText.setText((CharSequence)String.format("%02d:%02d", TimePickerListener.this.d.getHour(), TimePickerListener.this.d.getMinute()));
                    TimePickerListener.this.d.dismiss();
                }
            });
            this.d.show(this.fragmentManager, TAG);
        }
    }
}

