/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.widgets;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.customviews.MaterialTextInputLayout;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.fragments.JsonFormFragment;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.ClickableFormWidget;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.FormWidgetFactory;
import com.vijay.jsonwizard.maps.LocationPart;
import com.vijay.jsonwizard.maps.LocationTextWatcher;
import com.vijay.jsonwizard.maps.LocationValueReporter;
import com.vijay.jsonwizard.maps.MapsActivity;
import com.vijay.jsonwizard.maps.MapsUtils;
import com.vijay.jsonwizard.utils.ExpressionResolverContextUtils;
import com.vijay.jsonwizard.utils.ValidationStatus;
import com.vijay.jsonwizard.validators.textinputlayout.EqualsValidator;
import com.vijay.jsonwizard.validators.textinputlayout.RequiredValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class LocationPickerFactory
implements FormWidgetFactory,
ClickableFormWidget {
    public static final String KEY_SUFFIX_LATITUDE = "_latitude";
    public static final String KEY_SUFFIX_LONGITUDE = "_longitude";
    public static final String KEY_SUFFIX_ACCURACY = "_accuracy";
    private static final int RESULT_LOAD_LOCATION = 3;
    private static final String TAG = "JsonFormActivity";
    private static final int INPUT_TYPE_DECIMAL_NUMBER = 12290;

    public static ValidationStatus validate(MaterialTextInputLayout editText) {
        boolean validate = editText.validate();
        if (!validate) {
            return new ValidationStatus(false, editText.getError().toString());
        }
        return new ValidationStatus(true, null);
    }

    @Override
    public List<View> getViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) throws Exception {
        List<View> views;
        switch (visualizationMode) {
            case 2: {
                views = this.getReadOnlyViewsFromJson(stepName, context, jsonObject, bundle, resolver, resourceResolver);
                break;
            }
            default: {
                views = this.getEditableViewsFromJson(stepName, context, jsonObject, listener, bundle, resolver, resourceResolver);
            }
        }
        return views;
    }

    private List<View> getEditableViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver) throws JSONException {
        String requiredValue;
        String readonlyValue = jsonObject.optString("readonly");
        boolean readonly = false;
        if (resolver.isValidExpression(readonlyValue)) {
            JSONObject currentValues = this.getCurrentValues(context, stepName);
            readonly = resolver.existsExpression(readonlyValue, currentValues);
        } else {
            readonly = Boolean.TRUE.toString().equalsIgnoreCase(readonlyValue);
        }
        if (readonly) {
            return this.getReadOnlyViewsFromJson(stepName, context, jsonObject, bundle, resolver, resourceResolver);
        }
        String jsonKey = jsonObject.getString("key");
        String jsonInputType = jsonObject.getString("type");
        ArrayList<View> views = new ArrayList<View>(1);
        View parentView = LayoutInflater.from((Context)context).inflate(R.layout.item_location_text, null);
        parentView.setTag(R.id.key, (Object)jsonKey);
        parentView.setTag(R.id.type, (Object)jsonInputType);
        this.loadMapConfig(stepName, context, jsonObject, resolver, parentView);
        boolean accuracyEnabled = jsonObject.has("accuracy") && jsonObject.getBoolean("accuracy");
        parentView.setTag(R.id.accuracy, (Object)accuracyEnabled);
        if (jsonObject.has("icon")) {
            String customIcon = jsonObject.getString("icon");
            customIcon = resourceResolver.resolvePath(context, customIcon);
            parentView.setTag(R.id.custom_icon, (Object)customIcon);
        }
        View mapContainer = parentView.findViewById(R.id.map_container);
        mapContainer.setId(View.generateViewId());
        mapContainer.setTag((Object)R.id.map_container);
        String hint = bundle.resolveKey(jsonObject.getString("hint"));
        TextView label = (TextView)parentView.findViewById(R.id.location_label);
        label.setText((CharSequence)hint);
        View inputContainer = parentView.findViewById(R.id.value_container);
        inputContainer.setTag(R.id.key, (Object)jsonKey);
        inputContainer.setTag(R.id.type, (Object)jsonInputType);
        boolean editable = jsonObject.optBoolean("editable");
        MaterialTextInputLayout etLatitude = (MaterialTextInputLayout)parentView.findViewById(R.id.location_latitude);
        EditText etLatitudeEditText = etLatitude.getEditText();
        etLatitude.setId(View.generateViewId());
        etLatitude.setEnabled(editable);
        etLatitudeEditText.setInputType(12290);
        etLatitude.setTag(R.id.key, jsonKey + KEY_SUFFIX_LATITUDE);
        etLatitude.setTag(R.id.type, jsonInputType);
        etLatitudeEditText.setTag(R.id.key, (Object)(jsonKey + KEY_SUFFIX_LATITUDE));
        etLatitudeEditText.setTag(R.id.type, (Object)jsonInputType);
        MaterialTextInputLayout etLongitude = (MaterialTextInputLayout)parentView.findViewById(R.id.location_longitude);
        EditText etLongitudeEditText = etLongitude.getEditText();
        etLongitude.setId(View.generateViewId());
        etLongitude.setEnabled(editable);
        etLongitudeEditText.setInputType(12290);
        etLongitude.setTag(R.id.key, jsonKey + KEY_SUFFIX_LONGITUDE);
        etLongitude.setTag(R.id.type, jsonInputType);
        etLongitudeEditText.setTag(R.id.key, (Object)(jsonKey + KEY_SUFFIX_LONGITUDE));
        etLongitudeEditText.setTag(R.id.type, (Object)jsonInputType);
        MaterialTextInputLayout etAccuracy = (MaterialTextInputLayout)parentView.findViewById(R.id.location_accuracy);
        EditText etAccuracyEditText = etAccuracy.getEditText();
        etAccuracy.setId(View.generateViewId());
        etAccuracyEditText.setInputType(12290);
        etAccuracy.setTag(R.id.key, jsonKey + KEY_SUFFIX_ACCURACY);
        etAccuracy.setTag(R.id.type, jsonInputType);
        etAccuracyEditText.setTag(R.id.key, (Object)(jsonKey + KEY_SUFFIX_ACCURACY));
        etAccuracyEditText.setTag(R.id.type, (Object)jsonInputType);
        if (accuracyEnabled) {
            etAccuracy.setEnabled(editable);
            etAccuracy.setVisibility(0);
        } else {
            etAccuracy.setVisibility(8);
        }
        ImageView imageView = (ImageView)parentView.findViewById(R.id.icon);
        String key = jsonKey;
        imageView.setTag(R.id.key, (Object)jsonKey);
        imageView.setTag(R.id.type, (Object)jsonInputType);
        String customIconInput = jsonObject.optString("icon_input");
        if (!TextUtils.isEmpty((CharSequence)customIconInput)) {
            String customIconPath = resourceResolver.resolvePath(context, customIconInput);
            Bitmap bitmap = BitmapFactory.decodeFile((String)customIconPath);
            imageView.setImageBitmap(bitmap);
        }
        View.OnClickListener onClickListenerWithValue = this.getOnClickListenerWithValue(parentView, etLatitudeEditText, etLongitudeEditText, etAccuracyEditText, listener, accuracyEnabled);
        imageView.setOnClickListener(onClickListenerWithValue);
        mapContainer.setOnClickListener(onClickListenerWithValue);
        String value = jsonObject.optString("value");
        if (!TextUtils.isEmpty((CharSequence)value)) {
            String resolvedValue;
            if (resolver.isValidExpression(value)) {
                resolvedValue = resolver.resolveAsString(value, this.getCurrentValues(context, stepName));
                if (resolvedValue == null) {
                    resolvedValue = "";
                }
            } else {
                resolvedValue = value;
            }
            this.fillDefaultValue(parentView, etLatitudeEditText, etLongitudeEditText, etAccuracyEditText, resolvedValue);
            mapContainer.findViewById(R.id.map_placeholder).setVisibility(8);
        } else {
            mapContainer.findViewById(R.id.map_placeholder).setVisibility(0);
        }
        JSONObject requiredObject = jsonObject.optJSONObject("v_required");
        if (requiredObject != null && !TextUtils.isEmpty((CharSequence)(requiredValue = requiredObject.getString("value")))) {
            boolean required = false;
            if (resolver.isValidExpression(requiredValue)) {
                JSONObject currentValues = this.getCurrentValues(context, stepName);
                required = resolver.existsExpression(requiredValue, currentValues);
            } else {
                required = Boolean.TRUE.toString().equalsIgnoreCase(requiredValue);
            }
            if (required) {
                etLatitude.addValidator(new RequiredValidator(bundle.resolveKey(requiredObject.getString("err"))));
                etLongitude.addValidator(new RequiredValidator(bundle.resolveKey(requiredObject.getString("err"))));
                if (accuracyEnabled) {
                    etAccuracy.addValidator(new RequiredValidator(bundle.resolveKey(requiredObject.getString("err"))));
                }
            }
        }
        JSONObject accuracyValidator = jsonObject.optJSONObject("v_exact_position");
        if (accuracyEnabled && accuracyValidator != null) {
            etAccuracy.addValidator(new EqualsValidator("-1", bundle.resolveKey(accuracyValidator.getString("err")), true));
        }
        LocationValueReporter valueReporter = TextUtils.isEmpty((CharSequence)value) ? new LocationValueReporter(stepName, parentView, accuracyEnabled) : new LocationValueReporter(stepName, parentView, value, accuracyEnabled);
        etLatitudeEditText.addTextChangedListener((TextWatcher)new LocationTextWatcher(LocationPart.LATITUDE, valueReporter));
        etLongitudeEditText.addTextChangedListener((TextWatcher)new LocationTextWatcher(LocationPart.LONGITUDE, valueReporter));
        if (accuracyEnabled) {
            etAccuracyEditText.addTextChangedListener((TextWatcher)new LocationTextWatcher(LocationPart.ACCURACY, valueReporter));
        }
        views.add(parentView);
        return views;
    }

    private void loadMapConfig(String stepName, Context context, JSONObject jsonObject, JsonExpressionResolver resolver, View parentView) throws JSONException {
        if (jsonObject.has("map_config")) {
            JSONObject mapConfig;
            String expression = jsonObject.optString("map_config");
            if (resolver.isValidExpression(expression)) {
                JSONObject currentValues = this.getCurrentValues(context, stepName);
                mapConfig = resolver.resolveAsObject(expression, currentValues);
            } else {
                mapConfig = jsonObject.getJSONObject("map_config");
            }
            parentView.setTag(R.id.map_min_zoom, (Object)mapConfig.optDouble("min_zoom", 8.0));
            parentView.setTag(R.id.map_max_zoom, (Object)mapConfig.optDouble("max_zoom", 18.0));
            parentView.setTag(R.id.map_default_zoom, (Object)mapConfig.optDouble("default_zoom"));
        }
    }

    private List<View> getReadOnlyViewsFromJson(String stepName, Context context, JSONObject jsonObject, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver) throws JSONException {
        String value;
        boolean accuracyEnabled;
        ArrayList<View> views = new ArrayList<View>(1);
        View parentView = LayoutInflater.from((Context)context).inflate(R.layout.item_location_text, null);
        String jsonKey = jsonObject.getString("key");
        String jsonInputType = jsonObject.getString("type");
        parentView.setTag(R.id.key, (Object)jsonKey);
        parentView.setTag(R.id.type, (Object)jsonInputType);
        this.loadMapConfig(stepName, context, jsonObject, resolver, parentView);
        View mapContainer = parentView.findViewById(R.id.map_container);
        mapContainer.setId(View.generateViewId());
        mapContainer.setTag((Object)R.id.map_container);
        String hint = bundle.resolveKey(jsonObject.getString("hint"));
        TextView label = (TextView)parentView.findViewById(R.id.location_label);
        label.setText((CharSequence)hint);
        MaterialTextInputLayout etLatitude = (MaterialTextInputLayout)parentView.findViewById(R.id.location_latitude);
        EditText etLatitudeEditText = etLatitude.getEditText();
        etLatitude.setId(View.generateViewId());
        etLatitude.setEnabled(false);
        etLatitudeEditText.setInputType(12290);
        etLatitude.setTag(R.id.key, jsonKey + KEY_SUFFIX_LATITUDE);
        etLatitude.setTag(R.id.type, jsonInputType);
        etLatitudeEditText.setTag(R.id.key, (Object)(jsonKey + KEY_SUFFIX_LATITUDE));
        etLatitudeEditText.setTag(R.id.type, (Object)jsonInputType);
        MaterialTextInputLayout etLongitude = (MaterialTextInputLayout)parentView.findViewById(R.id.location_longitude);
        EditText etLongitudeEditText = etLongitude.getEditText();
        etLongitude.setId(View.generateViewId());
        etLongitude.setEnabled(false);
        etLongitudeEditText.setInputType(12290);
        etLongitude.setTag(R.id.key, jsonKey + KEY_SUFFIX_LONGITUDE);
        etLongitude.setTag(R.id.type, jsonInputType);
        etLongitudeEditText.setTag(R.id.key, (Object)(jsonKey + KEY_SUFFIX_LONGITUDE));
        etLongitudeEditText.setTag(R.id.type, (Object)jsonInputType);
        MaterialTextInputLayout etAccuracy = (MaterialTextInputLayout)parentView.findViewById(R.id.location_accuracy);
        EditText etAccuracyEditText = etAccuracy.getEditText();
        etAccuracy.setId(View.generateViewId());
        etAccuracy.setEnabled(false);
        etAccuracyEditText.setInputType(12290);
        etAccuracy.setTag(R.id.key, jsonKey + KEY_SUFFIX_ACCURACY);
        etAccuracy.setTag(R.id.type, jsonInputType);
        etAccuracyEditText.setTag(R.id.key, (Object)(jsonKey + KEY_SUFFIX_ACCURACY));
        etAccuracyEditText.setTag(R.id.type, (Object)jsonInputType);
        boolean bl = accuracyEnabled = jsonObject.has("accuracy") && jsonObject.getBoolean("accuracy");
        if (accuracyEnabled) {
            etAccuracy.setVisibility(0);
        }
        if (!TextUtils.isEmpty((CharSequence)(value = jsonObject.optString("value")))) {
            String resolvedValue;
            if (resolver.isValidExpression(value)) {
                resolvedValue = resolver.resolveAsString(value, this.getCurrentValues(context, stepName));
                if (resolvedValue == null) {
                    resolvedValue = "";
                }
            } else {
                resolvedValue = value;
            }
            this.fillDefaultValue(parentView, etLatitudeEditText, etLongitudeEditText, etAccuracyEditText, resolvedValue);
        } else {
            mapContainer.setVisibility(8);
            FrameLayout containerParent = (FrameLayout)mapContainer.getParent();
            containerParent.setVisibility(8);
        }
        ImageView imageView = (ImageView)parentView.findViewById(R.id.icon);
        imageView.setClickable(false);
        imageView.setEnabled(false);
        imageView.setVisibility(8);
        views.add(parentView);
        return views;
    }

    private void fillDefaultValue(View parentView, EditText etLatitude, EditText etLongitude, EditText etAccuracy, String value) {
        parentView.setTag(R.id.value, (Object)value);
        String[] parts = value.split(",");
        if (parts.length > 0) {
            etLatitude.setText((CharSequence)parts[0].trim());
        }
        if (parts.length > 1) {
            etLongitude.setText((CharSequence)parts[1].trim());
        }
        if (parts.length > 2) {
            etAccuracy.setText((CharSequence)parts[2].trim());
        }
    }

    private View.OnClickListener getOnClickListenerWithValue(final View parentView, final EditText etLatitude, final EditText etLongitude, final EditText etAccuracy, final CommonListener listener, final boolean accuracy) {
        return new View.OnClickListener(){

            public void onClick(View v) {
                String value = accuracy ? MapsUtils.toString(etLatitude.getText().toString(), etLongitude.getText().toString(), etAccuracy.getText().toString()) : MapsUtils.toString(etLatitude.getText().toString(), etLongitude.getText().toString());
                parentView.setTag(R.id.value, (Object)value);
                listener.onClick(parentView);
            }
        };
    }

    @Nullable
    private JSONObject getCurrentValues(Context context, String stepName) throws JSONException {
        return ExpressionResolverContextUtils.getCurrentValues(context, stepName);
    }

    @Override
    public void onClick(JsonFormFragment jsonFormFragment, View v) {
        String customIcon;
        Log.d((String)TAG, (String)"onClick: location");
        jsonFormFragment.hideKeyBoard();
        Intent intent = new Intent(v.getContext(), MapsActivity.class);
        String value = (String)v.getTag(R.id.value);
        boolean useAccuracy = (Boolean)v.getTag(R.id.accuracy);
        if (value != null && MapsUtils.isValidPositionString(value)) {
            intent.putExtra("INITIAL_LOCATION", value);
        }
        if ((customIcon = (String)v.getTag(R.id.custom_icon)) != null) {
            intent.putExtra("CUSTOM_MARKER_ICON", customIcon);
        }
        intent.putExtra("USE_ACCURACY", useAccuracy);
        intent.putExtra("CONFIG_MIN_ZOOM", (Serializable)((Double)v.getTag(R.id.map_min_zoom)));
        intent.putExtra("CONFIG_MAX_ZOOM", (Serializable)((Double)v.getTag(R.id.map_max_zoom)));
        Double defaultZoom = (Double)v.getTag(R.id.map_default_zoom);
        if (defaultZoom != null && !defaultZoom.isNaN()) {
            intent.putExtra("CONFIG_DEFAULT_ZOOM", (Serializable)defaultZoom);
        }
        jsonFormFragment.startActivityForResult(intent, 3);
    }

    @Override
    public void onFocusChange(JsonFormFragment jsonFormFragment, boolean focus, View v) {
    }
}

