/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.widgets;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.SpinnerAdapter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.rengwuxian.materialedittext.MaterialEditText;
import com.rey.material.util.ViewUtil;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.FormWidgetFactory;
import com.vijay.jsonwizard.utils.ExpressionResolverContextUtils;
import com.vijay.jsonwizard.utils.ValidationStatus;
import fr.ganfra.materialspinner.MaterialSpinner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SpinnerFactory
implements FormWidgetFactory {
    public static ValidationStatus validate(MaterialSpinner spinner) {
        if (!(spinner.getTag(R.id.v_required) instanceof String) || !(spinner.getTag(R.id.error) instanceof String)) {
            return new ValidationStatus(true, null);
        }
        Boolean isRequired = Boolean.valueOf((String)spinner.getTag(R.id.v_required));
        if (!isRequired.booleanValue()) {
            return new ValidationStatus(true, null);
        }
        int selectedItemPosition = spinner.getSelectedItemPosition();
        if (selectedItemPosition > 0) {
            return new ValidationStatus(true, null);
        }
        return new ValidationStatus(false, (String)spinner.getTag(R.id.error));
    }

    @Override
    public List<View> getViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) throws JSONException {
        List<View> views = null;
        switch (visualizationMode) {
            case 2: {
                views = this.getReadOnlyViewsFromJson(stepName, context, jsonObject, bundle, resolver);
                break;
            }
            default: {
                views = this.getEditableViewsFromJson(stepName, context, jsonObject, listener, bundle, resolver);
            }
        }
        return views;
    }

    private List<View> getEditableViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver) throws JSONException {
        String requiredValue;
        ArrayList<View> views = new ArrayList<View>(1);
        MaterialSpinner spinner = (MaterialSpinner)LayoutInflater.from((Context)context).inflate(R.layout.item_spinner, null);
        String hint = bundle.resolveKey(jsonObject.optString("hint"));
        if (!TextUtils.isEmpty((CharSequence)hint)) {
            spinner.setHint((CharSequence)hint);
            spinner.setFloatingLabelText((CharSequence)hint);
        }
        spinner.setId(ViewUtil.generateViewId());
        spinner.setTag(R.id.key, (Object)jsonObject.getString("key"));
        spinner.setTag(R.id.type, (Object)jsonObject.getString("type"));
        JSONObject requiredObject = jsonObject.optJSONObject("v_required");
        if (requiredObject != null && !TextUtils.isEmpty((CharSequence)(requiredValue = requiredObject.getString("value")))) {
            spinner.setTag(R.id.v_required, (Object)requiredValue);
            spinner.setTag(R.id.error, (Object)bundle.resolveKey(requiredObject.optString("err")));
        }
        String valueToSelect = "";
        int indexToSelect = -1;
        String value = jsonObject.optString("value");
        if (!TextUtils.isEmpty((CharSequence)value)) {
            if (resolver.isValidExpression(value)) {
                valueToSelect = resolver.resolveAsString(value, this.getCurrentValues(context, stepName));
                if (valueToSelect == null) {
                    valueToSelect = "";
                }
            } else {
                valueToSelect = value;
            }
        }
        JSONArray valuesJson = this.resolveOptJSONArray("values", context, stepName, jsonObject, resolver);
        JSONArray labelsJson = this.resolveOptJSONArray("labels", context, stepName, jsonObject, resolver);
        Object[] values = this.getValues(valuesJson, labelsJson, bundle);
        String otherOption = bundle.resolveKey(jsonObject.optString("other"));
        if (!TextUtils.isEmpty((CharSequence)otherOption)) {
            ArrayList<ValueLabelPair> valuesWithOther = new ArrayList<ValueLabelPair>(Arrays.asList(values));
            valuesWithOther.add(new ValueLabelPair(otherOption, otherOption));
            values = (ValueLabelPair[])valuesWithOther.toArray(values);
        }
        indexToSelect = this.getSelectedIdx((ValueLabelPair[])values, valueToSelect);
        if (values != null) {
            spinner.setAdapter((SpinnerAdapter)new ArrayAdapter(context, 17367043, values));
            spinner.setSelection(indexToSelect + 1, true);
            spinner.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)listener);
        }
        views.add((View)spinner);
        return views;
    }

    @Nullable
    private JSONObject getCurrentValues(Context context, String stepName) throws JSONException {
        return ExpressionResolverContextUtils.getCurrentValues(context, stepName);
    }

    private ValueLabelPair[] getValues(JSONArray valuesJson, JSONArray labelsJson, JsonFormBundle bundle) {
        ValueLabelPair[] values = null;
        if (valuesJson != null && valuesJson.length() > 0) {
            int valuesJsonLength = valuesJson.length();
            values = new ValueLabelPair[valuesJsonLength];
            for (int i = 0; i < valuesJsonLength; ++i) {
                String value = valuesJson.optString(i);
                if (labelsJson != null) {
                    String label = labelsJson.optString(i);
                    values[i] = new ValueLabelPair(value, bundle.resolveKey(label));
                    continue;
                }
                values[i] = new ValueLabelPair(value, value);
            }
        }
        return values;
    }

    private int getSelectedIdx(ValueLabelPair[] values, String valueToSelect) {
        int indexToSelect = -1;
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                if (!valueToSelect.equals(values[i].value)) continue;
                indexToSelect = i;
                break;
            }
        }
        return indexToSelect;
    }

    private String getValuesAsJsonExpression(JSONObject jsonObject, JsonExpressionResolver resolver) {
        String valuesExpression = jsonObject.optString("values");
        if (resolver.isValidExpression(valuesExpression)) {
            return valuesExpression;
        }
        return null;
    }

    private List<View> getReadOnlyViewsFromJson(String stepName, Context context, JSONObject jsonObject, JsonFormBundle bundle, JsonExpressionResolver resolver) throws JSONException {
        ArrayList<View> views = new ArrayList<View>(1);
        MaterialEditText editText = (MaterialEditText)LayoutInflater.from((Context)context).inflate(R.layout.item_edit_text, null);
        editText.setId(ViewUtil.generateViewId());
        String hint = jsonObject.getString("hint");
        editText.setHint((CharSequence)hint);
        editText.setFloatingLabelText((CharSequence)hint);
        editText.setTag(R.id.key, (Object)jsonObject.getString("key"));
        editText.setTag(R.id.type, (Object)jsonObject.getString("type"));
        String value = jsonObject.optString("value");
        JSONArray labelsJson = this.resolveOptJSONArray("labels", context, stepName, jsonObject, resolver);
        if (labelsJson != null) {
            JSONArray valuesJson = this.resolveOptJSONArray("values", context, stepName, jsonObject, resolver);
            ValueLabelPair[] values = this.getValues(valuesJson, labelsJson, bundle);
            editText.setText((CharSequence)bundle.resolveKey(labelsJson.optString(this.getSelectedIdx(values, value))));
        } else {
            editText.setText((CharSequence)value);
        }
        editText.setEnabled(false);
        views.add((View)editText);
        return views;
    }

    private JSONArray resolveOptJSONArray(String key, Context context, String stepName, JSONObject jsonObject, JsonExpressionResolver resolver) throws JSONException {
        JSONArray array;
        String jsonExpression = jsonObject.optString(key);
        if (resolver.isValidExpression(jsonExpression)) {
            JSONObject currentValues = this.getCurrentValues(context, stepName);
            array = resolver.resolveAsArray(jsonExpression, currentValues);
        } else {
            array = jsonObject.optJSONArray(key);
        }
        return array;
    }

    public static class ValueLabelPair {
        private String value;
        private String label;

        public ValueLabelPair(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getValue() {
            return this.value;
        }

        public String getLabel() {
            return this.label;
        }

        @NonNull
        public String toString() {
            return this.label != null ? this.label : this.value;
        }
    }
}

