/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.widgets;

import android.content.Context;
import android.text.Html;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.rengwuxian.materialedittext.MaterialEditText;
import com.rey.material.util.ViewUtil;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.FormWidgetFactory;
import com.vijay.jsonwizard.utils.ExpressionResolverContextUtils;
import com.vijay.jsonwizard.utils.FormUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class LabelFactory
implements FormWidgetFactory {
    private static final String KEY_FIELD = "key";
    private static final String TEXT_FIELD = "text";
    private static final String TYPE_FIELD = "type";
    private static final String HINT_FIELD = "hint";
    private static final String BOLD_FIELD = "bold";

    @Override
    public List<View> getViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)jsonObject.optString(HINT_FIELD))) {
            return this.getAsLabel(stepName, context, jsonObject, listener, bundle, resolver, visualizationMode);
        }
        return this.getAsReadOnlyEditText(stepName, context, jsonObject, listener, bundle, resolver, visualizationMode);
    }

    private List<View> getAsLabel(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, int visualizationMode) throws JSONException {
        ArrayList<View> views = new ArrayList<View>(1);
        LinearLayout.LayoutParams layoutParams = FormUtils.getLayoutParams(-2, -2, 0, 0, 0, (int)context.getResources().getDimension(R.dimen.default_bottom_margin));
        String valuesExpression = this.getValuesAsJsonExpression(jsonObject, resolver);
        String textValue = null;
        if (valuesExpression == null) {
            textValue = bundle.resolveKey(jsonObject.getString(TEXT_FIELD));
        } else {
            JSONObject currentValues = this.getCurrentValues(context, stepName);
            textValue = resolver.resolveAsString(valuesExpression, currentValues);
        }
        boolean bold = jsonObject.optBoolean(BOLD_FIELD, true);
        views.add((View)FormUtils.getTextViewWith(context, 16, Html.fromHtml((String)textValue), jsonObject.getString(KEY_FIELD), jsonObject.getString(TYPE_FIELD), layoutParams, bold ? "font/Roboto-Bold.ttf" : "font/Roboto-Regular.ttf"));
        return views;
    }

    private List<View> getAsReadOnlyEditText(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, int visualizationMode) throws JSONException {
        ArrayList<View> views = new ArrayList<View>(1);
        MaterialEditText editText = (MaterialEditText)LayoutInflater.from((Context)context).inflate(R.layout.item_edit_text, null);
        editText.setId(ViewUtil.generateViewId());
        String hint = bundle.resolveKey(jsonObject.getString(HINT_FIELD));
        editText.setHint((CharSequence)hint);
        editText.setFloatingLabelText((CharSequence)hint);
        editText.setTag(R.id.key, (Object)jsonObject.getString(KEY_FIELD));
        editText.setTag(R.id.type, (Object)jsonObject.getString(TYPE_FIELD));
        String valuesExpression = this.getValuesAsJsonExpression(jsonObject, resolver);
        String textValue = null;
        if (valuesExpression == null) {
            textValue = bundle.resolveKey(jsonObject.getString(TEXT_FIELD));
        } else {
            JSONObject currentValues = this.getCurrentValues(context, stepName);
            textValue = resolver.resolveAsString(valuesExpression, currentValues);
        }
        editText.setText((CharSequence)Html.fromHtml((String)textValue));
        editText.setEnabled(false);
        views.add((View)editText);
        return views;
    }

    @Nullable
    private JSONObject getCurrentValues(Context context, String stepName) throws JSONException {
        return ExpressionResolverContextUtils.getCurrentValues(context, stepName);
    }

    private String getValuesAsJsonExpression(JSONObject jsonObject, JsonExpressionResolver resolver) {
        String valuesExpression = jsonObject.optString(TEXT_FIELD);
        if (resolver.isValidExpression(valuesExpression)) {
            return valuesExpression;
        }
        return null;
    }
}

