/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.customviews;

import android.content.Context;
import android.content.ContextWrapper;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.interfaces.JsonApi;
import org.json.JSONException;

public class GenericTextWatcher
implements TextWatcher {
    private static final String TAG = "GenericTextWatcher";
    private View mView;
    private String mStepName;

    public GenericTextWatcher(String stepName, View view) {
        this.mView = view;
        this.mStepName = stepName;
    }

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void afterTextChanged(Editable editable) {
        String text = editable.toString();
        JsonApi api = null;
        Context ctx = this.mView.getContext();
        if (ctx instanceof JsonApi) {
            api = (JsonApi)ctx;
        } else if (ctx instanceof ContextWrapper) {
            ContextWrapper contextWrapper = (ContextWrapper)ctx;
            api = (JsonApi)contextWrapper.getBaseContext();
        } else {
            throw new RuntimeException("Could not fetch context");
        }
        String key = (String)this.mView.getTag(R.id.key);
        try {
            api.writeValue(this.mStepName, key, text);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
    }
}

