/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.barcode.common;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.Log;
import androidx.annotation.Nullable;
import com.vijay.jsonwizard.barcode.common.FrameMetadata;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class BitmapUtils {
    @Nullable
    public static Bitmap getBitmap(ByteBuffer data, FrameMetadata metadata) {
        data.rewind();
        byte[] imageInBuffer = new byte[data.limit()];
        data.get(imageInBuffer, 0, imageInBuffer.length);
        try {
            YuvImage image = new YuvImage(imageInBuffer, 17, metadata.getWidth(), metadata.getHeight(), null);
            if (image != null) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                image.compressToJpeg(new Rect(0, 0, metadata.getWidth(), metadata.getHeight()), 80, (OutputStream)stream);
                Bitmap bmp = BitmapFactory.decodeByteArray((byte[])stream.toByteArray(), (int)0, (int)stream.size());
                stream.close();
                return BitmapUtils.rotateBitmap(bmp, metadata.getRotation(), metadata.getCameraFacing());
            }
        }
        catch (Exception e) {
            Log.e((String)"VisionProcessorBase", (String)("Error: " + e.getMessage()));
        }
        return null;
    }

    private static Bitmap rotateBitmap(Bitmap bitmap, int rotation, int facing) {
        Matrix matrix = new Matrix();
        int rotationDegree = 0;
        switch (rotation) {
            case 1: {
                rotationDegree = 90;
                break;
            }
            case 2: {
                rotationDegree = 180;
                break;
            }
            case 3: {
                rotationDegree = 270;
                break;
            }
        }
        matrix.postRotate((float)rotationDegree);
        if (facing == 0) {
            return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        matrix.postScale(-1.0f, 1.0f);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }
}

