/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.utils;

import android.util.Log;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateUtils {
    private static final String TAG = "DateUtils";
    private static final String DEFAULT_DATE_PATTERN = "dd/MM/yyyy";
    private static final String JSON_DATE_PATTERN = "yyyy-MM-dd'T'hh:mm:ss.SSS'Z'";

    public static String toJSONDateFormat(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat jsonSdf = new SimpleDateFormat(JSON_DATE_PATTERN);
        return jsonSdf.format(date);
    }

    public static Date parseJSONDate(String date) {
        try {
            SimpleDateFormat jsonSdf = new SimpleDateFormat(JSON_DATE_PATTERN);
            return jsonSdf.parse(date);
        }
        catch (ParseException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Date parseDate(String date, String pattern) {
        try {
            SimpleDateFormat sdf = pattern == null || "".equals(pattern) ? new SimpleDateFormat(DEFAULT_DATE_PATTERN) : new SimpleDateFormat(pattern);
            return sdf.parse(date);
        }
        catch (ParseException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String formatDate(Date date, String pattern) {
        SimpleDateFormat sdf = pattern == null || "".equals(pattern) ? new SimpleDateFormat(DEFAULT_DATE_PATTERN) : new SimpleDateFormat(pattern);
        return sdf.format(date);
    }
}

