/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.fragments;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioGroup;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import com.rengwuxian.materialedittext.MaterialEditText;
import com.rey.material.widget.Switch;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.activities.JsonFormActivity;
import com.vijay.jsonwizard.customviews.RadioButton;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.JsonApi;
import com.vijay.jsonwizard.maps.MapsUtils;
import com.vijay.jsonwizard.mvp.MvpFragment;
import com.vijay.jsonwizard.presenters.JsonFormFragmentPresenter;
import com.vijay.jsonwizard.utils.CarouselAdapter;
import com.vijay.jsonwizard.utils.PropertiesUtils;
import com.vijay.jsonwizard.views.JsonFormFragmentView;
import com.vijay.jsonwizard.viewstates.JsonFormFragmentViewState;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonFormFragment
extends MvpFragment<JsonFormFragmentPresenter, JsonFormFragmentViewState>
implements CommonListener,
JsonFormFragmentView<JsonFormFragmentViewState> {
    private static final String TAG = "JsonFormFragment";
    private LinearLayout mMainView;
    private Menu mMenu;
    private JsonApi mJsonApi;

    public static JsonFormFragment getFormFragment(String stepName) {
        JsonFormFragment jsonFormFragment = new JsonFormFragment();
        Bundle bundle = new Bundle();
        bundle.putString("stepName", stepName);
        jsonFormFragment.setArguments(bundle);
        return jsonFormFragment;
    }

    public JsonApi getJsonApi() {
        return this.mJsonApi;
    }

    public void setJsonApi(JsonApi jsonApi) {
        this.mJsonApi = jsonApi;
    }

    public void onAttach(Context activity) {
        if (activity instanceof JsonApi) {
            this.mJsonApi = (JsonApi)activity;
        }
        super.onAttach(activity);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        this.setHasOptionsMenu(true);
        super.onCreate(savedInstanceState);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_json_wizard, null);
        this.mMainView = (LinearLayout)rootView.findViewById(R.id.main_layout);
        return rootView;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        ((JsonFormFragmentPresenter)this.presenter).addFormElements();
    }

    public void onResume() {
        super.onResume();
        int childCount = this.mMainView.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            String value;
            View view = this.mMainView.getChildAt(i);
            if (!"location".equals(view.getTag(R.id.type)) || TextUtils.isEmpty((CharSequence)(value = (String)view.getTag(R.id.value)))) continue;
            String key = (String)view.getTag(R.id.key);
            this.updateRelevantMap(key, value);
        }
    }

    @Override
    protected JsonFormFragmentViewState createViewState() {
        return new JsonFormFragmentViewState();
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
        this.mMenu = menu2;
        menu2.clear();
        inflater.inflate(R.menu.menu_toolbar, menu2);
        ((JsonFormFragmentPresenter)this.presenter).setUpToolBar();
    }

    @Override
    public void setActionBarTitle(String title) {
        this.getSupportActionBar().setTitle((CharSequence)title);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            ((JsonFormFragmentPresenter)this.presenter).onBackClick();
            return true;
        }
        if (item.getItemId() == R.id.action_next) {
            ((JsonFormFragmentPresenter)this.presenter).onNextClick(this.mMainView);
            return true;
        }
        if (item.getItemId() == R.id.action_save) {
            ((JsonFormFragmentPresenter)this.presenter).onSaveClick(this.mMainView);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onClick(View v) {
        ((JsonFormFragmentPresenter)this.presenter).onClick(v);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        ((JsonFormFragmentPresenter)this.presenter).onActivityResult(requestCode, resultCode, data);
        super.onActivityResult(requestCode, resultCode, data);
    }

    public void onDetach() {
        this.mJsonApi = null;
        super.onDetach();
    }

    @Override
    public void updateRelevantImageView(Bitmap bitmap, String imagePath, String currentKey) {
        int childCount = this.mMainView.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ImageView imageView;
            String key;
            View view = this.mMainView.getChildAt(i);
            if (!(view instanceof ImageView) || !(key = (String)(imageView = (ImageView)view).getTag(R.id.key)).equals(currentKey)) continue;
            imageView.setImageBitmap(bitmap);
            imageView.setVisibility(0);
            imageView.setTag(R.id.imagePath, (Object)imagePath);
            imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        }
    }

    private MaterialEditText findMaterialiEditTextByTag(ViewGroup v, String searchKey) {
        MaterialEditText found = null;
        for (int i = 0; i < v.getChildCount(); ++i) {
            View child = v.getChildAt(i);
            if (child instanceof MaterialEditText) {
                MaterialEditText editText = (MaterialEditText)child;
                String key = (String)editText.getTag(R.id.key);
                if (!key.equals(searchKey)) continue;
                return editText;
            }
            if (child instanceof ViewGroup && (found = this.findMaterialiEditTextByTag((ViewGroup)child, searchKey)) != null) break;
        }
        return found;
    }

    @Override
    public void updateRelevantEditText(String currentKey, String value) {
        MaterialEditText editText = this.findMaterialiEditTextByTag((ViewGroup)this.mMainView, currentKey);
        if (editText != null) {
            editText.setText((CharSequence)value);
        }
    }

    @Override
    public void updateRelevantMap(String key, String value) {
        View view = this.getView();
        View inputView = this.findViewWithTagKeyValue(view, key);
        String customIcon = (String)inputView.getTag(R.id.custom_icon);
        View mapContainer = inputView.findViewWithTag((Object)R.id.map_container);
        MapsUtils.loadStaticMap(this, mapContainer.getId(), key, value, customIcon);
    }

    private View findViewWithTagKeyValue(View view, String key) {
        if (key.equals(view.getTag(R.id.key))) {
            return view;
        }
        if (view instanceof ViewGroup) {
            ViewGroup v = (ViewGroup)view;
            for (int i = 0; i < v.getChildCount(); ++i) {
                View child = v.getChildAt(i);
                View result = this.findViewWithTagKeyValue(child, key);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public void writeValue(String stepName, String key, String s) {
        try {
            this.mJsonApi.writeValue(stepName, key, s);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void writeValue(String stepName, String prentKey, String childObjectKey, String childKey, String value) {
        try {
            this.mJsonApi.writeValue(stepName, prentKey, childObjectKey, childKey, value);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public JSONObject getStep(String stepName) {
        return this.mJsonApi.getStep(stepName);
    }

    @Override
    public String getCurrentJsonState() {
        return this.mJsonApi.currentJsonState();
    }

    @Override
    protected JsonFormFragmentPresenter createPresenter() {
        JsonFormFragmentPresenter presenter = new JsonFormFragmentPresenter();
        presenter.setVisualizationMode(this.mJsonApi.getVisualizationMode());
        return presenter;
    }

    @Override
    public Context getContext() {
        return this.getActivity();
    }

    @Override
    public void showToast(String message) {
        Toast.makeText((Context)this.getActivity(), (CharSequence)message, (int)0).show();
    }

    @Override
    public CommonListener getCommonListener() {
        return this;
    }

    @Override
    public void addFormElements(List<View> views) {
        for (View view : views) {
            this.mMainView.addView(view);
        }
    }

    @Override
    public ActionBar getSupportActionBar() {
        return ((JsonFormActivity)this.getActivity()).getSupportActionBar();
    }

    @Override
    public Toolbar getToolbar() {
        return ((JsonFormActivity)this.getActivity()).getToolbar();
    }

    @Override
    public void setToolbarTitleColor(int colorId) {
        this.getToolbar().setTitleTextColor(this.getContext().getResources().getColor(colorId));
    }

    @Override
    public void updateVisibilityOfNextAndSave(boolean next, boolean save) {
        this.mMenu.findItem(R.id.action_next).setVisible(next);
        this.mMenu.findItem(R.id.action_save).setVisible(save);
    }

    @Override
    public void hideKeyBoard() {
        super.hideSoftKeyboard();
    }

    @Override
    public void backClick() {
        this.getActivity().onBackPressed();
    }

    @Override
    public void unCheckAllExcept(String parentKey, String childKey) {
        int childCount = this.mMainView.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view = this.mMainView.getChildAt(i);
            if (!(view instanceof RadioGroup)) continue;
            RadioGroup rg = (RadioGroup)view;
            for (int j = 0; j < rg.getChildCount(); ++j) {
                RadioButton child = (RadioButton)rg.getChildAt(j);
                String parentKeyAtIndex = (String)child.getTag(R.id.key);
                String childKeyAtIndex = (String)child.getTag(R.id.childKey);
                if (!parentKeyAtIndex.equals(parentKey) || childKeyAtIndex.equals(childKey)) continue;
                child.setChecked(false);
            }
        }
    }

    @Override
    public String getCount() {
        return this.mJsonApi.getCount();
    }

    @Override
    public void finishWithResult(Intent returnIntent) {
        this.getActivity().setResult(-1, returnIntent);
        this.getActivity().finish();
    }

    @Override
    public void setUpBackButton() {
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
    }

    @Override
    public void transactThis(JsonFormFragment next) {
        this.getActivity().getSupportFragmentManager().beginTransaction().setCustomAnimations(R.anim.enter_from_right, R.anim.exit_to_left, R.anim.enter_from_left, R.anim.exit_to_right).replace(R.id.container, (Fragment)next).addToBackStack(next.getClass().getSimpleName()).commit();
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        ((JsonFormFragmentPresenter)this.presenter).onCheckedChanged(buttonView, isChecked);
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
        ((JsonFormFragmentPresenter)this.presenter).onItemSelected(parent, view, position, id2);
    }

    public void onNothingSelected(AdapterView<?> parent) {
    }

    public void onCheckedChanged(Switch view, boolean checked) {
        ((JsonFormFragmentPresenter)this.presenter).onSwitchOnOrOff(view, checked);
    }

    public LinearLayout getMainView() {
        return this.mMainView;
    }

    @Override
    public void onInitialValueSet(String parentKey, String childKey, String value) {
    }

    @Override
    public void onValueChange(String parentKey, String childKey, String value) {
    }

    @Override
    public void onVisibilityChange(String key, String o, boolean b) {
    }

    @Override
    public JsonFormBundle getBundle(Locale locale) {
        return this.mJsonApi.getBundle(locale);
    }

    @Override
    public JsonExpressionResolver getExpressionResolver() {
        return this.mJsonApi.getExpressionResolver();
    }

    @Override
    public ResourceResolver getResourceResolver() {
        return this.mJsonApi.getResourceResolver();
    }

    public void onCurrentItemChanged(@Nullable CarouselAdapter.ViewHolder viewHolder, int adapterPosition) {
        ((JsonFormFragmentPresenter)this.presenter).onCurrentItemChanged(viewHolder, adapterPosition);
    }

    public void onScrollStart(@NonNull CarouselAdapter.ViewHolder currentItemHolder, int adapterPosition) {
    }

    public void onScrollEnd(@NonNull CarouselAdapter.ViewHolder currentItemHolder, int adapterPosition) {
    }

    public void onScroll(float scrollPosition, int currentPosition, int newPosition, @Nullable CarouselAdapter.ViewHolder currentHolder, @Nullable CarouselAdapter.ViewHolder newCurrent) {
    }

    public void onPause() {
        super.onPause();
        if (this.mJsonApi.getVisualizationMode() == 1) {
            ((JsonFormFragmentPresenter)this.presenter).writeValuesAndValidate(this.mMainView);
            PropertiesUtils.getInstance(this.getContext()).setPausedStep(((JsonFormFragmentPresenter)this.presenter).getStepName());
        }
    }
}

