/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.widgets;

import android.content.Context;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.rengwuxian.materialedittext.MaterialEditText;
import com.rengwuxian.materialedittext.validation.METValidator;
import com.rey.material.util.ViewUtil;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.customviews.GenericTextWatcher;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.FormWidgetFactory;
import com.vijay.jsonwizard.interfaces.JsonApi;
import com.vijay.jsonwizard.maps.MapsUtils;
import com.vijay.jsonwizard.utils.JsonFormUtils;
import com.vijay.jsonwizard.utils.ValidationStatus;
import com.vijay.jsonwizard.validators.edittext.RequiredValidator;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class LocationPickerFactory
implements FormWidgetFactory {
    private static final String TAG = "JsonFormActivity";

    public static ValidationStatus validate(MaterialEditText editText) {
        boolean validate = editText.validate();
        if (!validate) {
            return new ValidationStatus(false, editText.getError().toString());
        }
        return new ValidationStatus(true, null);
    }

    @Override
    public List<View> getViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) throws Exception {
        List<View> views;
        switch (visualizationMode) {
            case 2: {
                views = this.getReadOnlyViewsFromJson(context, jsonObject, bundle);
                break;
            }
            default: {
                views = this.getEditableViewsFromJson(stepName, context, jsonObject, listener, bundle, resolver);
            }
        }
        return views;
    }

    private List<View> getEditableViewsFromJson(String stepName, Context context, JSONObject jsonObject, final CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver) throws JSONException {
        String requiredValue;
        JSONObject requiredObject;
        String readonlyValue = jsonObject.optString("readonly");
        boolean readonly = false;
        if (resolver.isValidExpression(readonlyValue)) {
            JSONObject currentValues = this.getCurrentValues(context);
            readonly = resolver.existsExpression(readonlyValue, currentValues);
        } else {
            readonly = Boolean.TRUE.toString().equalsIgnoreCase(readonlyValue);
        }
        if (readonly) {
            return this.getReadOnlyViewsFromJson(context, jsonObject, bundle);
        }
        ArrayList<View> views = new ArrayList<View>(1);
        final View parentView = LayoutInflater.from((Context)context).inflate(R.layout.item_location_text, null);
        parentView.setTag(R.id.key, (Object)jsonObject.getString("key"));
        parentView.setTag(R.id.type, (Object)jsonObject.getString("type"));
        parentView.setTag(R.id.accuracy, (Object)(jsonObject.has("accuracy") && jsonObject.getBoolean("accuracy") ? 1 : 0));
        final MaterialEditText editText = (MaterialEditText)parentView.findViewById(R.id.edit_text);
        String hint = bundle.resolveKey(jsonObject.getString("hint"));
        editText.setRawInputType(12290);
        editText.setTag(R.id.key, (Object)jsonObject.getString("key"));
        editText.setTag(R.id.type, (Object)jsonObject.getString("type"));
        editText.setHint((CharSequence)hint);
        editText.setFloatingLabelText((CharSequence)hint);
        editText.setId(ViewUtil.generateViewId());
        ImageView imageView = (ImageView)parentView.findViewById(R.id.icon);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                parentView.setTag(R.id.value, (Object)editText.getText().toString());
                listener.onClick(parentView);
            }
        });
        String key = jsonObject.getString("key");
        imageView.setTag(R.id.key, (Object)jsonObject.getString("key"));
        imageView.setTag(R.id.type, (Object)jsonObject.getString("type"));
        String value = jsonObject.optString("value");
        if (!TextUtils.isEmpty((CharSequence)value)) {
            editText.setText((CharSequence)value);
            if (context instanceof FragmentActivity) {
                MapsUtils.loadStaticMap((FragmentActivity)context, key, value);
            } else {
                Log.w((String)TAG, (String)"Context is not a FragmentActivity");
            }
        }
        if ((requiredObject = jsonObject.optJSONObject("v_required")) != null && !TextUtils.isEmpty((CharSequence)(requiredValue = requiredObject.getString("value")))) {
            boolean required = false;
            if (resolver.isValidExpression(requiredValue)) {
                JSONObject currentValues = this.getCurrentValues(context);
                required = resolver.existsExpression(requiredValue, currentValues);
            } else {
                required = Boolean.TRUE.toString().equalsIgnoreCase(requiredValue);
            }
            if (required) {
                editText.addValidator((METValidator)new RequiredValidator(bundle.resolveKey(requiredObject.getString("err"))));
            }
        }
        editText.addTextChangedListener((TextWatcher)new GenericTextWatcher(stepName, (View)editText));
        views.add(parentView);
        return views;
    }

    private List<View> getReadOnlyViewsFromJson(Context context, JSONObject jsonObject, JsonFormBundle bundle) throws JSONException {
        ArrayList<View> views = new ArrayList<View>(1);
        View parentView = LayoutInflater.from((Context)context).inflate(R.layout.item_location_text, null);
        MaterialEditText editText = (MaterialEditText)parentView.findViewById(R.id.edit_text);
        editText.setId(ViewUtil.generateViewId());
        String hint = bundle.resolveKey(jsonObject.getString("hint"));
        editText.setHint((CharSequence)hint);
        editText.setFloatingLabelText((CharSequence)hint);
        editText.setTag(R.id.key, (Object)jsonObject.getString("key"));
        editText.setTag(R.id.type, (Object)jsonObject.getString("type"));
        String value = jsonObject.optString("value");
        editText.setText((CharSequence)value);
        editText.setEnabled(false);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            if (context instanceof FragmentActivity) {
                MapsUtils.loadStaticMap((FragmentActivity)context, jsonObject.getString("key"), jsonObject.getString("value"));
            } else {
                Log.w((String)TAG, (String)"Context is not a FragmentActivity");
                parentView.findViewById(R.id.map_container).setVisibility(8);
            }
        } else {
            parentView.findViewById(R.id.map_container).setVisibility(8);
        }
        ImageView imageView = (ImageView)parentView.findViewById(R.id.icon);
        imageView.setClickable(false);
        imageView.setEnabled(false);
        imageView.setVisibility(8);
        views.add(parentView);
        return views;
    }

    @Nullable
    private JSONObject getCurrentValues(Context context) throws JSONException {
        JSONObject currentValues = null;
        if (context instanceof JsonApi) {
            String currentJsonState = ((JsonApi)context).currentJsonState();
            JSONObject currentJsonObject = new JSONObject(currentJsonState);
            currentValues = JsonFormUtils.extractDataFromForm(currentJsonObject, false);
        }
        return currentValues;
    }
}

