/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.maps;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.app.ActivityCompat;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.SupportMapFragment;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.maps.MapsUtils;

public class MapsActivity
extends AppCompatActivity
implements OnMapReadyCallback {
    public static final String EXTRA_INITIAL_LOCATION = "INITIAL_LOCATION";
    public static final String EXTRA_USE_ACCURACY = "USE_ACCURACY";
    public static final String EXTRA_RESULT_LOCATION = "RESULT_LOCATION";
    private static final String TAG = "JsonFormActivity";
    private static final int REQUEST_CODE_LOCATION = 80;
    private GoogleMap mMap;
    private String mInitialPos;
    private String mMarkerPosition;
    private Marker mMarker;
    private boolean mIncludeAccuracy;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_maps);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.tb_top);
        this.setSupportActionBar(toolbar);
        this.getSupportActionBar().setTitle(R.string.choose_a_location);
        Intent intent = this.getIntent();
        this.mIncludeAccuracy = intent.getBooleanExtra(EXTRA_USE_ACCURACY, false);
        if (intent.hasExtra(EXTRA_INITIAL_LOCATION)) {
            try {
                this.mInitialPos = intent.getStringExtra(EXTRA_INITIAL_LOCATION);
            }
            catch (IllegalArgumentException e) {
                Log.w((String)TAG, (String)"Invalid initial position", (Throwable)e);
                this.attemptMarkCurrentLocation();
            }
        } else {
            this.attemptMarkCurrentLocation();
        }
        SupportMapFragment mapFragment = (SupportMapFragment)this.getSupportFragmentManager().findFragmentById(R.id.map);
        mapFragment.getMapAsync((OnMapReadyCallback)this);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater menuInflater = this.getMenuInflater();
        menuInflater.inflate(R.menu.menu_location_picker, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.action_choose) {
            Intent data = new Intent();
            data.putExtra(EXTRA_RESULT_LOCATION, this.mMarkerPosition);
            this.setResult(-1, data);
            this.finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 80) {
            boolean grantedAny = false;
            for (int grantResult : grantResults) {
                if (grantResult != 0) continue;
                grantedAny = true;
                break;
            }
            if (grantedAny) {
                this.attemptMarkCurrentLocation();
            } else {
                Log.w((String)TAG, (String)"Current location permission not granted");
                String position = this.getPositionWithOptionalAccuracy(new LatLng(0.0, 0.0), 0.0f);
                this.updateMapMarker(position, true);
            }
        }
    }

    public void onMapReady(GoogleMap googleMap) {
        this.mMap = googleMap;
        this.mMap.setMinZoomPreference(8.0f);
        this.mMap.setMaxZoomPreference(18.0f);
        if (this.mInitialPos != null) {
            this.updateMapMarker(this.mInitialPos, true);
        }
        this.mMap.setOnCameraMoveListener(new GoogleMap.OnCameraMoveListener(){

            public void onCameraMove() {
                MapsActivity.this.mMarkerPosition = MapsActivity.this.getPositionWithOptionalAccuracy(((MapsActivity)MapsActivity.this).mMap.getCameraPosition().target, -1.0f);
                MapsActivity.this.updateMapMarker(MapsActivity.this.mMarkerPosition, false);
            }
        });
    }

    private void attemptMarkCurrentLocation() {
        if (!this.checkPermission("android.permission.ACCESS_FINE_LOCATION") && !this.checkPermission("android.permission.ACCESS_COARSE_LOCATION")) {
            if (Build.VERSION.SDK_INT >= 23) {
                this.requestPermissions(new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"}, 80);
            } else {
                String position = this.getPositionWithOptionalAccuracy(new LatLng(0.0, 0.0), 0.0f);
                this.updateMapMarker(position, true);
            }
        } else {
            FusedLocationProviderClient fusedLocationClient = LocationServices.getFusedLocationProviderClient((Activity)this);
            fusedLocationClient.getLastLocation().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Location>(){

                public void onComplete(@NonNull Task<Location> task) {
                    if (task.getResult() != null) {
                        double lat = ((Location)task.getResult()).getLatitude();
                        double lng = ((Location)task.getResult()).getLongitude();
                        LatLng latLng = new LatLng(lat, lng);
                        float accuracy = ((Location)task.getResult()).getAccuracy();
                        MapsActivity.this.mInitialPos = MapsActivity.this.getPositionWithOptionalAccuracy(latLng, accuracy);
                        MapsActivity.this.updateMapMarker(MapsActivity.this.mInitialPos, true);
                    } else {
                        Log.w((String)MapsActivity.TAG, (String)"Could not obtain last location", (Throwable)task.getException());
                        String position = MapsActivity.this.getPositionWithOptionalAccuracy(new LatLng(0.0, 0.0), 0.0f);
                        MapsActivity.this.updateMapMarker(position, true);
                    }
                }
            });
        }
    }

    private boolean checkPermission(String permission2) {
        return ActivityCompat.checkSelfPermission((Context)this, (String)permission2) == 0;
    }

    private void updateMapMarker(String markerPosition, boolean repositionCamera) {
        if (this.mMap != null) {
            LatLng latLng = MapsUtils.parse(markerPosition);
            if (this.mMarker == null) {
                this.mMap.clear();
                this.mMarker = this.mMap.addMarker(new MarkerOptions().position(latLng));
            } else {
                this.mMarker.setPosition(latLng);
            }
            if (repositionCamera) {
                CameraPosition pos = CameraPosition.builder().target(latLng).zoom(18.0f).build();
                this.mMap.moveCamera(CameraUpdateFactory.newCameraPosition((CameraPosition)pos));
            }
            this.mMarkerPosition = markerPosition;
        }
    }

    private String getPositionWithOptionalAccuracy(LatLng latLng, float accuracy) {
        if (this.mIncludeAccuracy) {
            return MapsUtils.toString(latLng, accuracy);
        }
        return MapsUtils.toString(latLng);
    }
}

