/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.presenters;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.util.Log;
import android.view.View;
import android.view.ViewParent;
import android.widget.AdapterView;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import com.rengwuxian.materialedittext.MaterialEditText;
import com.rey.material.widget.Switch;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.barcode.LivePreviewActivity;
import com.vijay.jsonwizard.customviews.CheckBox;
import com.vijay.jsonwizard.customviews.RadioButton;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.fragments.JsonFormFragment;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interactors.JsonFormInteractor;
import com.vijay.jsonwizard.mvp.MvpBasePresenter;
import com.vijay.jsonwizard.utils.CarouselAdapter;
import com.vijay.jsonwizard.utils.DateUtils;
import com.vijay.jsonwizard.utils.ImagePicker;
import com.vijay.jsonwizard.utils.ImageUtils;
import com.vijay.jsonwizard.utils.JsonFormUtils;
import com.vijay.jsonwizard.utils.ValidationStatus;
import com.vijay.jsonwizard.views.JsonFormFragmentView;
import com.vijay.jsonwizard.viewstates.JsonFormFragmentViewState;
import com.vijay.jsonwizard.widgets.BarcodeTextFactory;
import com.vijay.jsonwizard.widgets.CarouselFactory;
import com.vijay.jsonwizard.widgets.DatePickerFactory;
import com.vijay.jsonwizard.widgets.EditTextFactory;
import com.vijay.jsonwizard.widgets.ImagePickerFactory;
import com.vijay.jsonwizard.widgets.SpinnerFactory;
import com.yarolegovich.discretescrollview.DiscreteScrollView;
import fr.ganfra.materialspinner.MaterialSpinner;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonFormFragmentPresenter
extends MvpBasePresenter<JsonFormFragmentView<JsonFormFragmentViewState>> {
    private static final String TAG = "FormFragmentPresenter";
    private static final int RESULT_LOAD_IMG = 1;
    private static final int RESULT_LOAD_BARCODE = 2;
    private static final String PARAM_BARCODE = "barcode";
    private static final String PARAM_ERROR = "error";
    private String mStepName;
    private JSONObject mStepDetails;
    private String mCurrentKey;
    private int mVisualizationMode;
    private JsonFormInteractor mJsonFormInteractor = JsonFormInteractor.getInstance();

    public void addFormElements() {
        switch (this.mVisualizationMode) {
            case 2: {
                this.addFormReadOnlylements();
                break;
            }
            default: {
                this.addFormEditionElements();
            }
        }
    }

    private void addFormEditionElements() {
        this.mStepName = ((JsonFormFragmentView)this.getView()).getArguments().getString("stepName");
        JSONObject step = ((JsonFormFragmentView)this.getView()).getStep(this.mStepName);
        JsonFormBundle bundle = ((JsonFormFragmentView)this.getView()).getBundle(((JsonFormFragmentView)this.getView()).getContext().getResources().getConfiguration().locale);
        JsonExpressionResolver resolver = ((JsonFormFragmentView)this.getView()).getExpressionResolver();
        ResourceResolver resourceResolver = ((JsonFormFragmentView)this.getView()).getResourceResolver();
        try {
            this.mStepDetails = new JSONObject(step.toString());
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
        List<View> views = this.getStepFormElements(this.mStepName, this.mStepDetails, bundle, resolver, resourceResolver);
        ((JsonFormFragmentView)this.getView()).addFormElements(views);
    }

    private void addFormReadOnlylements() {
        String stepName = ((JsonFormFragmentView)this.getView()).getArguments().getString("stepName");
        JSONObject step = ((JsonFormFragmentView)this.getView()).getStep(stepName);
        JsonFormBundle bundle = ((JsonFormFragmentView)this.getView()).getBundle(((JsonFormFragmentView)this.getView()).getContext().getResources().getConfiguration().locale);
        JsonExpressionResolver resolver = ((JsonFormFragmentView)this.getView()).getExpressionResolver();
        ResourceResolver resourceResolver = ((JsonFormFragmentView)this.getView()).getResourceResolver();
        List<View> views = this.getStepFormElements(stepName, step, bundle, resolver, resourceResolver);
        while (step.has("next")) {
            try {
                stepName = step.getString("next");
                step = ((JsonFormFragmentView)this.getView()).getStep(stepName);
                views.addAll(this.getStepFormElements(stepName, step, bundle, resolver, resourceResolver));
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
        }
        ((JsonFormFragmentView)this.getView()).addFormElements(views);
    }

    private List<View> getStepFormElements(String stepName, JSONObject stepDetails, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver) {
        List<View> views = this.mJsonFormInteractor.fetchFormElements(stepName, ((JsonFormFragmentView)this.getView()).getContext(), stepDetails, ((JsonFormFragmentView)this.getView()).getCommonListener(), bundle, resolver, resourceResolver, this.mVisualizationMode);
        return views;
    }

    @SuppressLint(value={"ResourceAsColor"})
    public void setUpToolBar() {
        if (this.mVisualizationMode == 1) {
            if (!this.mStepName.equals("step1")) {
                ((JsonFormFragmentView)this.getView()).setUpBackButton();
            }
            JsonFormBundle bundle = ((JsonFormFragmentView)this.getView()).getBundle(((JsonFormFragmentView)this.getView()).getContext().getResources().getConfiguration().locale);
            ((JsonFormFragmentView)this.getView()).setActionBarTitle(bundle.resolveKey(this.mStepDetails.optString("title")));
            if (this.mStepDetails.has("next")) {
                ((JsonFormFragmentView)this.getView()).updateVisibilityOfNextAndSave(true, false);
            } else {
                ((JsonFormFragmentView)this.getView()).updateVisibilityOfNextAndSave(false, true);
            }
        } else {
            ((JsonFormFragmentView)this.getView()).setActionBarTitle(((JsonFormFragmentView)this.getView()).getContext().getResources().getString(R.string.summary));
            ((JsonFormFragmentView)this.getView()).updateVisibilityOfNextAndSave(false, false);
        }
        this.setUpToolBarTitleColor();
    }

    public void setUpToolBarTitleColor() {
        ((JsonFormFragmentView)this.getView()).setToolbarTitleColor(R.color.white);
    }

    public void onBackClick() {
        ((JsonFormFragmentView)this.getView()).hideKeyBoard();
        ((JsonFormFragmentView)this.getView()).backClick();
    }

    public void onNextClick(LinearLayout mainView) {
        try {
            ValidationStatus validationStatus = this.writeValuesAndValidate(mainView);
            if (validationStatus.isValid()) {
                String nextStep = JsonFormUtils.resolveNextStep(this.mStepDetails, ((JsonFormFragmentView)this.getView()).getExpressionResolver(), new JSONObject(((JsonFormFragmentView)this.getView()).getCurrentJsonState()));
                if ("end".equals(nextStep)) {
                    this.onSaveClick(mainView);
                } else {
                    JsonFormFragment next = JsonFormFragment.getFormFragment(nextStep);
                    ((JsonFormFragmentView)this.getView()).hideKeyBoard();
                    ((JsonFormFragmentView)this.getView()).transactThis(next);
                }
            } else {
                ((JsonFormFragmentView)this.getView()).showToast(validationStatus.getErrorMessage());
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"onNextClick: Error evaluating next step", (Throwable)e);
        }
    }

    public ValidationStatus writeValuesAndValidate(LinearLayout mainView) {
        String type = (String)mainView.getTag(R.id.type);
        int childCount = mainView.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            String childKey;
            String parentKey;
            ValidationStatus validationStatus;
            ValidationStatus validationStatus2;
            View childAt = mainView.getChildAt(i);
            String key = (String)childAt.getTag(R.id.key);
            if (childAt instanceof MaterialEditText) {
                String childKey2;
                String parentKey2;
                MaterialEditText editText = (MaterialEditText)childAt;
                if (editText.getTag(R.id.type).equals("edit_text")) {
                    validationStatus2 = EditTextFactory.validate(editText);
                    if (!validationStatus2.isValid()) {
                        return validationStatus2;
                    }
                    if ("edit_group".equals(type)) {
                        parentKey2 = (String)mainView.getTag(R.id.key);
                        childKey2 = (String)childAt.getTag(R.id.key);
                        ((JsonFormFragmentView)this.getView()).writeValue(this.mStepName, parentKey2, "fields", childKey2, editText.getText().toString());
                        continue;
                    }
                    ((JsonFormFragmentView)this.getView()).writeValue(this.mStepName, key, editText.getText().toString());
                    continue;
                }
                if (editText.getTag(R.id.type).equals("date_picker")) {
                    validationStatus2 = DatePickerFactory.validate(editText);
                    if (!validationStatus2.isValid()) {
                        return validationStatus2;
                    }
                    Date date = DateUtils.parseDate(editText.getText().toString(), (String)editText.getTag(R.id.v_pattern));
                    if ("edit_group".equals(type)) {
                        String parentKey3 = (String)childAt.getTag(R.id.key);
                        String childKey3 = (String)childAt.getTag(R.id.childKey);
                        ((JsonFormFragmentView)this.getView()).writeValue(this.mStepName, parentKey3, "fields", childKey3, DateUtils.toJSONDateFormat(date));
                        continue;
                    }
                    ((JsonFormFragmentView)this.getView()).writeValue(this.mStepName, key, DateUtils.toJSONDateFormat(date));
                    continue;
                }
                if (editText.getTag(R.id.type).equals("barcode_text")) {
                    validationStatus2 = BarcodeTextFactory.validate(editText);
                    if (!validationStatus2.isValid()) {
                        return validationStatus2;
                    }
                    if ("edit_group".equals(type)) {
                        parentKey2 = (String)mainView.getTag(R.id.key);
                        childKey2 = (String)childAt.getTag(R.id.key);
                        ((JsonFormFragmentView)this.getView()).writeValue(this.mStepName, parentKey2, "fields", childKey2, editText.getText().toString());
                        continue;
                    }
                    ((JsonFormFragmentView)this.getView()).writeValue(this.mStepName, key, editText.getText().toString());
                    continue;
                }
                if (!editText.getTag(R.id.type).equals("time_picker")) continue;
                validationStatus2 = BarcodeTextFactory.validate(editText);
                if (!validationStatus2.isValid()) {
                    return validationStatus2;
                }
                if ("edit_group".equals(type)) {
                    parentKey2 = (String)mainView.getTag(R.id.key);
                    childKey2 = (String)childAt.getTag(R.id.key);
                    ((JsonFormFragmentView)this.getView()).writeValue(this.mStepName, parentKey2, "fields", childKey2, editText.getText().toString());
                    continue;
                }
                ((JsonFormFragmentView)this.getView()).writeValue(this.mStepName, key, editText.getText().toString());
                continue;
            }
            if (childAt instanceof ImageView) {
                validationStatus = ImagePickerFactory.validate((ImageView)childAt);
                if (!validationStatus.isValid()) {
                    return validationStatus;
                }
                Object path = childAt.getTag(R.id.imagePath);
                if (!(path instanceof String)) continue;
                ((JsonFormFragmentView)this.getView()).writeValue(this.mStepName, key, (String)path);
                continue;
            }
            if (childAt instanceof CheckBox) {
                parentKey = (String)childAt.getTag(R.id.key);
                childKey = (String)childAt.getTag(R.id.childKey);
                ((JsonFormFragmentView)this.getView()).writeValue(this.mStepName, parentKey, "options", childKey, String.valueOf(((CheckBox)childAt).isChecked()));
                continue;
            }
            if (childAt instanceof RadioButton) {
                parentKey = (String)childAt.getTag(R.id.key);
                childKey = (String)childAt.getTag(R.id.childKey);
                if (!((RadioButton)childAt).isChecked()) continue;
                ((JsonFormFragmentView)this.getView()).writeValue(this.mStepName, parentKey, childKey);
                continue;
            }
            if (childAt instanceof MaterialSpinner) {
                MaterialSpinner spinner = (MaterialSpinner)childAt;
                validationStatus2 = SpinnerFactory.validate(spinner);
                if (!validationStatus2.isValid()) {
                    spinner.setError((CharSequence)validationStatus2.getErrorMessage());
                    return validationStatus2;
                }
                spinner.setError(null);
                continue;
            }
            if (childAt instanceof DiscreteScrollView) {
                DiscreteScrollView dsv = (DiscreteScrollView)childAt;
                validationStatus2 = CarouselFactory.validate(dsv);
                if (validationStatus2.isValid()) continue;
                return validationStatus2;
            }
            if (!(childAt instanceof LinearLayout) || (validationStatus = this.writeValuesAndValidate((LinearLayout)childAt)).isValid()) continue;
            return validationStatus;
        }
        return new ValidationStatus(true, null);
    }

    public void onSaveClick(LinearLayout mainView) {
        ValidationStatus validationStatus = this.writeValuesAndValidate(mainView);
        if (validationStatus.isValid()) {
            Intent returnIntent = new Intent();
            returnIntent.putExtra("json", ((JsonFormFragmentView)this.getView()).getCurrentJsonState());
            ((JsonFormFragmentView)this.getView()).finishWithResult(returnIntent);
        } else {
            Toast.makeText((Context)((JsonFormFragmentView)this.getView()).getContext(), (CharSequence)validationStatus.getErrorMessage(), (int)1).show();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        Context context;
        Bitmap bitmap;
        if (requestCode == 1 && (bitmap = ImagePicker.getImageFromResult(context = ((JsonFormFragmentView)this.getView()).getContext(), resultCode, data)) != null) {
            File image = new File(context.getExternalCacheDir(), System.currentTimeMillis() + ".jpg");
            ImageUtils.saveToFile(bitmap, image);
            ((JsonFormFragmentView)this.getView()).updateRelevantImageView(bitmap, image.getAbsolutePath(), this.mCurrentKey);
        }
        if (requestCode == 2) {
            if (data != null && data.hasExtra(PARAM_BARCODE)) {
                String value = data.getStringExtra(PARAM_BARCODE);
                this.mStepName = ((JsonFormFragmentView)this.getView()).getArguments().getString("stepName");
                ((JsonFormFragmentView)this.getView()).writeValue(this.mStepName, this.mCurrentKey, value);
                ((JsonFormFragmentView)this.getView()).updateRelevantEditText(this.mCurrentKey, value);
            }
            if (data != null && data.hasExtra(PARAM_ERROR)) {
                Toast.makeText((Context)((JsonFormFragmentView)this.getView()).getContext(), (int)R.string.mlkit_not_found, (int)1).show();
            }
        }
    }

    public void onClick(View v) {
        if (this.checkFormPermissions()) {
            String key = (String)v.getTag(R.id.key);
            String type = (String)v.getTag(R.id.type);
            if ("choose_image".equals(type)) {
                ((JsonFormFragmentView)this.getView()).hideKeyBoard();
                Intent pickerIntent = ImagePicker.getPickImageIntent(v.getContext());
                this.mCurrentKey = key;
                ((JsonFormFragmentView)this.getView()).startActivityForResult(pickerIntent, 1);
            }
            if ("barcode_text".equals(type)) {
                Log.d((String)TAG, (String)"onClick: barcode");
                ((JsonFormFragmentView)this.getView()).hideKeyBoard();
                Intent barcodeIntent = new Intent(v.getContext(), LivePreviewActivity.class);
                this.mCurrentKey = key;
                ((JsonFormFragmentView)this.getView()).startActivityForResult(barcodeIntent, 2);
            }
        }
    }

    public void onCheckedChanged(CompoundButton compoundButton, boolean isChecked) {
        if (compoundButton instanceof CheckBox) {
            String parentKey = (String)compoundButton.getTag(R.id.key);
            String childKey = (String)compoundButton.getTag(R.id.childKey);
            ((JsonFormFragmentView)this.getView()).writeValue(this.mStepName, parentKey, "options", childKey, String.valueOf(((CheckBox)compoundButton).isChecked()));
        } else if (compoundButton instanceof RadioButton && isChecked) {
            String parentKey = (String)compoundButton.getTag(R.id.key);
            String childKey = (String)compoundButton.getTag(R.id.childKey);
            ((JsonFormFragmentView)this.getView()).unCheckAllExcept(parentKey, childKey);
            ((JsonFormFragmentView)this.getView()).writeValue(this.mStepName, parentKey, childKey);
        }
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
        String parentKey = (String)parent.getTag(R.id.key);
        if (position >= 0) {
            String value = (String)parent.getItemAtPosition(position + 1);
            ((JsonFormFragmentView)this.getView()).writeValue(this.mStepName, parentKey, value);
        }
    }

    public void onCurrentItemChanged(@Nullable CarouselAdapter.ViewHolder holder, int position) {
        ViewParent parent;
        if (holder != null && (parent = holder.itemView.getParent()) != null && parent instanceof DiscreteScrollView) {
            DiscreteScrollView dsvParent = (DiscreteScrollView)parent;
            String parentKey = (String)dsvParent.getTag(R.id.key);
            View view = holder.itemView.findViewById(R.id.value);
            if (view != null && view instanceof TextView) {
                TextView textView = (TextView)view;
                String value = textView.getText().toString();
                JsonFormFragmentView jffview = (JsonFormFragmentView)this.getView();
                if (jffview != null) {
                    jffview.writeValue(this.mStepName, parentKey, value);
                }
            }
        }
    }

    public void onSwitchOnOrOff(Switch v, boolean checked) {
        String key = (String)v.getTag(R.id.key);
        ((JsonFormFragmentView)this.getView()).writeValue(this.mStepName, key, String.valueOf(checked));
    }

    public String getCurrentKey() {
        return this.mCurrentKey;
    }

    public void setCurrentKey(String key) {
        this.mCurrentKey = key;
    }

    public String getStepName() {
        return this.mStepName;
    }

    public void setVisualizationMode(int visualizationMode) {
        this.mVisualizationMode = visualizationMode;
    }

    private boolean checkFormPermissions() {
        int PERMISSION_ALL = 1;
        String[] PERMISSIONS = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA"};
        if (this.hasPermissions(((JsonFormFragmentView)this.getView()).getContext(), PERMISSIONS)) {
            return true;
        }
        JsonFormFragment formFragment = (JsonFormFragment)this.getView();
        ActivityCompat.requestPermissions((Activity)formFragment.getActivity(), (String[])PERMISSIONS, (int)PERMISSION_ALL);
        return false;
    }

    private boolean hasPermissions(Context context, String ... permissions) {
        if (context != null && permissions != null) {
            for (String permission2 : permissions) {
                if (ActivityCompat.checkSelfPermission((Context)context, (String)permission2) == 0) continue;
                return false;
            }
        }
        return true;
    }
}

