/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.widgets;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import androidx.annotation.Nullable;
import com.rengwuxian.materialedittext.MaterialEditText;
import com.rengwuxian.materialedittext.validation.METValidator;
import com.rey.material.app.Dialog;
import com.rey.material.app.TimePickerDialog;
import com.rey.material.util.ViewUtil;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.FormWidgetFactory;
import com.vijay.jsonwizard.interfaces.JsonApi;
import com.vijay.jsonwizard.utils.DateUtils;
import com.vijay.jsonwizard.utils.JsonFormUtils;
import com.vijay.jsonwizard.utils.ValidationStatus;
import com.vijay.jsonwizard.validators.edittext.RequiredValidator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class TimePickerFactory
implements FormWidgetFactory {
    private static final String TAG = "TimePickerFactory";

    public static ValidationStatus validate(MaterialEditText editText) {
        boolean validate = editText.validate();
        if (!validate) {
            return new ValidationStatus(false, editText.getError().toString());
        }
        return new ValidationStatus(true, null);
    }

    @Override
    public List<View> getViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) throws JSONException {
        List<View> views = null;
        switch (visualizationMode) {
            case 2: {
                views = this.getReadOnlyViewsFromJson(context, jsonObject, bundle);
                break;
            }
            default: {
                views = this.getEditableViewsFromJson(context, jsonObject, bundle, resolver);
            }
        }
        return views;
    }

    private List<View> getEditableViewsFromJson(Context context, JSONObject jsonObject, JsonFormBundle bundle, JsonExpressionResolver resolver) throws JSONException {
        String requiredValue;
        JSONObject requiredObject;
        ArrayList<View> views = new ArrayList<View>(1);
        MaterialEditText editText = (MaterialEditText)LayoutInflater.from((Context)context).inflate(R.layout.item_edit_text, null);
        String hint = bundle.resolveKey(jsonObject.getString("hint"));
        editText.setHint((CharSequence)hint);
        editText.setFloatingLabelText((CharSequence)hint);
        editText.setId(ViewUtil.generateViewId());
        editText.setTag(R.id.key, (Object)jsonObject.getString("key"));
        editText.setTag(R.id.type, (Object)jsonObject.getString("type"));
        String widgetPattern = bundle.resolveKey(jsonObject.getString("pattern"));
        editText.setTag(R.id.v_pattern, (Object)bundle.resolveKey(jsonObject.getString("pattern")));
        String value = jsonObject.optString("value");
        if (!TextUtils.isEmpty((CharSequence)value)) {
            try {
                Date date = DateUtils.parseJSONDate(value);
                SimpleDateFormat dateFormatter = new SimpleDateFormat(widgetPattern);
                editText.setText((CharSequence)dateFormatter.format(date));
            }
            catch (IllegalArgumentException e) {
                Log.e((String)TAG, (String)("Error parsing " + value + ": " + e.getMessage()));
            }
        }
        if ((requiredObject = jsonObject.optJSONObject("v_required")) != null && !TextUtils.isEmpty((CharSequence)(requiredValue = requiredObject.getString("value")))) {
            boolean required = false;
            if (resolver.isValidExpression(requiredValue)) {
                JSONObject currentValues = this.getCurrentValues(context);
                required = resolver.existsExpression(requiredValue, currentValues);
            } else {
                required = Boolean.TRUE.toString().equalsIgnoreCase(requiredValue);
            }
            if (required) {
                editText.addValidator((METValidator)new RequiredValidator(bundle.resolveKey(requiredObject.getString("err"))));
            }
        }
        TimePickerListener timePickerListener = new TimePickerListener(editText);
        editText.setOnFocusChangeListener((View.OnFocusChangeListener)timePickerListener);
        editText.setOnClickListener((View.OnClickListener)timePickerListener);
        editText.setInputType(0);
        views.add((View)editText);
        return views;
    }

    private List<View> getReadOnlyViewsFromJson(Context context, JSONObject jsonObject, JsonFormBundle bundle) throws JSONException {
        ArrayList<View> views = new ArrayList<View>(1);
        MaterialEditText editText = (MaterialEditText)LayoutInflater.from((Context)context).inflate(R.layout.item_edit_text, null);
        String hint = bundle.resolveKey(jsonObject.getString("hint"));
        editText.setHint((CharSequence)hint);
        editText.setFloatingLabelText((CharSequence)hint);
        editText.setId(ViewUtil.generateViewId());
        editText.setTag(R.id.key, (Object)jsonObject.getString("key"));
        editText.setTag(R.id.type, (Object)jsonObject.getString("type"));
        String widgetPattern = bundle.resolveKey(jsonObject.getString("pattern"));
        editText.setTag(R.id.v_pattern, (Object)widgetPattern);
        String value = jsonObject.optString("value");
        if (!TextUtils.isEmpty((CharSequence)value)) {
            try {
                Date date = DateUtils.parseJSONDate(value);
                SimpleDateFormat widgetDateFormat = new SimpleDateFormat(widgetPattern);
                editText.setText((CharSequence)widgetDateFormat.format(date));
            }
            catch (IllegalArgumentException e) {
                Log.e((String)TAG, (String)("Error parsing " + value + ": " + e.getMessage()));
            }
        }
        editText.setEnabled(false);
        views.add((View)editText);
        return views;
    }

    @Nullable
    private JSONObject getCurrentValues(Context context) throws JSONException {
        JSONObject currentValues = null;
        if (context instanceof JsonApi) {
            String currentJsonState = ((JsonApi)context).currentJsonState();
            JSONObject currentJsonObject = new JSONObject(currentJsonState);
            currentValues = JsonFormUtils.extractDataFromForm(currentJsonObject, false);
        }
        return currentValues;
    }

    private class TimePickerListener
    implements View.OnFocusChangeListener,
    View.OnClickListener {
        private Dialog d;
        private MaterialEditText timeText;

        public TimePickerListener(MaterialEditText editText) {
            this.timeText = editText;
        }

        public void onFocusChange(View view, boolean focus) {
            if (focus) {
                this.openTimePicker(view);
            }
        }

        public void onClick(View view) {
            this.openTimePicker(view);
        }

        private void openTimePicker(View view) {
            int hour = 0;
            int minute = 0;
            String timeStr = this.timeText.getText().toString();
            String pattern = (String)this.timeText.getTag(R.id.v_pattern);
            if (timeStr != null && !"".equals(timeStr)) {
                try {
                    SimpleDateFormat dateFormatter = new SimpleDateFormat(pattern);
                    Calendar c = Calendar.getInstance();
                    c.setTime(dateFormatter.parse(timeStr));
                    hour = c.get(11);
                    minute = c.get(12);
                }
                catch (ParseException e) {
                    Log.e((String)TimePickerFactory.TAG, (String)("Error parsing " + timeStr + ": " + e.getMessage()));
                }
            } else {
                Calendar c = Calendar.getInstance();
                hour = c.get(11);
                minute = c.get(12);
            }
            TimePickerDialog.Builder builder = new TimePickerDialog.Builder(hour, minute);
            this.d = builder.build(view.getContext());
            this.d.positiveActionClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    int selectedHour = ((TimePickerDialog)TimePickerListener.this.d).getHour();
                    int selectedMinute = ((TimePickerDialog)TimePickerListener.this.d).getMinute();
                    TimePickerListener.this.timeText.setText((CharSequence)String.format("%02d:%02d", selectedHour, selectedMinute));
                    TimePickerListener.this.d.hide();
                }
            });
            this.d.negativeActionClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    TimePickerListener.this.d.hide();
                }
            });
            this.d.positiveAction((CharSequence)"OK").negativeAction((CharSequence)"CANCEL");
            this.d.show();
        }
    }
}

