/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.barcode.common;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import com.vijay.jsonwizard.barcode.barcodescanning.BarcodeGraphic;
import java.util.ArrayList;
import java.util.List;

public class GraphicOverlay
extends View {
    private final Object lock = new Object();
    private final List<Graphic> graphics = new ArrayList<Graphic>();
    private int previewWidth;
    private float widthScaleFactor = 1.0f;
    private int previewHeight;
    private float heightScaleFactor = 1.0f;
    private int facing = 0;

    public GraphicOverlay(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.graphics.clear();
        }
        this.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Graphic graphic) {
        Object object = this.lock;
        synchronized (object) {
            this.graphics.add(graphic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Graphic graphic) {
        Object object = this.lock;
        synchronized (object) {
            this.graphics.remove(graphic);
        }
        this.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCameraInfo(int previewWidth, int previewHeight, int facing) {
        Object object = this.lock;
        synchronized (object) {
            this.previewWidth = previewWidth;
            this.previewHeight = previewHeight;
            this.facing = facing;
        }
        this.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Object object = this.lock;
        synchronized (object) {
            if (this.previewWidth != 0 && this.previewHeight != 0) {
                this.widthScaleFactor = (float)canvas.getWidth() / (float)this.previewWidth;
                this.heightScaleFactor = (float)canvas.getHeight() / (float)this.previewHeight;
            }
            for (Graphic graphic : this.graphics) {
                graphic.draw(canvas);
            }
        }
    }

    public List<Graphic> getGraphics() {
        return this.graphics;
    }

    public void highlight(BarcodeGraphic graphic) {
        for (Graphic graph : this.graphics) {
            if (!(graph instanceof BarcodeGraphic)) continue;
            BarcodeGraphic bcgraph = (BarcodeGraphic)graph;
            if (bcgraph == graphic) {
                bcgraph.highlight();
                continue;
            }
            bcgraph.removeHighlight();
        }
    }

    public static abstract class Graphic {
        private GraphicOverlay overlay;

        public Graphic(GraphicOverlay overlay) {
            this.overlay = overlay;
        }

        public abstract void draw(Canvas var1);

        public float scaleX(float horizontal) {
            return horizontal * this.overlay.widthScaleFactor;
        }

        public float scaleY(float vertical) {
            return vertical * this.overlay.heightScaleFactor;
        }

        public Context getApplicationContext() {
            return this.overlay.getContext().getApplicationContext();
        }

        public float translateX(float x) {
            if (this.overlay.facing == 1) {
                return (float)this.overlay.getWidth() - this.scaleX(x);
            }
            return this.scaleX(x);
        }

        public float translateY(float y) {
            return this.scaleY(y);
        }

        public void postInvalidate() {
            this.overlay.postInvalidate();
        }
    }
}

