/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.mvp;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.vijay.jsonwizard.mvp.BaseFragment;
import com.vijay.jsonwizard.mvp.MvpPresenter;
import com.vijay.jsonwizard.mvp.MvpView;
import com.vijay.jsonwizard.mvp.ViewState;

public abstract class MvpFragment<P extends MvpPresenter, VS extends ViewState>
extends BaseFragment<VS>
implements MvpView {
    protected P presenter;

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.presenter == null) {
            this.presenter = this.createPresenter();
        }
        this.presenter.attachView((MvpFragment)this);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        this.presenter.detachView(this.getRetainInstance());
    }

    protected abstract P createPresenter();

    public void hideSoftKeyboard() {
        View view = this.getActivity().getCurrentFocus();
        if (view != null) {
            InputMethodManager inputManager = (InputMethodManager)this.getActivity().getSystemService("input_method");
            inputManager.hideSoftInputFromWindow(view.getWindowToken(), 2);
        }
    }
}

