/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.utils;

import android.content.Context;
import android.graphics.BitmapFactory;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.utils.CarouselItem;
import java.io.File;
import java.util.List;

public class CarouselAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<CarouselItem> data;
    private RecyclerView parentRecycler;

    public CarouselAdapter(List<CarouselItem> data) {
        this.data = data;
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.parentRecycler = recyclerView;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        View v = inflater.inflate(R.layout.item_carousel_element, parent, false);
        v.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                boolean exists;
                int position = CarouselAdapter.this.parentRecycler.getChildLayoutPosition(v);
                String imagePath = ((CarouselItem)CarouselAdapter.this.data.get(position)).getImage();
                boolean bl = exists = !TextUtils.isEmpty((CharSequence)imagePath) && new File(imagePath).exists();
                if (exists) {
                    LayoutInflater factory = LayoutInflater.from((Context)v.getContext());
                    View popupView = factory.inflate(R.layout.item_carousel_popup, null);
                    ImageView imageView = (ImageView)popupView.findViewById(R.id.image);
                    imageView.setImageBitmap(BitmapFactory.decodeFile((String)imagePath));
                    AlertDialog.Builder builder = new AlertDialog.Builder(v.getContext(), 16974122);
                    builder.setView(popupView);
                    builder.create().show();
                }
            }
        });
        return new ViewHolder(v);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        String imagePath = this.data.get(position).getImage();
        int imageResourceId = this.isInteger(imagePath);
        if (!TextUtils.isEmpty((CharSequence)imagePath)) {
            if (imageResourceId > 0) {
                Glide.with((Context)holder.itemView.getContext()).load(Integer.valueOf(imageResourceId)).into(holder.image);
            } else {
                Glide.with((Context)holder.itemView.getContext()).load(new File(imagePath)).into(holder.image);
            }
        } else {
            Glide.with((Context)holder.itemView.getContext()).load(Integer.valueOf(R.mipmap.error_icon)).into(holder.image);
        }
        holder.name.setText((CharSequence)this.data.get(position).getName());
        holder.value.setText((CharSequence)this.data.get(position).getValue());
    }

    public int getItemCount() {
        return this.data.size();
    }

    private int isInteger(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private ImageView image;
        private TextView name;
        private TextView value;

        public ViewHolder(View itemView) {
            super(itemView);
            this.image = (ImageView)itemView.findViewById(R.id.image);
            this.name = (TextView)itemView.findViewById(R.id.name);
            this.value = (TextView)itemView.findViewById(R.id.value);
        }

        public void onClick(View v) {
        }
    }
}

