/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.i18n;

import android.text.TextUtils;
import com.vijay.jsonwizard.utils.FormUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonFormBundle {
    private static final String TAG = "JsonFormBundle";
    private static final String BUNDLE_KEY_PREFIX = "${";
    private static final String BUNDLE_KEY_SUFIX = "}";
    private static final String BUNDLE_DEFAULT_PROPERTY = "default";
    private final Map<String, String> mBundle = new HashMap<String, String>();
    private boolean twoLevelLocale;

    public JsonFormBundle(JSONObject form, Locale locale) throws JSONException {
        if (form.has("bundle")) {
            JSONObject bundleJson = form.getJSONObject("bundle");
            Map<String, Map<String, String>> bundleHasMap = bundleJson != null ? FormUtils.parseChecklistBundle(bundleJson.toString()) : null;
            this.twoLevelLocale = this.hasTwoLevelLocale(bundleHasMap);
            this.loadBundle(bundleHasMap, this.getLocale(locale));
        }
    }

    private boolean hasTwoLevelLocale(Map<String, Map<String, String>> bundle) {
        Map.Entry<String, Map<String, String>> entry = bundle.entrySet().iterator().next();
        String key = entry.getKey();
        return key.contains("-");
    }

    private String getLocale(Locale locale) {
        if (this.twoLevelLocale) {
            return locale.getLanguage() + "-" + locale.getCountry();
        }
        return locale.getLanguage();
    }

    public String resolveKey(String key) {
        String finalKey;
        if (!TextUtils.isEmpty((CharSequence)key) && key.startsWith(BUNDLE_KEY_PREFIX) && key.endsWith(BUNDLE_KEY_SUFIX) && this.mBundle.containsKey(finalKey = key.substring(2, key.length() - 1))) {
            return this.mBundle.get(finalKey);
        }
        return key;
    }

    private void loadBundle(Map<String, Map<String, String>> bundle, String deviceLang) {
        String lang = "";
        if (bundle.containsKey(deviceLang)) {
            lang = deviceLang;
        } else {
            String finalLang = deviceLang;
            List filteredBundle = bundle.keySet().stream().filter(str -> this.firstTwoCharacters((String)str).equals(this.firstTwoCharacters(finalLang))).collect(Collectors.toList());
            lang = !filteredBundle.isEmpty() ? (String)filteredBundle.get(0) : this.getDefaultLang(bundle);
        }
        Map<String, String> translations = bundle.get(lang);
        if (!"".equals(lang) && translations != null) {
            this.mBundle.putAll(translations);
        }
    }

    public String firstTwoCharacters(String str) {
        return str.length() < 2 ? str : str.substring(0, 2);
    }

    private String getDefaultLang(Map<String, Map<String, String>> bundle) {
        String defLang = "";
        for (Map.Entry<String, Map<String, String>> lang : bundle.entrySet()) {
            String isDefault;
            Map<String, String> translations;
            String currentLang = lang.getKey();
            if ("".equals(defLang)) {
                defLang = currentLang;
            }
            if ((translations = lang.getValue()) == null || (isDefault = translations.get(BUNDLE_DEFAULT_PROPERTY)) == null || isDefault.equals(Boolean.FALSE.toString())) continue;
            return currentLang;
        }
        return defLang;
    }
}

