/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.ui.adapter;

import android.content.Context;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.ad.AdViewHolder;
import com.huantansheng.easyphotos.models.album.entity.Photo;
import com.huantansheng.easyphotos.result.Result;
import com.huantansheng.easyphotos.setting.Setting;
import com.huantansheng.easyphotos.ui.widget.PressedImageView;
import com.huantansheng.easyphotos.utils.media.DurationUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class PhotosAdapter
extends RecyclerView.Adapter {
    private static final int TYPE_AD = 0;
    private static final int TYPE_CAMERA = 1;
    private static final int TYPE_ALBUM_ITEMS = 2;
    private ArrayList<Object> dataList;
    private LayoutInflater mInflater;
    private OnClickListener listener;
    private boolean unable;
    private boolean isSingle;
    private int singlePosition;
    private boolean clearAd = false;

    public PhotosAdapter(Context cxt, ArrayList<Object> dataList, OnClickListener listener) {
        this.dataList = dataList;
        this.listener = listener;
        this.mInflater = LayoutInflater.from((Context)cxt);
        this.unable = Result.count() == Setting.count;
        this.isSingle = Setting.count == 1;
    }

    public void change() {
        this.unable = Result.count() == Setting.count;
        this.notifyDataSetChanged();
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        switch (viewType) {
            case 0: {
                return new AdViewHolder(this.mInflater.inflate(R.layout.item_ad_easy_photos, parent, false));
            }
            case 1: {
                return new CameraViewHolder(this.mInflater.inflate(R.layout.item_camera_easy_photos, parent, false));
            }
        }
        return new PhotoViewHolder(this.mInflater.inflate(R.layout.item_rv_photos_easy_photos, parent, false));
    }

    public void onBindViewHolder(final @NonNull RecyclerView.ViewHolder holder, int position) {
        final int p = position;
        if (holder instanceof PhotoViewHolder) {
            boolean isGif;
            final Photo item = (Photo)this.dataList.get(p);
            if (item == null) {
                return;
            }
            this.updateSelector(((PhotoViewHolder)holder).tvSelector, item.selected, item, p);
            String path = item.path;
            Uri uri = item.uri;
            String type = item.type;
            long duration = item.duration;
            boolean bl = isGif = path.endsWith("gif") || type.endsWith("gif");
            if (Setting.showGif && isGif) {
                Setting.imageEngine.loadGifAsBitmap(((PhotoViewHolder)holder).ivPhoto.getContext(), uri, (ImageView)((PhotoViewHolder)holder).ivPhoto);
                ((PhotoViewHolder)holder).tvType.setText(R.string.gif_easy_photos);
                ((PhotoViewHolder)holder).tvType.setVisibility(0);
                ((PhotoViewHolder)holder).ivVideo.setVisibility(8);
            } else if (Setting.showVideo && type.contains("video")) {
                Setting.imageEngine.loadPhoto(((PhotoViewHolder)holder).ivPhoto.getContext(), uri, (ImageView)((PhotoViewHolder)holder).ivPhoto);
                ((PhotoViewHolder)holder).tvType.setText((CharSequence)DurationUtils.format(duration));
                ((PhotoViewHolder)holder).tvType.setVisibility(0);
                ((PhotoViewHolder)holder).ivVideo.setVisibility(0);
            } else {
                Setting.imageEngine.loadPhoto(((PhotoViewHolder)holder).ivPhoto.getContext(), uri, (ImageView)((PhotoViewHolder)holder).ivPhoto);
                ((PhotoViewHolder)holder).tvType.setVisibility(8);
                ((PhotoViewHolder)holder).ivVideo.setVisibility(8);
            }
            ((PhotoViewHolder)holder).vSelector.setVisibility(0);
            ((PhotoViewHolder)holder).tvSelector.setVisibility(0);
            ((PhotoViewHolder)holder).ivPhoto.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int realPosition = p;
                    if (Setting.hasPhotosAd()) {
                        --realPosition;
                    }
                    if (Setting.isShowCamera && !Setting.isBottomRightCamera()) {
                        --realPosition;
                    }
                    PhotosAdapter.this.listener.onPhotoClick(p, realPosition);
                }
            });
            ((PhotoViewHolder)holder).vSelector.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (PhotosAdapter.this.isSingle) {
                        PhotosAdapter.this.singleSelector(item, p);
                        return;
                    }
                    if (PhotosAdapter.this.unable) {
                        if (item.selected) {
                            Result.removePhoto(item);
                            if (PhotosAdapter.this.unable) {
                                PhotosAdapter.this.unable = false;
                            }
                            PhotosAdapter.this.listener.onSelectorChanged();
                            PhotosAdapter.this.notifyDataSetChanged();
                            return;
                        }
                        PhotosAdapter.this.listener.onSelectorOutOfMax(null);
                        return;
                    }
                    boolean bl = item.selected = !item.selected;
                    if (item.selected) {
                        int res = Result.addPhoto(item);
                        if (res != 0) {
                            PhotosAdapter.this.listener.onSelectorOutOfMax(res);
                            item.selected = false;
                            return;
                        }
                        ((PhotoViewHolder)holder).tvSelector.setBackgroundResource(R.drawable.bg_select_true_easy_photos);
                        ((PhotoViewHolder)holder).tvSelector.setText((CharSequence)String.valueOf(Result.count()));
                        if (Result.count() == Setting.count) {
                            PhotosAdapter.this.unable = true;
                            PhotosAdapter.this.notifyDataSetChanged();
                        }
                    } else {
                        Result.removePhoto(item);
                        if (PhotosAdapter.this.unable) {
                            PhotosAdapter.this.unable = false;
                        }
                        PhotosAdapter.this.notifyDataSetChanged();
                    }
                    PhotosAdapter.this.listener.onSelectorChanged();
                }
            });
            return;
        }
        if (holder instanceof AdViewHolder) {
            View adView;
            if (this.clearAd) {
                ((AdViewHolder)holder).adFrame.removeAllViews();
                ((AdViewHolder)holder).adFrame.setVisibility(8);
                return;
            }
            if (!Setting.photoAdIsOk) {
                ((AdViewHolder)holder).adFrame.setVisibility(8);
                return;
            }
            WeakReference weakReference = (WeakReference)this.dataList.get(p);
            if (null != weakReference && null != (adView = (View)weakReference.get())) {
                if (null != adView.getParent() && adView.getParent() instanceof FrameLayout) {
                    ((FrameLayout)adView.getParent()).removeAllViews();
                }
                ((AdViewHolder)holder).adFrame.setVisibility(0);
                ((AdViewHolder)holder).adFrame.removeAllViews();
                ((AdViewHolder)holder).adFrame.addView(adView);
            }
        }
        if (holder instanceof CameraViewHolder) {
            ((CameraViewHolder)holder).flCamera.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PhotosAdapter.this.listener.onCameraClick();
                }
            });
        }
    }

    public void clearAd() {
        this.clearAd = true;
        this.notifyDataSetChanged();
    }

    private void singleSelector(Photo photo, int position) {
        if (!Result.isEmpty()) {
            if (Result.getPhotoPath(0).equals(photo.path)) {
                Result.removePhoto(photo);
            } else {
                Result.removePhoto(0);
                Result.addPhoto(photo);
                this.notifyItemChanged(this.singlePosition);
            }
        } else {
            Result.addPhoto(photo);
        }
        this.notifyItemChanged(position);
        this.listener.onSelectorChanged();
    }

    private void updateSelector(TextView tvSelector, boolean selected, Photo photo, int position) {
        if (selected) {
            String number = Result.getSelectorNumber(photo);
            if (number.equals("0")) {
                tvSelector.setBackgroundResource(R.drawable.bg_select_false_easy_photos);
                tvSelector.setText(null);
                return;
            }
            tvSelector.setText((CharSequence)number);
            tvSelector.setBackgroundResource(R.drawable.bg_select_true_easy_photos);
            if (this.isSingle) {
                this.singlePosition = position;
                tvSelector.setText((CharSequence)"1");
            }
        } else {
            if (this.unable) {
                tvSelector.setBackgroundResource(R.drawable.bg_select_false_unable_easy_photos);
            } else {
                tvSelector.setBackgroundResource(R.drawable.bg_select_false_easy_photos);
            }
            tvSelector.setText(null);
        }
    }

    public int getItemCount() {
        return this.dataList.size();
    }

    public int getItemViewType(int position) {
        if (0 == position) {
            if (Setting.hasPhotosAd()) {
                return 0;
            }
            if (Setting.isShowCamera && !Setting.isBottomRightCamera()) {
                return 1;
            }
        }
        if (1 == position && !Setting.isBottomRightCamera() && Setting.hasPhotosAd() && Setting.isShowCamera) {
            return 1;
        }
        return 2;
    }

    public static class PhotoViewHolder
    extends RecyclerView.ViewHolder {
        final PressedImageView ivPhoto;
        final TextView tvSelector;
        final View vSelector;
        final TextView tvType;
        final ImageView ivVideo;

        PhotoViewHolder(View itemView) {
            super(itemView);
            this.ivPhoto = (PressedImageView)itemView.findViewById(R.id.iv_photo);
            this.tvSelector = (TextView)itemView.findViewById(R.id.tv_selector);
            this.vSelector = itemView.findViewById(R.id.v_selector);
            this.tvType = (TextView)itemView.findViewById(R.id.tv_type);
            this.ivVideo = (ImageView)itemView.findViewById(R.id.iv_play);
        }
    }

    private static class CameraViewHolder
    extends RecyclerView.ViewHolder {
        final FrameLayout flCamera;

        CameraViewHolder(View itemView) {
            super(itemView);
            this.flCamera = (FrameLayout)itemView.findViewById(R.id.fl_camera);
        }
    }

    public static interface OnClickListener {
        public void onCameraClick();

        public void onPhotoClick(int var1, int var2);

        public void onSelectorOutOfMax(@Nullable Integer var1);

        public void onSelectorChanged();
    }
}

