/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.album.AlbumModel;
import com.huantansheng.easyphotos.models.album.entity.Photo;
import com.huantansheng.easyphotos.result.Result;
import com.huantansheng.easyphotos.setting.Setting;
import com.huantansheng.easyphotos.ui.PreviewFragment;
import com.huantansheng.easyphotos.ui.adapter.PreviewPhotosAdapter;
import com.huantansheng.easyphotos.ui.widget.PressedTextView;
import com.huantansheng.easyphotos.utils.Color.ColorUtils;
import com.huantansheng.easyphotos.utils.system.SystemUtils;
import java.util.ArrayList;

public class PreviewActivity
extends AppCompatActivity
implements PreviewPhotosAdapter.OnClickListener,
View.OnClickListener,
PreviewFragment.OnPreviewFragmentClickListener {
    private static final int UI_ANIMATION_DELAY = 300;
    private final Handler mHideHandler = new Handler();
    private final Runnable mHidePart2Runnable = new Runnable(){

        @Override
        public void run() {
            SystemUtils.getInstance().systemUiHide((Activity)PreviewActivity.this, PreviewActivity.this.decorView);
        }
    };
    private RelativeLayout mBottomBar;
    private FrameLayout mToolBar;
    private final Runnable mShowPart2Runnable = new Runnable(){

        @Override
        public void run() {
            PreviewActivity.this.mBottomBar.setVisibility(0);
            PreviewActivity.this.mToolBar.setVisibility(0);
        }
    };
    private boolean mVisible;
    View decorView;
    private TextView tvOriginal;
    private TextView tvNumber;
    private PressedTextView tvDone;
    private ImageView ivSelector;
    private RecyclerView rvPhotos;
    private PreviewPhotosAdapter adapter;
    private PagerSnapHelper snapHelper;
    private LinearLayoutManager lm;
    private int index;
    private ArrayList<Photo> photos = new ArrayList();
    private int resultCode = 0;
    private int lastPosition = 0;
    private boolean isSingle = Setting.count == 1;
    private boolean unable = Result.count() == Setting.count;
    private FrameLayout flFragment;
    private PreviewFragment previewFragment;
    private int statusColor;
    private boolean clickDone = false;

    public static void start(Activity act, int albumItemIndex, int currIndex) {
        Intent intent = new Intent((Context)act, PreviewActivity.class);
        intent.putExtra("keyOfPreviewAlbumItemIndex", albumItemIndex);
        intent.putExtra("keyOfPreviewPhotoIndex", currIndex);
        act.startActivityForResult(intent, 13);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.decorView = this.getWindow().getDecorView();
        SystemUtils.getInstance().systemUiInit((Activity)this, this.decorView);
        this.setContentView(R.layout.activity_preview_easy_photos);
        this.hideActionBar();
        this.adaptationStatusBar();
        if (null == AlbumModel.instance) {
            this.finish();
            return;
        }
        this.initData();
        this.initView();
    }

    private void adaptationStatusBar() {
        if (Build.VERSION.SDK_INT >= 23) {
            this.statusColor = ContextCompat.getColor((Context)this, (int)R.color.easy_photos_status_bar);
            if (ColorUtils.isWhiteColor(this.statusColor)) {
                this.getWindow().addFlags(0x4000000);
            }
        }
    }

    private void hideActionBar() {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.hide();
        }
    }

    private void initData() {
        Intent intent = this.getIntent();
        int albumItemIndex = intent.getIntExtra("keyOfPreviewAlbumItemIndex", 0);
        this.photos.clear();
        if (albumItemIndex == -1) {
            this.photos.addAll(Result.photos);
        } else {
            this.photos.addAll(AlbumModel.instance.getCurrAlbumItemPhotos(albumItemIndex));
        }
        this.lastPosition = this.index = intent.getIntExtra("keyOfPreviewPhotoIndex", 0);
        this.mVisible = true;
    }

    private void toggle() {
        if (this.mVisible) {
            this.hide();
        } else {
            this.show();
        }
    }

    private void hide() {
        AlphaAnimation hideAnimation = new AlphaAnimation(1.0f, 0.0f);
        hideAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                PreviewActivity.this.mBottomBar.setVisibility(8);
                PreviewActivity.this.mToolBar.setVisibility(8);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        hideAnimation.setDuration(300L);
        this.mBottomBar.startAnimation((Animation)hideAnimation);
        this.mToolBar.startAnimation((Animation)hideAnimation);
        this.mVisible = false;
        this.mHideHandler.removeCallbacks(this.mShowPart2Runnable);
        this.mHideHandler.postDelayed(this.mHidePart2Runnable, 300L);
    }

    private void show() {
        if (Build.VERSION.SDK_INT >= 16) {
            SystemUtils.getInstance().systemUiShow((Activity)this, this.decorView);
        }
        this.mVisible = true;
        this.mHideHandler.removeCallbacks(this.mHidePart2Runnable);
        this.mHideHandler.post(this.mShowPart2Runnable);
    }

    @Override
    public void onPhotoClick() {
        this.toggle();
    }

    @Override
    public void onPhotoScaleChanged() {
        if (this.mVisible) {
            this.hide();
        }
    }

    public void onBackPressed() {
        this.doBack();
    }

    private void doBack() {
        Intent intent = new Intent();
        intent.putExtra("keyOfPreviewClickDone", false);
        this.setResult(this.resultCode, intent);
        this.finish();
    }

    private void initView() {
        this.setClick(R.id.iv_back, R.id.tv_edit, R.id.tv_selector);
        this.mToolBar = (FrameLayout)this.findViewById(R.id.m_top_bar_layout);
        if (!SystemUtils.getInstance().hasNavigationBar((Activity)this)) {
            FrameLayout mRootView = (FrameLayout)this.findViewById(R.id.m_root_view);
            mRootView.setFitsSystemWindows(true);
            this.mToolBar.setPadding(0, SystemUtils.getInstance().getStatusBarHeight((Context)this), 0, 0);
            if (ColorUtils.isWhiteColor(this.statusColor)) {
                SystemUtils.getInstance().setStatusDark((Activity)this, true);
            }
        }
        this.mBottomBar = (RelativeLayout)this.findViewById(R.id.m_bottom_bar);
        this.ivSelector = (ImageView)this.findViewById(R.id.iv_selector);
        this.tvNumber = (TextView)this.findViewById(R.id.tv_number);
        this.tvDone = (PressedTextView)this.findViewById(R.id.tv_done);
        this.tvOriginal = (TextView)this.findViewById(R.id.tv_original);
        this.flFragment = (FrameLayout)this.findViewById(R.id.fl_fragment);
        this.previewFragment = (PreviewFragment)this.getSupportFragmentManager().findFragmentById(R.id.fragment_preview);
        if (Setting.showOriginalMenu) {
            this.processOriginalMenu();
        } else {
            this.tvOriginal.setVisibility(8);
        }
        this.setClick(new View[]{this.tvOriginal, this.tvDone, this.ivSelector});
        this.initRecyclerView();
        this.shouldShowMenuDone();
    }

    private void initRecyclerView() {
        this.rvPhotos = (RecyclerView)this.findViewById(R.id.rv_photos);
        this.adapter = new PreviewPhotosAdapter((Context)this, this.photos, this);
        this.lm = new LinearLayoutManager((Context)this, 0, false);
        this.rvPhotos.setLayoutManager((RecyclerView.LayoutManager)this.lm);
        this.rvPhotos.setAdapter((RecyclerView.Adapter)this.adapter);
        this.rvPhotos.scrollToPosition(this.index);
        this.toggleSelector();
        this.snapHelper = new PagerSnapHelper();
        this.snapHelper.attachToRecyclerView(this.rvPhotos);
        this.rvPhotos.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                View view = PreviewActivity.this.snapHelper.findSnapView((RecyclerView.LayoutManager)PreviewActivity.this.lm);
                if (view == null) {
                    return;
                }
                int position = PreviewActivity.this.lm.getPosition(view);
                if (PreviewActivity.this.lastPosition == position) {
                    return;
                }
                PreviewActivity.this.lastPosition = position;
                PreviewActivity.this.previewFragment.setSelectedPosition(-1);
                PreviewActivity.this.tvNumber.setText((CharSequence)PreviewActivity.this.getString(R.string.preview_current_number_easy_photos, new Object[]{PreviewActivity.this.lastPosition + 1, PreviewActivity.this.photos.size()}));
                PreviewActivity.this.toggleSelector();
            }
        });
        this.tvNumber.setText((CharSequence)this.getString(R.string.preview_current_number_easy_photos, new Object[]{this.index + 1, this.photos.size()}));
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (R.id.iv_back == id2) {
            this.doBack();
        } else if (R.id.tv_selector == id2) {
            this.updateSelector();
        } else if (R.id.iv_selector == id2) {
            this.updateSelector();
        } else if (R.id.tv_original == id2) {
            if (!Setting.originalMenuUsable) {
                Toast.makeText((Context)this.getApplicationContext(), (CharSequence)Setting.originalMenuUnusableHint, (int)0).show();
                return;
            }
            Setting.selectedOriginal = !Setting.selectedOriginal;
            this.processOriginalMenu();
        } else if (R.id.tv_done == id2) {
            if (this.clickDone) {
                return;
            }
            this.clickDone = true;
            Intent intent = new Intent();
            intent.putExtra("keyOfPreviewClickDone", true);
            this.setResult(-1, intent);
            this.finish();
        }
    }

    private void processOriginalMenu() {
        if (Setting.selectedOriginal) {
            this.tvOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.easy_photos_fg_accent));
        } else if (Setting.originalMenuUsable) {
            this.tvOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.easy_photos_fg_primary));
        } else {
            this.tvOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.easy_photos_fg_primary_dark));
        }
    }

    private void toggleSelector() {
        if (this.photos.get((int)this.lastPosition).selected) {
            this.ivSelector.setImageResource(R.drawable.ic_selector_true_easy_photos);
            if (!Result.isEmpty()) {
                int count = Result.count();
                for (int i = 0; i < count; ++i) {
                    if (!this.photos.get((int)this.lastPosition).path.equals(Result.getPhotoPath(i))) continue;
                    this.previewFragment.setSelectedPosition(i);
                    break;
                }
            }
        } else {
            this.ivSelector.setImageResource(R.drawable.ic_selector_easy_photos);
        }
        this.previewFragment.notifyDataSetChanged();
        this.shouldShowMenuDone();
    }

    private void updateSelector() {
        this.resultCode = -1;
        Photo item = this.photos.get(this.lastPosition);
        if (this.isSingle) {
            this.singleSelector(item);
            return;
        }
        if (this.unable) {
            if (item.selected) {
                Result.removePhoto(item);
                if (this.unable) {
                    this.unable = false;
                }
                this.toggleSelector();
                return;
            }
            if (Setting.isOnlyVideo()) {
                Toast.makeText((Context)this.getApplicationContext(), (CharSequence)this.getString(R.string.selector_reach_max_video_hint_easy_photos, new Object[]{Setting.count}), (int)0).show();
            } else if (Setting.showVideo) {
                Toast.makeText((Context)this.getApplicationContext(), (CharSequence)this.getString(R.string.selector_reach_max_hint_easy_photos, new Object[]{Setting.count}), (int)0).show();
            } else {
                Toast.makeText((Context)this.getApplicationContext(), (CharSequence)this.getString(R.string.selector_reach_max_image_hint_easy_photos, new Object[]{Setting.count}), (int)0).show();
            }
            return;
        }
        boolean bl = item.selected = !item.selected;
        if (item.selected) {
            int res = Result.addPhoto(item);
            if (res != 0) {
                item.selected = false;
                switch (res) {
                    case -1: {
                        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)this.getString(R.string.selector_reach_max_image_hint_easy_photos, new Object[]{Setting.complexPictureCount}), (int)0).show();
                        break;
                    }
                    case -2: {
                        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)this.getString(R.string.selector_reach_max_video_hint_easy_photos, new Object[]{Setting.complexVideoCount}), (int)0).show();
                        break;
                    }
                    case -3: {
                        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)this.getString(R.string.selector_single_type_hint_easy_photos), (int)0).show();
                    }
                }
                return;
            }
            if (Result.count() == Setting.count) {
                this.unable = true;
            }
        } else {
            Result.removePhoto(item);
            this.previewFragment.setSelectedPosition(-1);
            if (this.unable) {
                this.unable = false;
            }
        }
        this.toggleSelector();
    }

    private void singleSelector(Photo photo) {
        if (!Result.isEmpty()) {
            if (Result.getPhotoPath(0).equals(photo.path)) {
                Result.removePhoto(photo);
            } else {
                Result.removePhoto(0);
                Result.addPhoto(photo);
            }
        } else {
            Result.addPhoto(photo);
        }
        this.toggleSelector();
    }

    private void shouldShowMenuDone() {
        if (Result.isEmpty()) {
            if (0 == this.tvDone.getVisibility()) {
                ScaleAnimation scaleHide = new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f);
                scaleHide.setDuration(200L);
                this.tvDone.startAnimation((Animation)scaleHide);
            }
            this.tvDone.setVisibility(8);
            this.flFragment.setVisibility(8);
        } else {
            if (8 == this.tvDone.getVisibility()) {
                ScaleAnimation scaleShow = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f);
                scaleShow.setDuration(200L);
                this.tvDone.startAnimation((Animation)scaleShow);
            }
            this.flFragment.setVisibility(0);
            this.tvDone.setVisibility(0);
            this.tvDone.setText(this.getString(R.string.selector_action_done_easy_photos, new Object[]{Result.count(), Setting.count}));
        }
    }

    @Override
    public void onPreviewPhotoClick(int position) {
        String path = Result.getPhotoPath(position);
        int size = this.photos.size();
        for (int i = 0; i < size; ++i) {
            if (!TextUtils.equals((CharSequence)path, (CharSequence)this.photos.get((int)i).path)) continue;
            this.rvPhotos.scrollToPosition(i);
            this.lastPosition = i;
            this.tvNumber.setText((CharSequence)this.getString(R.string.preview_current_number_easy_photos, new Object[]{this.lastPosition + 1, this.photos.size()}));
            this.previewFragment.setSelectedPosition(position);
            this.toggleSelector();
            return;
        }
    }

    private void setClick(int ... ids) {
        for (int id2 : ids) {
            this.findViewById(id2).setOnClickListener((View.OnClickListener)this);
        }
    }

    private void setClick(View ... views) {
        for (View v : views) {
            v.setOnClickListener((View.OnClickListener)this);
        }
    }
}

