/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.utils.bitmap;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextPaint;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.exifinterface.media.ExifInterface;
import com.huantansheng.easyphotos.EasyPhotos;
import com.huantansheng.easyphotos.models.album.entity.Photo;
import com.huantansheng.easyphotos.utils.bitmap.SaveBitmapCallBack;
import com.huantansheng.easyphotos.utils.uri.UriUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class BitmapUtils {
    public static void recycle(Bitmap bitmap) {
        if (null != bitmap && !bitmap.isRecycled()) {
            bitmap.recycle();
            bitmap = null;
        }
        System.gc();
    }

    public static void recycle(Bitmap ... bitmaps) {
        for (Bitmap b : bitmaps) {
            BitmapUtils.recycle(b);
        }
    }

    public static void recycle(List<Bitmap> bitmaps) {
        for (Bitmap b : bitmaps) {
            BitmapUtils.recycle(b);
        }
    }

    public static Bitmap addWatermark(Bitmap watermark, Bitmap image, int srcWaterMarkImageWidth, int offsetX, int offsetY, boolean addInLeft, int orientation) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (0 == imageWidth || 0 == imageHeight) {
            throw new RuntimeException("AlbumBuilder: \u52a0\u6c34\u5370\u7684\u539f\u56fe\u5bbd\u6216\u9ad8\u4e0d\u80fd\u4e3a0\uff01");
        }
        switch (orientation) {
            case 90: 
            case 270: {
                image = BitmapUtils.adjustBitmapRotation(image, orientation);
                int temp = imageHeight;
                imageHeight = imageWidth;
                imageWidth = temp;
                break;
            }
            case 180: {
                image = BitmapUtils.adjustBitmapRotation(image, orientation);
            }
        }
        int watermarkWidth = watermark.getWidth();
        int watermarkHeight = watermark.getHeight();
        float scale = (float)imageWidth / (float)srcWaterMarkImageWidth;
        if (scale > 1.0f) {
            scale = 1.0f;
        } else if ((double)scale < 0.4) {
            scale = 0.4f;
        }
        int scaleWatermarkWidth = (int)((float)watermarkWidth * scale);
        int scaleWatermarkHeight = (int)((float)watermarkHeight * scale);
        Bitmap scaleWatermark = Bitmap.createScaledBitmap((Bitmap)watermark, (int)scaleWatermarkWidth, (int)scaleWatermarkHeight, (boolean)true);
        Canvas canvas = new Canvas(image);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        if (addInLeft) {
            canvas.drawBitmap(scaleWatermark, (float)offsetX, (float)(imageHeight - scaleWatermarkHeight - offsetY), paint);
        } else {
            canvas.drawBitmap(scaleWatermark, (float)(imageWidth - offsetX - scaleWatermarkWidth), (float)(imageHeight - scaleWatermarkHeight - offsetY), paint);
        }
        BitmapUtils.recycle(scaleWatermark);
        return image;
    }

    public static Bitmap addWatermarkWithText(@NonNull Bitmap watermark, Bitmap image, int srcWaterMarkImageWidth, @NonNull String text, int offsetX, int offsetY, boolean addInLeft, int orientation) {
        float imageWidth = image.getWidth();
        float imageHeight = image.getHeight();
        if (0.0f == imageWidth || 0.0f == imageHeight) {
            throw new RuntimeException("AlbumBuilder: \u52a0\u6c34\u5370\u7684\u539f\u56fe\u5bbd\u6216\u9ad8\u4e0d\u80fd\u4e3a0\uff01");
        }
        switch (orientation) {
            case 90: 
            case 270: {
                image = BitmapUtils.adjustBitmapRotation(image, orientation);
                float temp = imageHeight;
                imageHeight = imageWidth;
                imageWidth = temp;
                break;
            }
            case 180: {
                image = BitmapUtils.adjustBitmapRotation(image, orientation);
            }
        }
        float watermarkWidth = watermark.getWidth();
        float watermarkHeight = watermark.getHeight();
        float scale = imageWidth / (float)srcWaterMarkImageWidth;
        if (scale > 1.0f) {
            scale = 1.0f;
        } else if ((double)scale < 0.4) {
            scale = 0.4f;
        }
        float scaleWatermarkWidth = watermarkWidth * scale;
        float scaleWatermarkHeight = watermarkHeight * scale;
        Bitmap scaleWatermark = Bitmap.createScaledBitmap((Bitmap)watermark, (int)((int)scaleWatermarkWidth), (int)((int)scaleWatermarkHeight), (boolean)true);
        Canvas canvas = new Canvas(image);
        TextPaint textPaint = new TextPaint();
        textPaint.setAntiAlias(true);
        textPaint.setColor(-1);
        float textsize = (float)(scaleWatermark.getHeight() * 2) / 3.0f;
        textPaint.setTextSize(textsize);
        Rect textRect = new Rect();
        textPaint.getTextBounds(text, 0, text.length(), textRect);
        if (addInLeft) {
            canvas.drawText(text, scaleWatermarkWidth + (float)offsetX, imageHeight - (float)textRect.height() - (float)textRect.top - (float)offsetY, (Paint)textPaint);
        } else {
            canvas.drawText(text, imageWidth - (float)offsetX - (float)textRect.width() - (float)textRect.left, imageHeight - (float)textRect.height() - (float)textRect.top - (float)offsetY, (Paint)textPaint);
        }
        Paint sacleWatermarkPaint = new Paint();
        sacleWatermarkPaint.setAntiAlias(true);
        if (addInLeft) {
            canvas.drawBitmap(scaleWatermark, (float)offsetX, imageHeight - (float)textRect.height() - (float)offsetY - scaleWatermarkHeight / 6.0f, sacleWatermarkPaint);
        } else {
            canvas.drawBitmap(scaleWatermark, imageWidth - (float)textRect.width() - (float)offsetX - scaleWatermarkWidth / 6.0f, imageHeight - (float)textRect.height() - (float)offsetY - scaleWatermarkHeight / 6.0f, sacleWatermarkPaint);
        }
        BitmapUtils.recycle(scaleWatermark);
        return image;
    }

    public static void saveBitmapToDir(final Activity act, final String dirPath, final String namePrefix, final Bitmap bitmap, final boolean notifyMedia, final SaveBitmapCallBack callBack) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (Build.VERSION.SDK_INT > 28) {
                    BitmapUtils.saveBitmapToDirQ(act, dirPath, namePrefix, bitmap, notifyMedia, callBack);
                    return;
                }
                File dirF = new File(dirPath);
                if (!(dirF.exists() && dirF.isDirectory() || dirF.mkdirs())) {
                    act.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            callBack.onCreateDirFailed();
                        }
                    });
                    return;
                }
                try {
                    final File writeFile = File.createTempFile(namePrefix, ".png", dirF);
                    FileOutputStream fos = null;
                    fos = new FileOutputStream(writeFile);
                    bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
                    fos.flush();
                    fos.close();
                    if (notifyMedia) {
                        EasyPhotos.notifyMedia((Context)act, writeFile);
                    }
                    act.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            callBack.onSuccess(writeFile);
                        }
                    });
                }
                catch (IOException e) {
                    act.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            callBack.onIOFailed(e);
                        }
                    });
                }
            }
        }).start();
    }

    private static void saveBitmapToDirQ(final Activity act, String dirPath, String namePrefix, Bitmap bitmap, boolean notifyMedia, final SaveBitmapCallBack callBack) {
        long dataTake = System.currentTimeMillis();
        String jpegName = namePrefix + dataTake + ".png";
        ContentValues values = new ContentValues();
        values.put("_display_name", jpegName);
        values.put("mime_type", "image/png");
        int dirIndex = dirPath.lastIndexOf("/");
        if (dirIndex == dirPath.length()) {
            String dirPath2 = dirPath.substring(0, dirIndex - 1);
            dirIndex = dirPath2.lastIndexOf("/");
        }
        String dirName = dirPath.substring(dirIndex + 1);
        values.put("relative_path", "DCIM/" + dirName);
        ContentResolver resolver = act.getContentResolver();
        String status = Environment.getExternalStorageState();
        Uri external = status.equals("mounted") ? MediaStore.Images.Media.getContentUri((String)"external") : MediaStore.Images.Media.INTERNAL_CONTENT_URI;
        final Uri insertUri = resolver.insert(external, values);
        if (insertUri == null) {
            act.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    callBack.onCreateDirFailed();
                }
            });
            return;
        }
        try {
            OutputStream os = resolver.openOutputStream(insertUri);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, os);
            if (os != null) {
                os.flush();
                os.close();
            }
            act.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    String uriPath = UriUtils.getPathByUri((Context)act, insertUri);
                    if (null == uriPath) {
                        callBack.onCreateDirFailed();
                    } else {
                        callBack.onSuccess(new File(uriPath));
                    }
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            act.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    callBack.onIOFailed(e);
                }
            });
        }
    }

    public static Bitmap createBitmapFromView(View view) {
        Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        view.draw(canvas);
        return bitmap;
    }

    public static Boolean needChangeWidthAndHeight(Photo photo) throws IOException {
        ExifInterface exifInterface = new ExifInterface(photo.path);
        int exifOrientation = exifInterface.getAttributeInt("Orientation", 1);
        return exifOrientation == 6 || exifOrientation == 8;
    }

    public static void calculateLocalImageSizeThroughBitmapOptions(Photo photo) throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)photo.path, (BitmapFactory.Options)options);
        photo.width = options.outWidth;
        photo.height = options.outHeight;
    }

    public static Bitmap adjustBitmapRotation(Bitmap bm, int orientationDegree) {
        float targetY;
        float targetX;
        Matrix m = new Matrix();
        m.setRotate((float)orientationDegree, (float)bm.getWidth() / 2.0f, (float)bm.getHeight() / 2.0f);
        if (orientationDegree == 90) {
            targetX = bm.getHeight();
            targetY = 0.0f;
        } else {
            targetX = bm.getHeight();
            targetY = bm.getWidth();
        }
        float[] values = new float[9];
        m.getValues(values);
        float x1 = values[2];
        float y1 = values[5];
        m.postTranslate(targetX - x1, targetY - y1);
        Bitmap bm1 = Bitmap.createBitmap((int)bm.getHeight(), (int)bm.getWidth(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Paint paint = new Paint();
        Canvas canvas = new Canvas(bm1);
        canvas.drawBitmap(bm, m, paint);
        return bm1;
    }
}

