/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.ui.adapter;

import android.content.Context;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.album.entity.Photo;
import com.huantansheng.easyphotos.setting.Setting;
import com.huantansheng.easyphotos.utils.media.DurationUtils;
import java.util.ArrayList;

public class PuzzleSelectorPreviewAdapter
extends RecyclerView.Adapter {
    private ArrayList<Photo> dataList;
    private LayoutInflater mInflater;
    private OnClickListener listener;

    public PuzzleSelectorPreviewAdapter(Context cxt, ArrayList<Photo> dataList, OnClickListener listener) {
        this.dataList = dataList;
        this.listener = listener;
        this.mInflater = LayoutInflater.from((Context)cxt);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new PhotoViewHolder(this.mInflater.inflate(R.layout.item_puzzle_selector_preview_easy_photos, parent, false));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        boolean isGif;
        final int p = position;
        Photo photo = this.dataList.get(position);
        String path = photo.path;
        String type = photo.type;
        Uri uri = photo.uri;
        long duration = photo.duration;
        boolean bl = isGif = path.endsWith("gif") || type.endsWith("gif");
        if (Setting.showGif && isGif) {
            Setting.imageEngine.loadGifAsBitmap(((PhotoViewHolder)holder).ivPhoto.getContext(), uri, ((PhotoViewHolder)holder).ivPhoto);
            ((PhotoViewHolder)holder).tvType.setText(R.string.gif_easy_photos);
            ((PhotoViewHolder)holder).tvType.setVisibility(0);
        } else if (Setting.showVideo && type.contains("video")) {
            Setting.imageEngine.loadPhoto(((PhotoViewHolder)holder).ivPhoto.getContext(), uri, ((PhotoViewHolder)holder).ivPhoto);
            ((PhotoViewHolder)holder).tvType.setText((CharSequence)DurationUtils.format(duration));
            ((PhotoViewHolder)holder).tvType.setVisibility(0);
        } else {
            Setting.imageEngine.loadPhoto(((PhotoViewHolder)holder).ivPhoto.getContext(), uri, ((PhotoViewHolder)holder).ivPhoto);
            ((PhotoViewHolder)holder).tvType.setVisibility(8);
        }
        ((PhotoViewHolder)holder).ivDelete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PuzzleSelectorPreviewAdapter.this.listener.onDeleteClick(p);
            }
        });
    }

    public int getItemCount() {
        return null == this.dataList ? 0 : this.dataList.size();
    }

    public class PhotoViewHolder
    extends RecyclerView.ViewHolder {
        ImageView ivPhoto;
        ImageView ivDelete;
        TextView tvType;

        public PhotoViewHolder(View itemView) {
            super(itemView);
            this.ivPhoto = (ImageView)itemView.findViewById(R.id.iv_photo);
            this.ivDelete = (ImageView)itemView.findViewById(R.id.iv_delete);
            this.tvType = (TextView)itemView.findViewById(R.id.tv_type);
        }
    }

    public static interface OnClickListener {
        public void onDeleteClick(int var1);
    }
}

