/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.models.sticker.cache;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import androidx.annotation.IdRes;
import com.huantansheng.easyphotos.EasyPhotos;
import java.util.LinkedHashMap;

public class StickerCache {
    private static StickerCache instance = null;
    private LinkedHashMap<String, Bitmap> srcBitmapCache = new LinkedHashMap();
    private LinkedHashMap<String, Bitmap> mirrorBitmapCache = new LinkedHashMap();
    private LinkedHashMap<String, Integer> bitmapUsedCount = new LinkedHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StickerCache get() {
        if (null != instance) return instance;
        Class<StickerCache> clazz = StickerCache.class;
        synchronized (StickerCache.class) {
            if (null != instance) return instance;
            instance = new StickerCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private StickerCache() {
    }

    public Bitmap getSrcBitmap(String path) {
        Bitmap bitmap = this.srcBitmapCache.get(path);
        if (null == bitmap) {
            bitmap = BitmapFactory.decodeFile((String)path);
            this.srcBitmapCache.put(path, bitmap);
            this.bitmapUsedCount.put(path, 0);
            this.convertMirror(path, bitmap);
        }
        int count = this.bitmapUsedCount.get(path);
        this.bitmapUsedCount.put(path, ++count);
        return bitmap;
    }

    public Bitmap getSrcBitmap(Resources resources, @IdRes int resId) {
        String path = String.valueOf(resId);
        Bitmap bitmap = this.srcBitmapCache.get(path);
        if (null == bitmap) {
            bitmap = BitmapFactory.decodeResource((Resources)resources, (int)resId);
            this.srcBitmapCache.put(path, bitmap);
            this.bitmapUsedCount.put(path, 0);
            this.convertMirror(path, bitmap);
        }
        int count = this.bitmapUsedCount.get(path);
        this.bitmapUsedCount.put(path, ++count);
        return bitmap;
    }

    public Bitmap getMirrorBitmap(String key) {
        return this.mirrorBitmapCache.get(key);
    }

    public void clear() {
        for (String key : this.srcBitmapCache.keySet()) {
            this.recycle(key);
        }
    }

    public void recycle(String key) {
        if (!this.srcBitmapCache.containsKey(key)) {
            return;
        }
        int count = this.bitmapUsedCount.get(key);
        if (count > 1) {
            this.bitmapUsedCount.put(key, --count);
            return;
        }
        EasyPhotos.recycle(this.srcBitmapCache.get(key), this.mirrorBitmapCache.get(key));
        this.removeKey(key);
    }

    private void convertMirror(String key, Bitmap a) {
        int w = a.getWidth();
        int h = a.getHeight();
        Matrix m = new Matrix();
        m.postScale(-1.0f, 1.0f);
        Bitmap mirrorBitmap = Bitmap.createBitmap((Bitmap)a, (int)0, (int)0, (int)w, (int)h, (Matrix)m, (boolean)true);
        this.mirrorBitmapCache.put(key, mirrorBitmap);
    }

    private void removeKey(String key) {
        this.srcBitmapCache.remove(key);
        this.mirrorBitmapCache.remove(key);
        this.bitmapUsedCount.remove(key);
    }
}

