/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.Builder;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.net.Uri;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import com.huantansheng.easyphotos.callback.SelectCallback;
import com.huantansheng.easyphotos.engine.ImageEngine;
import com.huantansheng.easyphotos.models.ad.AdListener;
import com.huantansheng.easyphotos.models.album.entity.Photo;
import com.huantansheng.easyphotos.result.Result;
import com.huantansheng.easyphotos.setting.Setting;
import com.huantansheng.easyphotos.ui.EasyPhotosActivity;
import com.huantansheng.easyphotos.utils.result.EasyResult;
import com.huantansheng.easyphotos.utils.uri.UriUtils;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;

public class AlbumBuilder {
    private static final String TAG = "com.huantansheng.easyphotos";
    private static AlbumBuilder instance;
    private WeakReference<Activity> mActivity;
    private WeakReference<androidx.fragment.app.Fragment> mFragmentV;
    private WeakReference<Fragment> mFragment;
    private StartupType startupType;
    private WeakReference<AdListener> adListener;

    private AlbumBuilder(Activity activity, StartupType startupType) {
        this.mActivity = new WeakReference<Activity>(activity);
        this.startupType = startupType;
    }

    private AlbumBuilder(Fragment fragment, StartupType startupType) {
        this.mFragment = new WeakReference<Fragment>(fragment);
        this.startupType = startupType;
    }

    private AlbumBuilder(FragmentActivity activity, StartupType startupType) {
        this.mActivity = new WeakReference<FragmentActivity>(activity);
        this.startupType = startupType;
    }

    private AlbumBuilder(androidx.fragment.app.Fragment fragment, StartupType startupType) {
        this.mFragmentV = new WeakReference<androidx.fragment.app.Fragment>(fragment);
        this.startupType = startupType;
    }

    private static AlbumBuilder with(Activity activity, StartupType startupType) {
        AlbumBuilder.clear();
        instance = new AlbumBuilder(activity, startupType);
        return instance;
    }

    private static AlbumBuilder with(Fragment fragment, StartupType startupType) {
        AlbumBuilder.clear();
        instance = new AlbumBuilder(fragment, startupType);
        return instance;
    }

    private static AlbumBuilder with(FragmentActivity activity, StartupType startupType) {
        AlbumBuilder.clear();
        instance = new AlbumBuilder(activity, startupType);
        return instance;
    }

    private static AlbumBuilder with(androidx.fragment.app.Fragment fragmentV, StartupType startupType) {
        AlbumBuilder.clear();
        instance = new AlbumBuilder(fragmentV, startupType);
        return instance;
    }

    public static AlbumBuilder createCamera(Activity activity) {
        return AlbumBuilder.with(activity, StartupType.CAMERA);
    }

    public static AlbumBuilder createCamera(Fragment fragment) {
        return AlbumBuilder.with(fragment, StartupType.CAMERA);
    }

    public static AlbumBuilder createCamera(FragmentActivity activity) {
        return AlbumBuilder.with(activity, StartupType.CAMERA);
    }

    public static AlbumBuilder createCamera(androidx.fragment.app.Fragment fragmentV) {
        return AlbumBuilder.with(fragmentV, StartupType.CAMERA);
    }

    public static AlbumBuilder createAlbum(Activity activity, boolean isShowCamera, @NonNull ImageEngine imageEngine) {
        if (Setting.imageEngine != imageEngine) {
            Setting.imageEngine = imageEngine;
        }
        if (isShowCamera) {
            return AlbumBuilder.with(activity, StartupType.ALBUM_CAMERA);
        }
        return AlbumBuilder.with(activity, StartupType.ALBUM);
    }

    public static AlbumBuilder createAlbum(Fragment fragment, boolean isShowCamera, @NonNull ImageEngine imageEngine) {
        if (Setting.imageEngine != imageEngine) {
            Setting.imageEngine = imageEngine;
        }
        if (isShowCamera) {
            return AlbumBuilder.with(fragment, StartupType.ALBUM_CAMERA);
        }
        return AlbumBuilder.with(fragment, StartupType.ALBUM);
    }

    public static AlbumBuilder createAlbum(FragmentActivity activity, boolean isShowCamera, @NonNull ImageEngine imageEngine) {
        if (Setting.imageEngine != imageEngine) {
            Setting.imageEngine = imageEngine;
        }
        if (isShowCamera) {
            return AlbumBuilder.with(activity, StartupType.ALBUM_CAMERA);
        }
        return AlbumBuilder.with(activity, StartupType.ALBUM);
    }

    public static AlbumBuilder createAlbum(androidx.fragment.app.Fragment fragmentV, boolean isShowCamera, @NonNull ImageEngine imageEngine) {
        if (Setting.imageEngine != imageEngine) {
            Setting.imageEngine = imageEngine;
        }
        if (isShowCamera) {
            return AlbumBuilder.with(fragmentV, StartupType.ALBUM_CAMERA);
        }
        return AlbumBuilder.with(fragmentV, StartupType.ALBUM);
    }

    public AlbumBuilder setFileProviderAuthority(String fileProviderAuthority) {
        Setting.fileProviderAuthority = fileProviderAuthority;
        return this;
    }

    public AlbumBuilder setCount(int selectorMaxCount) {
        if (Setting.complexSelector) {
            return this;
        }
        Setting.count = selectorMaxCount;
        return this;
    }

    public AlbumBuilder setUseWidth(boolean useWidth) {
        Setting.useWidth = useWidth;
        return this;
    }

    public AlbumBuilder complexSelector(boolean singleType, int videoCount, int pictureCount) {
        Setting.complexSelector = true;
        Setting.complexSingleType = singleType;
        Setting.complexVideoCount = videoCount;
        Setting.complexPictureCount = pictureCount;
        Setting.count = videoCount + pictureCount;
        Setting.showVideo = true;
        return this;
    }

    public AlbumBuilder setCameraLocation(int cLocation) {
        Setting.cameraLocation = cLocation;
        return this;
    }

    public AlbumBuilder setMinFileSize(long minFileSize) {
        Setting.minSize = minFileSize;
        return this;
    }

    public AlbumBuilder setMinWidth(int minWidth) {
        Setting.minWidth = minWidth;
        return this;
    }

    public AlbumBuilder setMinHeight(int minHeight) {
        Setting.minHeight = minHeight;
        return this;
    }

    public AlbumBuilder setSelectedPhotos(ArrayList<Photo> selectedPhotos) {
        Setting.selectedPhotos.clear();
        if (selectedPhotos.isEmpty()) {
            return this;
        }
        Setting.selectedPhotos.addAll(selectedPhotos);
        Setting.selectedOriginal = selectedPhotos.get((int)0).selectedOriginal;
        return this;
    }

    @Deprecated
    public AlbumBuilder setSelectedPhotoPaths(ArrayList<String> selectedPhotoPaths) {
        Setting.selectedPhotos.clear();
        ArrayList<Photo> selectedPhotos = new ArrayList<Photo>();
        for (String path : selectedPhotoPaths) {
            File file = new File(path);
            Uri uri = null;
            if (null != this.mActivity && null != this.mActivity.get()) {
                uri = UriUtils.getUri((Context)this.mActivity.get(), file);
            }
            if (null != this.mFragment && null != this.mFragment.get()) {
                uri = UriUtils.getUri((Context)((Fragment)this.mFragment.get()).getActivity(), file);
            }
            if (null != this.mFragmentV && null != this.mFragmentV.get()) {
                uri = UriUtils.getUri((Context)((androidx.fragment.app.Fragment)this.mFragmentV.get()).getActivity(), file);
            }
            if (uri == null) {
                uri = Uri.fromFile((File)file);
            }
            Photo photo = new Photo(null, uri, path, 0L, 0, 0, 0, 0L, 0L, null);
            selectedPhotos.add(photo);
        }
        Setting.selectedPhotos.addAll(selectedPhotos);
        return this;
    }

    public AlbumBuilder setOriginalMenu(boolean isChecked, boolean usable, String unusableHint) {
        Setting.showOriginalMenu = true;
        Setting.selectedOriginal = isChecked;
        Setting.originalMenuUsable = usable;
        Setting.originalMenuUnusableHint = unusableHint;
        return this;
    }

    public AlbumBuilder setPuzzleMenu(boolean shouldShow) {
        Setting.showPuzzleMenu = shouldShow;
        return this;
    }

    public AlbumBuilder onlyVideo() {
        return this.filter("video");
    }

    public AlbumBuilder filter(String ... types) {
        Setting.filterTypes = Arrays.asList(types);
        return this;
    }

    public AlbumBuilder setGif(boolean shouldShow) {
        Setting.showGif = shouldShow;
        return this;
    }

    public AlbumBuilder setVideo(boolean shouldShow) {
        Setting.showVideo = shouldShow;
        return this;
    }

    public AlbumBuilder setVideoMinSecond(int second) {
        Setting.videoMinSecond = second * 1000;
        return this;
    }

    public AlbumBuilder setVideoMaxSecond(int second) {
        Setting.videoMaxSecond = second * 1000;
        return this;
    }

    public AlbumBuilder setCleanMenu(boolean shouldShow) {
        Setting.showCleanMenu = shouldShow;
        return this;
    }

    private void setSettingParams() {
        switch (this.startupType) {
            case CAMERA: {
                Setting.onlyStartCamera = true;
                Setting.isShowCamera = true;
                break;
            }
            case ALBUM: {
                Setting.isShowCamera = false;
                break;
            }
            case ALBUM_CAMERA: {
                Setting.isShowCamera = true;
            }
        }
        if (!Setting.filterTypes.isEmpty()) {
            if (Setting.isFilter("gif")) {
                Setting.showGif = true;
            }
            if (Setting.isFilter("video")) {
                Setting.showVideo = true;
            }
        }
        if (Setting.isOnlyVideo()) {
            Setting.isShowCamera = false;
            Setting.showPuzzleMenu = false;
            Setting.showGif = false;
            Setting.showVideo = true;
        }
    }

    public void start(int requestCode) {
        this.setSettingParams();
        this.launchEasyPhotosActivity(requestCode);
    }

    public void start(SelectCallback callback) {
        this.setSettingParams();
        if (null != this.mActivity && null != this.mActivity.get() && this.mActivity.get() instanceof FragmentActivity) {
            EasyResult.get((FragmentActivity)this.mActivity.get()).startEasyPhoto(callback);
            return;
        }
        if (null != this.mFragmentV && null != this.mFragmentV.get()) {
            EasyResult.get((androidx.fragment.app.Fragment)this.mFragmentV.get()).startEasyPhoto(callback);
            return;
        }
        throw new RuntimeException("mActivity or mFragmentV maybe null, you can not use this method... ");
    }

    private void launchEasyPhotosActivity(int requestCode) {
        if (null != this.mActivity && null != this.mActivity.get()) {
            EasyPhotosActivity.start((Activity)this.mActivity.get(), requestCode);
            return;
        }
        if (null != this.mFragment && null != this.mFragment.get()) {
            EasyPhotosActivity.start((Fragment)this.mFragment.get(), requestCode);
            return;
        }
        if (null != this.mFragmentV && null != this.mFragmentV.get()) {
            EasyPhotosActivity.start((androidx.fragment.app.Fragment)this.mFragmentV.get(), requestCode);
        }
    }

    private static void clear() {
        Result.clear();
        Setting.clear();
        instance = null;
    }

    public AlbumBuilder setAdView(View photosAdView, boolean photosAdIsLoaded, View albumItemsAdView, boolean albumItemsAdIsLoaded) {
        Setting.photosAdView = new WeakReference<View>(photosAdView);
        Setting.albumItemsAdView = new WeakReference<View>(albumItemsAdView);
        Setting.photoAdIsOk = photosAdIsLoaded;
        Setting.albumItemsAdIsOk = albumItemsAdIsLoaded;
        return this;
    }

    public static void setAdListener(AdListener adListener) {
        if (null == instance) {
            return;
        }
        if (AlbumBuilder.instance.startupType == StartupType.CAMERA) {
            return;
        }
        AlbumBuilder.instance.adListener = new WeakReference<AdListener>(adListener);
    }

    public static void notifyPhotosAdLoaded() {
        if (Setting.photoAdIsOk) {
            return;
        }
        if (null == instance) {
            return;
        }
        if (AlbumBuilder.instance.startupType == StartupType.CAMERA) {
            return;
        }
        if (null == AlbumBuilder.instance.adListener) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (null != instance && null != instance.adListener) {
                        Setting.photoAdIsOk = true;
                        ((AdListener)instance.adListener.get()).onPhotosAdLoaded();
                    }
                }
            }).start();
            return;
        }
        Setting.photoAdIsOk = true;
        ((AdListener)AlbumBuilder.instance.adListener.get()).onPhotosAdLoaded();
    }

    public static void notifyAlbumItemsAdLoaded() {
        if (Setting.albumItemsAdIsOk) {
            return;
        }
        if (null == instance) {
            return;
        }
        if (AlbumBuilder.instance.startupType == StartupType.CAMERA) {
            return;
        }
        if (null == AlbumBuilder.instance.adListener) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (null != instance && null != instance.adListener) {
                        Setting.albumItemsAdIsOk = true;
                        ((AdListener)instance.adListener.get()).onAlbumItemsAdLoaded();
                    }
                }
            }).start();
            return;
        }
        Setting.albumItemsAdIsOk = true;
        ((AdListener)AlbumBuilder.instance.adListener.get()).onAlbumItemsAdLoaded();
    }

    private static enum StartupType {
        CAMERA,
        ALBUM,
        ALBUM_CAMERA;

    }
}

