/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.models.puzzle.slant;

import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import com.huantansheng.easyphotos.models.puzzle.Area;
import com.huantansheng.easyphotos.models.puzzle.Line;
import com.huantansheng.easyphotos.models.puzzle.slant.CrossoverPointF;
import com.huantansheng.easyphotos.models.puzzle.slant.SlantLine;
import com.huantansheng.easyphotos.models.puzzle.slant.SlantUtils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

class SlantArea
implements Area {
    SlantLine lineLeft;
    SlantLine lineTop;
    SlantLine lineRight;
    SlantLine lineBottom;
    CrossoverPointF leftTop;
    CrossoverPointF leftBottom;
    CrossoverPointF rightTop;
    CrossoverPointF rightBottom;
    private PointF tempPoint;
    private float paddingLeft;
    private float paddingTop;
    private float paddingRight;
    private float paddingBottom;
    private float radian;
    private Path areaPath = new Path();
    private RectF areaRect = new RectF();
    private PointF[] handleBarPoints = new PointF[2];

    SlantArea() {
        this.handleBarPoints[0] = new PointF();
        this.handleBarPoints[1] = new PointF();
        this.leftTop = new CrossoverPointF();
        this.leftBottom = new CrossoverPointF();
        this.rightTop = new CrossoverPointF();
        this.rightBottom = new CrossoverPointF();
        this.tempPoint = new PointF();
    }

    SlantArea(SlantArea src) {
        this();
        this.lineLeft = src.lineLeft;
        this.lineTop = src.lineTop;
        this.lineRight = src.lineRight;
        this.lineBottom = src.lineBottom;
        this.leftTop = src.leftTop;
        this.leftBottom = src.leftBottom;
        this.rightTop = src.rightTop;
        this.rightBottom = src.rightBottom;
        this.updateCornerPoints();
    }

    @Override
    public float left() {
        return Math.min(this.leftTop.x, this.leftBottom.x) + this.paddingLeft;
    }

    @Override
    public float top() {
        return Math.min(this.leftTop.y, this.rightTop.y) + this.paddingTop;
    }

    @Override
    public float right() {
        return Math.max(this.rightTop.x, this.rightBottom.x) - this.paddingRight;
    }

    @Override
    public float bottom() {
        return Math.max(this.leftBottom.y, this.rightBottom.y) - this.paddingBottom;
    }

    @Override
    public float centerX() {
        return (this.left() + this.right()) / 2.0f;
    }

    @Override
    public float centerY() {
        return (this.top() + this.bottom()) / 2.0f;
    }

    @Override
    public float width() {
        return this.right() - this.left();
    }

    @Override
    public float height() {
        return this.bottom() - this.top();
    }

    @Override
    public PointF getCenterPoint() {
        return new PointF(this.centerX(), this.centerY());
    }

    @Override
    public Path getAreaPath() {
        this.areaPath.reset();
        if (this.radian > 0.0f) {
            float tempRatio = this.radian / SlantUtils.distance(this.leftTop, this.leftBottom);
            SlantUtils.getPoint(this.tempPoint, this.leftTop, this.leftBottom, Line.Direction.VERTICAL, tempRatio);
            this.tempPoint.offset(this.paddingLeft, this.paddingTop);
            this.areaPath.moveTo(this.tempPoint.x, this.tempPoint.y);
            tempRatio = this.radian / SlantUtils.distance(this.leftTop, this.rightTop);
            SlantUtils.getPoint(this.tempPoint, this.leftTop, this.rightTop, Line.Direction.HORIZONTAL, tempRatio);
            this.tempPoint.offset(this.paddingLeft, this.paddingTop);
            this.areaPath.quadTo(this.leftTop.x + this.paddingLeft, this.leftTop.y + this.paddingTop, this.tempPoint.x, this.tempPoint.y);
            tempRatio = 1.0f - tempRatio;
            SlantUtils.getPoint(this.tempPoint, this.leftTop, this.rightTop, Line.Direction.HORIZONTAL, tempRatio);
            this.tempPoint.offset(-this.paddingRight, this.paddingTop);
            this.areaPath.lineTo(this.tempPoint.x, this.tempPoint.y);
            tempRatio = this.radian / SlantUtils.distance(this.rightTop, this.rightBottom);
            SlantUtils.getPoint(this.tempPoint, this.rightTop, this.rightBottom, Line.Direction.VERTICAL, tempRatio);
            this.tempPoint.offset(-this.paddingRight, this.paddingTop);
            this.areaPath.quadTo(this.rightTop.x - this.paddingLeft, this.rightTop.y + this.paddingTop, this.tempPoint.x, this.tempPoint.y);
            tempRatio = 1.0f - tempRatio;
            SlantUtils.getPoint(this.tempPoint, this.rightTop, this.rightBottom, Line.Direction.VERTICAL, tempRatio);
            this.tempPoint.offset(-this.paddingRight, -this.paddingBottom);
            this.areaPath.lineTo(this.tempPoint.x, this.tempPoint.y);
            tempRatio = 1.0f - this.radian / SlantUtils.distance(this.leftBottom, this.rightBottom);
            SlantUtils.getPoint(this.tempPoint, this.leftBottom, this.rightBottom, Line.Direction.HORIZONTAL, tempRatio);
            this.tempPoint.offset(-this.paddingRight, -this.paddingBottom);
            this.areaPath.quadTo(this.rightBottom.x - this.paddingRight, this.rightBottom.y - this.paddingTop, this.tempPoint.x, this.tempPoint.y);
            tempRatio = 1.0f - tempRatio;
            SlantUtils.getPoint(this.tempPoint, this.leftBottom, this.rightBottom, Line.Direction.HORIZONTAL, tempRatio);
            this.tempPoint.offset(this.paddingLeft, -this.paddingBottom);
            this.areaPath.lineTo(this.tempPoint.x, this.tempPoint.y);
            tempRatio = 1.0f - this.radian / SlantUtils.distance(this.leftTop, this.leftBottom);
            SlantUtils.getPoint(this.tempPoint, this.leftTop, this.leftBottom, Line.Direction.VERTICAL, tempRatio);
            this.tempPoint.offset(this.paddingLeft, -this.paddingBottom);
            this.areaPath.quadTo(this.leftBottom.x + this.paddingLeft, this.leftBottom.y - this.paddingBottom, this.tempPoint.x, this.tempPoint.y);
            tempRatio = 1.0f - tempRatio;
            SlantUtils.getPoint(this.tempPoint, this.leftTop, this.leftBottom, Line.Direction.VERTICAL, tempRatio);
            this.tempPoint.offset(this.paddingLeft, this.paddingTop);
            this.areaPath.lineTo(this.tempPoint.x, this.tempPoint.y);
        } else {
            this.areaPath.moveTo(this.leftTop.x + this.paddingLeft, this.leftTop.y + this.paddingTop);
            this.areaPath.lineTo(this.rightTop.x - this.paddingRight, this.rightTop.y + this.paddingTop);
            this.areaPath.lineTo(this.rightBottom.x - this.paddingRight, this.rightBottom.y - this.paddingBottom);
            this.areaPath.lineTo(this.leftBottom.x + this.paddingLeft, this.leftBottom.y - this.paddingBottom);
            this.areaPath.lineTo(this.leftTop.x + this.paddingLeft, this.leftTop.y + this.paddingTop);
        }
        return this.areaPath;
    }

    @Override
    public RectF getAreaRect() {
        this.areaRect.set(this.left(), this.top(), this.right(), this.bottom());
        return this.areaRect;
    }

    @Override
    public boolean contains(float x, float y) {
        return SlantUtils.contains(this, x, y);
    }

    @Override
    public boolean contains(Line line) {
        return this.lineLeft == line || this.lineTop == line || this.lineRight == line || this.lineBottom == line;
    }

    @Override
    public boolean contains(PointF point) {
        return this.contains(point.x, point.y);
    }

    @Override
    public List<Line> getLines() {
        return Arrays.asList(this.lineLeft, this.lineTop, this.lineRight, this.lineBottom);
    }

    @Override
    public PointF[] getHandleBarPoints(Line line) {
        if (line == this.lineLeft) {
            SlantUtils.getPoint(this.handleBarPoints[0], this.leftTop, this.leftBottom, line.direction(), 0.25f);
            SlantUtils.getPoint(this.handleBarPoints[1], this.leftTop, this.leftBottom, line.direction(), 0.75f);
            this.handleBarPoints[0].offset(this.paddingLeft, 0.0f);
            this.handleBarPoints[1].offset(this.paddingLeft, 0.0f);
        } else if (line == this.lineTop) {
            SlantUtils.getPoint(this.handleBarPoints[0], this.leftTop, this.rightTop, line.direction(), 0.25f);
            SlantUtils.getPoint(this.handleBarPoints[1], this.leftTop, this.rightTop, line.direction(), 0.75f);
            this.handleBarPoints[0].offset(0.0f, this.paddingTop);
            this.handleBarPoints[1].offset(0.0f, this.paddingTop);
        } else if (line == this.lineRight) {
            SlantUtils.getPoint(this.handleBarPoints[0], this.rightTop, this.rightBottom, line.direction(), 0.25f);
            SlantUtils.getPoint(this.handleBarPoints[1], this.rightTop, this.rightBottom, line.direction(), 0.75f);
            this.handleBarPoints[0].offset(-this.paddingRight, 0.0f);
            this.handleBarPoints[1].offset(-this.paddingRight, 0.0f);
        } else if (line == this.lineBottom) {
            SlantUtils.getPoint(this.handleBarPoints[0], this.leftBottom, this.rightBottom, line.direction(), 0.25f);
            SlantUtils.getPoint(this.handleBarPoints[1], this.leftBottom, this.rightBottom, line.direction(), 0.75f);
            this.handleBarPoints[0].offset(0.0f, -this.paddingBottom);
            this.handleBarPoints[1].offset(0.0f, -this.paddingBottom);
        }
        return this.handleBarPoints;
    }

    @Override
    public float radian() {
        return this.radian;
    }

    @Override
    public void setRadian(float radian) {
        this.radian = radian;
    }

    @Override
    public float getPaddingLeft() {
        return this.paddingLeft;
    }

    @Override
    public float getPaddingTop() {
        return this.paddingTop;
    }

    @Override
    public float getPaddingRight() {
        return this.paddingRight;
    }

    @Override
    public float getPaddingBottom() {
        return this.paddingBottom;
    }

    @Override
    public void setPadding(float padding) {
        this.setPadding(padding, padding, padding, padding);
    }

    @Override
    public void setPadding(float paddingLeft, float paddingTop, float paddingRight, float paddingBottom) {
        this.paddingLeft = paddingLeft;
        this.paddingTop = paddingTop;
        this.paddingRight = paddingRight;
        this.paddingBottom = paddingBottom;
    }

    void updateCornerPoints() {
        SlantUtils.intersectionOfLines(this.leftTop, this.lineLeft, this.lineTop);
        SlantUtils.intersectionOfLines(this.leftBottom, this.lineLeft, this.lineBottom);
        SlantUtils.intersectionOfLines(this.rightTop, this.lineRight, this.lineTop);
        SlantUtils.intersectionOfLines(this.rightBottom, this.lineRight, this.lineBottom);
    }

    static class AreaComparator
    implements Comparator<SlantArea> {
        AreaComparator() {
        }

        @Override
        public int compare(SlantArea one, SlantArea two) {
            if (one.leftTop.y < two.leftTop.y) {
                return -1;
            }
            if (one.leftTop.y == two.leftTop.y) {
                if (one.leftTop.x < two.leftTop.x) {
                    return -1;
                }
                return 1;
            }
            return 1;
        }
    }
}

