/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.ui.adapter;

import android.content.Context;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.result.Result;
import com.huantansheng.easyphotos.setting.Setting;
import com.huantansheng.easyphotos.ui.widget.PressedImageView;
import com.huantansheng.easyphotos.utils.media.DurationUtils;

public class PreviewPhotosFragmentAdapter
extends RecyclerView.Adapter<PreviewPhotoVH> {
    private LayoutInflater inflater;
    private OnClickListener listener;
    private int checkedPosition = -1;

    public PreviewPhotosFragmentAdapter(Context context, OnClickListener listener) {
        this.inflater = LayoutInflater.from((Context)context);
        this.listener = listener;
    }

    public PreviewPhotoVH onCreateViewHolder(ViewGroup parent, int viewType) {
        return new PreviewPhotoVH(this.inflater.inflate(R.layout.item_preview_selected_photos_easy_photos, parent, false));
    }

    public void onBindViewHolder(PreviewPhotoVH holder, int position) {
        boolean isGif;
        final int p = position;
        String path = Result.getPhotoPath(position);
        String type = Result.getPhotoType(position);
        Uri uri = Result.getPhotoUri(position);
        long duration = Result.getPhotoDuration(position);
        boolean bl = isGif = path.endsWith("gif") || type.endsWith("gif");
        if (Setting.showGif && isGif) {
            Setting.imageEngine.loadGifAsBitmap(holder.ivPhoto.getContext(), uri, (ImageView)holder.ivPhoto);
            holder.tvType.setText(R.string.gif_easy_photos);
            holder.tvType.setVisibility(0);
        } else if (Setting.showVideo && type.contains("video")) {
            Setting.imageEngine.loadPhoto(holder.ivPhoto.getContext(), uri, (ImageView)holder.ivPhoto);
            holder.tvType.setText((CharSequence)DurationUtils.format(duration));
            holder.tvType.setVisibility(0);
        } else {
            Setting.imageEngine.loadPhoto(holder.ivPhoto.getContext(), uri, (ImageView)holder.ivPhoto);
            holder.tvType.setVisibility(8);
        }
        if (this.checkedPosition == p) {
            holder.frame.setVisibility(0);
        } else {
            holder.frame.setVisibility(8);
        }
        holder.ivPhoto.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PreviewPhotosFragmentAdapter.this.listener.onPhotoClick(p);
            }
        });
    }

    public int getItemCount() {
        return Result.count();
    }

    public void setChecked(int position) {
        if (this.checkedPosition == position) {
            return;
        }
        this.checkedPosition = position;
        this.notifyDataSetChanged();
    }

    public static interface OnClickListener {
        public void onPhotoClick(int var1);
    }

    class PreviewPhotoVH
    extends RecyclerView.ViewHolder {
        PressedImageView ivPhoto;
        View frame;
        TextView tvType;

        public PreviewPhotoVH(View itemView) {
            super(itemView);
            this.ivPhoto = (PressedImageView)itemView.findViewById(R.id.iv_photo);
            this.frame = itemView.findViewById(R.id.v_selector);
            this.tvType = (TextView)itemView.findViewById(R.id.tv_type);
        }
    }
}

