/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.sticker.StickerModel;
import com.huantansheng.easyphotos.models.sticker.entity.TextStickerData;
import java.util.ArrayList;
import java.util.List;

public class TextStickerAdapter
extends RecyclerView.Adapter<TextViewHolder> {
    private List<TextStickerData> datas;
    private OnItemClickListener onItemClickListener;

    public TextStickerAdapter(Context cxt, OnItemClickListener listener) {
        this.onItemClickListener = listener;
        this.datas = new ArrayList<TextStickerData>();
        TextStickerData data = new TextStickerData(cxt.getString(R.string.text_sticker_hint_name_easy_photos), cxt.getString(R.string.text_sticker_hint_easy_photos));
        this.datas.add(0, data);
        TextStickerData d = new TextStickerData(cxt.getString(R.string.text_sticker_date_easy_photos), "-1");
        this.datas.add(d);
        this.datas.addAll(StickerModel.textDataList);
    }

    public TextViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_text_sticker_easy_photos, parent, false);
        return new TextViewHolder(itemView);
    }

    public void onBindViewHolder(TextViewHolder holder, int position) {
        final TextStickerData data = this.datas.get(position);
        holder.tvSticker.setText((CharSequence)data.stickerName);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TextStickerAdapter.this.onItemClickListener != null) {
                    TextStickerAdapter.this.onItemClickListener.onItemClick(data.stickerValue);
                    TextStickerAdapter.this.notifyDataSetChanged();
                }
            }
        });
    }

    public int getItemCount() {
        return this.datas == null ? 0 : this.datas.size();
    }

    public static interface OnItemClickListener {
        public void onItemClick(String var1);
    }

    public static class TextViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvSticker;

        public TextViewHolder(View itemView) {
            super(itemView);
            this.tvSticker = (TextView)itemView.findViewById(R.id.puzzle);
        }
    }
}

