/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.models.album;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.album.entity.Album;
import com.huantansheng.easyphotos.models.album.entity.AlbumItem;
import com.huantansheng.easyphotos.models.album.entity.Photo;
import com.huantansheng.easyphotos.result.Result;
import com.huantansheng.easyphotos.setting.Setting;
import com.huantansheng.easyphotos.utils.String.StringUtils;
import java.io.File;
import java.util.ArrayList;

public class AlbumModel {
    private static final String TAG = "AlbumModel";
    public static AlbumModel instance;
    public Album album = new Album();
    public boolean canRun = true;

    private AlbumModel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AlbumModel getInstance() {
        if (null != instance) return instance;
        Class<AlbumModel> clazz = AlbumModel.class;
        synchronized (AlbumModel.class) {
            if (null != instance) return instance;
            instance = new AlbumModel();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void query(final Context context, final CallBack callBack) {
        this.canRun = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                AlbumModel.this.album.clear();
                AlbumModel.this.initAlbum(context);
                if (null != callBack) {
                    callBack.onAlbumWorkedCallBack();
                }
            }
        }).start();
    }

    public void stopQuery() {
        this.canRun = false;
    }

    private void initAlbum(Context context) {
        String[] projections;
        if (Setting.selectedPhotos.size() > Setting.count) {
            throw new RuntimeException("AlbumBuilder: \u9ed8\u8ba4\u52fe\u9009\u7684\u56fe\u7247\u5f20\u6570\u4e0d\u80fd\u5927\u4e8e\u8bbe\u7f6e\u7684\u9009\u62e9\u6570\uff01|\u9ed8\u8ba4\u52fe\u9009\u5f20\u6570\uff1a" + Setting.selectedPhotos.size() + "|\u8bbe\u7f6e\u7684\u9009\u62e9\u6570\uff1a" + Setting.count);
        }
        Uri contentUri = MediaStore.Files.getContentUri((String)"external");
        String sortOrder = "date_modified DESC";
        String selection = "(media_type=? OR media_type=?) AND _size>0";
        String[] selectionAllArgs = new String[]{String.valueOf(1), String.valueOf(3)};
        ContentResolver contentResolver = context.getContentResolver();
        Cursor cursor = contentResolver.query(contentUri, projections = Build.VERSION.SDK_INT >= 16 ? new String[]{"_id", "_data", "_display_name", "date_modified", "mime_type", "width", "height", "_size", "duration"} : new String[]{"_id", "_data", "_display_name", "date_modified", "mime_type", "_size", "duration"}, "(media_type=? OR media_type=?) AND _size>0", selectionAllArgs, "date_modified DESC");
        if (cursor != null && cursor.moveToFirst()) {
            String albumItem_all_name = this.getAllAlbumName(context);
            String albumItem_video_name = context.getString(R.string.selector_folder_video_easy_photos);
            int idCol = cursor.getColumnIndex("_id");
            int pathCol = cursor.getColumnIndex("_data");
            int nameCol = cursor.getColumnIndex("_display_name");
            int DateCol = cursor.getColumnIndex("date_modified");
            int mimeType = cursor.getColumnIndex("mime_type");
            int sizeCol = cursor.getColumnIndex("_size");
            int durationCol = cursor.getColumnIndex("duration");
            int WidthCol = 0;
            int HeightCol = 0;
            if (Build.VERSION.SDK_INT >= 16) {
                WidthCol = cursor.getColumnIndex("width");
                HeightCol = cursor.getColumnIndex("height");
            }
            do {
                File parentFile;
                File file;
                String id2 = cursor.getString(idCol);
                Uri uri = Uri.withAppendedPath((Uri)MediaStore.Images.Media.EXTERNAL_CONTENT_URI, (String)id2);
                String path = cursor.getString(pathCol);
                String name = cursor.getString(nameCol);
                long dateTime = cursor.getLong(DateCol);
                String type = cursor.getString(mimeType);
                long size = cursor.getLong(sizeCol);
                long duration = cursor.getLong(durationCol);
                int width = 0;
                int height = 0;
                if (TextUtils.isEmpty((CharSequence)path) || TextUtils.isEmpty((CharSequence)type)) continue;
                boolean isVideo = type.contains("video");
                if (Setting.isOnlyVideo() && !isVideo || !Setting.filterTypes.isEmpty() && !Setting.isFilter(type) || !Setting.showGif && (path.endsWith("gif") || type.endsWith("gif")) || !Setting.showVideo && isVideo || size < Setting.minSize || isVideo && (duration <= Setting.videoMinSecond || duration >= Setting.videoMaxSecond)) continue;
                if (!isVideo && Build.VERSION.SDK_INT >= 16) {
                    width = cursor.getInt(WidthCol);
                    height = cursor.getInt(HeightCol);
                    if (width < Setting.minWidth || height < Setting.minHeight) continue;
                }
                if (!(file = new File(path)).exists() || !file.isFile()) continue;
                Photo imageItem = new Photo(name, uri, path, dateTime, width, height, size, duration, type);
                if (!Setting.selectedPhotos.isEmpty()) {
                    for (Photo selectedPhoto : Setting.selectedPhotos) {
                        if (!path.equals(selectedPhoto.path)) continue;
                        imageItem.selectedOriginal = Setting.selectedOriginal;
                        Result.addPhoto(imageItem);
                    }
                }
                if (this.album.isEmpty()) {
                    this.album.addAlbumItem(albumItem_all_name, "", path, uri);
                }
                this.album.getAlbumItem(albumItem_all_name).addImageItem(imageItem);
                if (Setting.showVideo && isVideo && !albumItem_video_name.equals(albumItem_all_name)) {
                    this.album.addAlbumItem(albumItem_video_name, "", path, uri);
                    this.album.getAlbumItem(albumItem_video_name).addImageItem(imageItem);
                }
                if (null == (parentFile = new File(path).getParentFile())) continue;
                String folderPath = parentFile.getAbsolutePath();
                String albumName = StringUtils.getLastPathSegment(folderPath);
                this.album.addAlbumItem(albumName, folderPath, path, uri);
                this.album.getAlbumItem(albumName).addImageItem(imageItem);
            } while (cursor.moveToNext() && this.canRun);
            cursor.close();
        }
    }

    public String getAllAlbumName(Context context) {
        String albumItem_all_name = context.getString(R.string.selector_folder_all_video_photo_easy_photos);
        if (Setting.isOnlyVideo()) {
            albumItem_all_name = context.getString(R.string.selector_folder_video_easy_photos);
        } else if (!Setting.showVideo) {
            albumItem_all_name = context.getString(R.string.selector_folder_all_easy_photos);
        }
        return albumItem_all_name;
    }

    public ArrayList<Photo> getCurrAlbumItemPhotos(int currAlbumItemIndex) {
        return this.album.getAlbumItem((int)currAlbumItemIndex).photos;
    }

    public ArrayList<AlbumItem> getAlbumItems() {
        return this.album.albumItems;
    }

    public static interface CallBack {
        public void onAlbumWorkedCallBack();
    }
}

