/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.ui;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.snackbar.Snackbar;
import com.huantansheng.easyphotos.EasyPhotos;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.engine.ImageEngine;
import com.huantansheng.easyphotos.models.album.entity.Photo;
import com.huantansheng.easyphotos.models.puzzle.Area;
import com.huantansheng.easyphotos.models.puzzle.DegreeSeekBar;
import com.huantansheng.easyphotos.models.puzzle.PuzzleLayout;
import com.huantansheng.easyphotos.models.puzzle.PuzzlePiece;
import com.huantansheng.easyphotos.models.puzzle.PuzzleUtils;
import com.huantansheng.easyphotos.models.puzzle.PuzzleView;
import com.huantansheng.easyphotos.models.sticker.StickerModel;
import com.huantansheng.easyphotos.setting.Setting;
import com.huantansheng.easyphotos.ui.adapter.PuzzleAdapter;
import com.huantansheng.easyphotos.ui.adapter.TextStickerAdapter;
import com.huantansheng.easyphotos.utils.bitmap.SaveBitmapCallBack;
import com.huantansheng.easyphotos.utils.media.DurationUtils;
import com.huantansheng.easyphotos.utils.permission.PermissionUtil;
import com.huantansheng.easyphotos.utils.settings.SettingsUtils;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class PuzzleActivity
extends AppCompatActivity
implements View.OnClickListener,
PuzzleAdapter.OnItemClickListener,
TextStickerAdapter.OnItemClickListener {
    private static WeakReference<Class<? extends Activity>> toClass;
    ArrayList<Photo> photos = null;
    ArrayList<String> paths = null;
    ArrayList<Bitmap> bitmaps = new ArrayList();
    boolean fileTypeIsPhoto;
    String saveDirPath;
    String saveNamePrefix;
    private PuzzleView puzzleView;
    private RecyclerView rvPuzzleTemplet;
    private PuzzleAdapter puzzleAdapter;
    private ProgressBar progressBar;
    private int fileCount = 0;
    private LinearLayout llMenu;
    private DegreeSeekBar degreeSeekBar;
    private ArrayList<ImageView> ivMenus = new ArrayList();
    private ArrayList<Integer> degrees = new ArrayList();
    private int degreeIndex = -1;
    private int controlFlag;
    private static final int FLAG_CONTROL_PADDING = 0;
    private static final int FLAG_CONTROL_CORNER = 1;
    private static final int FLAG_CONTROL_ROTATE = 2;
    private int deviceWidth = 0;
    private int deviceHeight = 0;
    private TextView tvTemplate;
    private TextView tvTextSticker;
    private RelativeLayout mRootView;
    private RelativeLayout mBottomLayout;
    private TextStickerAdapter textStickerAdapter;
    private StickerModel stickerModel;
    FloatingActionButton fab;

    public static void startWithPhotos(Activity act, ArrayList<Photo> photos, String puzzleSaveDirPath, String puzzleSaveNamePrefix, int requestCode, boolean replaceCustom, @NonNull ImageEngine imageEngine) {
        if (null != toClass) {
            toClass.clear();
            toClass = null;
        }
        if (Setting.imageEngine != imageEngine) {
            Setting.imageEngine = imageEngine;
        }
        Intent intent = new Intent((Context)act, PuzzleActivity.class);
        intent.putExtra("keyOfPuzzleFilesTypeIsPhoto", true);
        intent.putParcelableArrayListExtra("keyOfPuzzleFiles", photos);
        intent.putExtra("keyOfPuzzleSaveDir", puzzleSaveDirPath);
        intent.putExtra("keyOfPuzzleSaveNamePrefix", puzzleSaveNamePrefix);
        if (replaceCustom) {
            toClass = new WeakReference(act.getClass());
        }
        act.startActivityForResult(intent, requestCode);
    }

    public static void startWithPhotos(Fragment fragment, ArrayList<Photo> photos, String puzzleSaveDirPath, String puzzleSaveNamePrefix, int requestCode, boolean replaceCustom, @NonNull ImageEngine imageEngine) {
        if (null != toClass) {
            toClass.clear();
            toClass = null;
        }
        if (Setting.imageEngine != imageEngine) {
            Setting.imageEngine = imageEngine;
        }
        Intent intent = new Intent((Context)fragment.getActivity(), PuzzleActivity.class);
        intent.putExtra("keyOfPuzzleFilesTypeIsPhoto", true);
        intent.putParcelableArrayListExtra("keyOfPuzzleFiles", photos);
        intent.putExtra("keyOfPuzzleSaveDir", puzzleSaveDirPath);
        intent.putExtra("keyOfPuzzleSaveNamePrefix", puzzleSaveNamePrefix);
        if (replaceCustom) {
            toClass = new WeakReference(fragment.getActivity().getClass());
        }
        fragment.startActivityForResult(intent, requestCode);
    }

    public static void startWithPhotos(androidx.fragment.app.Fragment fragmentV, ArrayList<Photo> photos, String puzzleSaveDirPath, String puzzleSaveNamePrefix, int requestCode, boolean replaceCustom, @NonNull ImageEngine imageEngine) {
        if (null != toClass) {
            toClass.clear();
            toClass = null;
        }
        if (Setting.imageEngine != imageEngine) {
            Setting.imageEngine = imageEngine;
        }
        Intent intent = new Intent((Context)fragmentV.getActivity(), PuzzleActivity.class);
        intent.putExtra("keyOfPuzzleFilesTypeIsPhoto", true);
        intent.putParcelableArrayListExtra("keyOfPuzzleFiles", photos);
        intent.putExtra("keyOfPuzzleSaveDir", puzzleSaveDirPath);
        intent.putExtra("keyOfPuzzleSaveNamePrefix", puzzleSaveNamePrefix);
        if (replaceCustom && fragmentV.getActivity() != null) {
            toClass = new WeakReference(fragmentV.getActivity().getClass());
        }
        fragmentV.startActivityForResult(intent, requestCode);
    }

    public static void startWithPaths(Activity act, ArrayList<String> paths, String puzzleSaveDirPath, String puzzleSaveNamePrefix, int requestCode, boolean replaceCustom, @NonNull ImageEngine imageEngine) {
        if (null != toClass) {
            toClass.clear();
            toClass = null;
        }
        if (Setting.imageEngine != imageEngine) {
            Setting.imageEngine = imageEngine;
        }
        Intent intent = new Intent((Context)act, PuzzleActivity.class);
        intent.putExtra("keyOfPuzzleFilesTypeIsPhoto", false);
        intent.putStringArrayListExtra("keyOfPuzzleFiles", paths);
        intent.putExtra("keyOfPuzzleSaveDir", puzzleSaveDirPath);
        intent.putExtra("keyOfPuzzleSaveNamePrefix", puzzleSaveNamePrefix);
        if (replaceCustom) {
            toClass = new WeakReference(act.getClass());
        }
        act.startActivityForResult(intent, requestCode);
    }

    public static void startWithPaths(Fragment fragment, ArrayList<String> paths, String puzzleSaveDirPath, String puzzleSaveNamePrefix, int requestCode, boolean replaceCustom, @NonNull ImageEngine imageEngine) {
        if (null != toClass) {
            toClass.clear();
            toClass = null;
        }
        if (Setting.imageEngine != imageEngine) {
            Setting.imageEngine = imageEngine;
        }
        Intent intent = new Intent((Context)fragment.getActivity(), PuzzleActivity.class);
        intent.putExtra("keyOfPuzzleFilesTypeIsPhoto", false);
        intent.putStringArrayListExtra("keyOfPuzzleFiles", paths);
        intent.putExtra("keyOfPuzzleSaveDir", puzzleSaveDirPath);
        intent.putExtra("keyOfPuzzleSaveNamePrefix", puzzleSaveNamePrefix);
        if (replaceCustom) {
            toClass = new WeakReference(fragment.getActivity().getClass());
        }
        fragment.startActivityForResult(intent, requestCode);
    }

    public static void startWithPaths(androidx.fragment.app.Fragment fragmentV, ArrayList<String> paths, String puzzleSaveDirPath, String puzzleSaveNamePrefix, int requestCode, boolean replaceCustom, @NonNull ImageEngine imageEngine) {
        if (null != toClass) {
            toClass.clear();
            toClass = null;
        }
        if (Setting.imageEngine != imageEngine) {
            Setting.imageEngine = imageEngine;
        }
        Intent intent = new Intent((Context)fragmentV.getActivity(), PuzzleActivity.class);
        intent.putExtra("keyOfPuzzleFilesTypeIsPhoto", false);
        intent.putStringArrayListExtra("keyOfPuzzleFiles", paths);
        intent.putExtra("keyOfPuzzleSaveDir", puzzleSaveDirPath);
        intent.putExtra("keyOfPuzzleSaveNamePrefix", puzzleSaveNamePrefix);
        if (replaceCustom && null != fragmentV.getActivity()) {
            toClass = new WeakReference(fragmentV.getActivity().getClass());
        }
        fragmentV.startActivityForResult(intent, requestCode);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        WindowManager.LayoutParams attrs = this.getWindow().getAttributes();
        attrs.flags |= 0x400;
        this.getWindow().setAttributes(attrs);
        this.setContentView(R.layout.activity_puzzle_easy_photos);
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.hide();
        }
        if (null == Setting.imageEngine) {
            this.finish();
            return;
        }
        this.initData();
        this.initView();
    }

    private void initView() {
        this.initIvMenu();
        this.initPuzzleView();
        this.initRecyclerView();
        this.progressBar = (ProgressBar)this.findViewById(R.id.progress);
        this.setClick(R.id.tv_back, R.id.tv_done);
    }

    private void initIvMenu() {
        this.fab = (FloatingActionButton)this.findViewById(R.id.fab);
        this.tvTemplate = (TextView)this.findViewById(R.id.tv_template);
        this.tvTextSticker = (TextView)this.findViewById(R.id.tv_text_sticker);
        this.mRootView = (RelativeLayout)this.findViewById(R.id.m_root_view);
        this.mBottomLayout = (RelativeLayout)this.findViewById(R.id.m_bottom_layout);
        this.llMenu = (LinearLayout)this.findViewById(R.id.ll_menu);
        ImageView ivRotate = (ImageView)this.findViewById(R.id.iv_rotate);
        ImageView ivCorner = (ImageView)this.findViewById(R.id.iv_corner);
        ImageView ivPadding = (ImageView)this.findViewById(R.id.iv_padding);
        this.setClick(R.id.iv_replace, R.id.iv_mirror, R.id.iv_flip);
        this.setClick(new View[]{ivRotate, ivCorner, ivPadding, this.fab, this.tvTextSticker, this.tvTemplate});
        this.ivMenus.add(ivRotate);
        this.ivMenus.add(ivCorner);
        this.ivMenus.add(ivPadding);
        this.degreeSeekBar = (DegreeSeekBar)this.findViewById(R.id.degree_seek_bar);
        this.degreeSeekBar.setScrollingListener(new DegreeSeekBar.ScrollingListener(){

            @Override
            public void onScrollStart() {
            }

            @Override
            public void onScroll(int currentDegrees) {
                switch (PuzzleActivity.this.controlFlag) {
                    case 0: {
                        PuzzleActivity.this.puzzleView.setPiecePadding(currentDegrees);
                        break;
                    }
                    case 1: {
                        if (currentDegrees < 0) {
                            currentDegrees = 0;
                        }
                        PuzzleActivity.this.puzzleView.setPieceRadian(currentDegrees);
                        break;
                    }
                    case 2: {
                        PuzzleActivity.this.puzzleView.rotate(currentDegrees - (Integer)PuzzleActivity.this.degrees.get(PuzzleActivity.this.degreeIndex));
                        PuzzleActivity.this.degrees.remove(PuzzleActivity.this.degreeIndex);
                        PuzzleActivity.this.degrees.add(PuzzleActivity.this.degreeIndex, currentDegrees);
                    }
                }
            }

            @Override
            public void onScrollEnd() {
            }
        });
    }

    private void initRecyclerView() {
        this.rvPuzzleTemplet = (RecyclerView)this.findViewById(R.id.rv_puzzle_template);
        this.puzzleAdapter = new PuzzleAdapter();
        this.puzzleAdapter.setOnItemClickListener(this);
        this.rvPuzzleTemplet.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 0, false));
        this.rvPuzzleTemplet.setAdapter((RecyclerView.Adapter)this.puzzleAdapter);
        this.puzzleAdapter.refreshData(PuzzleUtils.getPuzzleLayouts(this.fileCount));
        this.textStickerAdapter = new TextStickerAdapter((Context)this, this);
    }

    private void initPuzzleView() {
        int themeType = this.fileCount > 3 ? 1 : 0;
        this.puzzleView = (PuzzleView)this.findViewById(R.id.puzzle_view);
        this.puzzleView.setPuzzleLayout(PuzzleUtils.getPuzzleLayout(themeType, this.fileCount, 0));
        this.puzzleView.setOnPieceSelectedListener(new PuzzleView.OnPieceSelectedListener(){

            @Override
            public void onPieceSelected(PuzzlePiece piece, int position) {
                if (null == piece) {
                    PuzzleActivity.this.toggleIvMenu(R.id.iv_replace);
                    PuzzleActivity.this.llMenu.setVisibility(8);
                    PuzzleActivity.this.degreeSeekBar.setVisibility(8);
                    PuzzleActivity.this.degreeIndex = -1;
                    PuzzleActivity.this.controlFlag = -1;
                    return;
                }
                if (PuzzleActivity.this.degreeIndex != position) {
                    PuzzleActivity.this.controlFlag = -1;
                    PuzzleActivity.this.toggleIvMenu(R.id.iv_replace);
                    PuzzleActivity.this.degreeSeekBar.setVisibility(8);
                }
                PuzzleActivity.this.llMenu.setVisibility(0);
                PuzzleActivity.this.degreeIndex = position;
            }
        });
    }

    private void loadPhoto() {
        this.puzzleView.addPieces(this.bitmaps);
    }

    private void initData() {
        this.stickerModel = new StickerModel();
        this.deviceWidth = this.getResources().getDisplayMetrics().widthPixels;
        this.deviceHeight = this.getResources().getDisplayMetrics().heightPixels;
        Intent intent = this.getIntent();
        this.fileTypeIsPhoto = intent.getBooleanExtra("keyOfPuzzleFilesTypeIsPhoto", false);
        this.saveDirPath = intent.getStringExtra("keyOfPuzzleSaveDir");
        this.saveNamePrefix = intent.getStringExtra("keyOfPuzzleSaveNamePrefix");
        if (this.fileTypeIsPhoto) {
            this.photos = intent.getParcelableArrayListExtra("keyOfPuzzleFiles");
            this.fileCount = this.photos.size() > 9 ? 9 : this.photos.size();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < PuzzleActivity.this.fileCount; ++i) {
                        Bitmap bitmap = PuzzleActivity.this.getScaleBitmap(PuzzleActivity.this.photos.get((int)i).path);
                        PuzzleActivity.this.bitmaps.add(bitmap);
                        PuzzleActivity.this.degrees.add(0);
                    }
                    PuzzleActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            PuzzleActivity.this.puzzleView.post(new Runnable(){

                                @Override
                                public void run() {
                                    PuzzleActivity.this.loadPhoto();
                                }
                            });
                        }
                    });
                }
            }).start();
        } else {
            this.paths = intent.getStringArrayListExtra("keyOfPuzzleFiles");
            this.fileCount = this.paths.size() > 9 ? 9 : this.paths.size();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < PuzzleActivity.this.fileCount; ++i) {
                        Bitmap bitmap = PuzzleActivity.this.getScaleBitmap(PuzzleActivity.this.paths.get(i));
                        PuzzleActivity.this.bitmaps.add(bitmap);
                        PuzzleActivity.this.degrees.add(0);
                    }
                    PuzzleActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            PuzzleActivity.this.puzzleView.post(new Runnable(){

                                @Override
                                public void run() {
                                    PuzzleActivity.this.loadPhoto();
                                }
                            });
                        }
                    });
                }
            }).start();
        }
    }

    private Bitmap getScaleBitmap(String path) {
        Bitmap bitmap = null;
        try {
            bitmap = Setting.imageEngine.getCacheBitmap((Context)this, path, this.deviceWidth / 2, this.deviceHeight / 2);
            if (bitmap == null) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)BitmapFactory.decodeFile((String)path), (int)(this.deviceWidth / 2), (int)(this.deviceHeight / 2), (boolean)true);
            }
        }
        catch (Exception e) {
            bitmap = Bitmap.createScaledBitmap((Bitmap)BitmapFactory.decodeFile((String)path), (int)(this.deviceWidth / 2), (int)(this.deviceHeight / 2), (boolean)true);
        }
        return bitmap;
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (R.id.tv_back == id2) {
            this.finish();
        } else if (R.id.tv_done == id2) {
            if (PermissionUtil.checkAndRequestPermissionsInActivity((Activity)this, this.getNeedPermissions())) {
                this.savePhoto();
            }
        } else if (R.id.iv_replace == id2) {
            this.controlFlag = -1;
            this.degreeSeekBar.setVisibility(8);
            this.toggleIvMenu(R.id.iv_replace);
            if (null == toClass) {
                EasyPhotos.createAlbum((FragmentActivity)this, true, Setting.imageEngine).setCount(1).start(91);
            } else {
                Intent intent = new Intent((Context)this, (Class)toClass.get());
                this.startActivityForResult(intent, 91);
            }
        } else if (R.id.iv_rotate == id2) {
            if (this.controlFlag == 2) {
                if (this.degrees.get(this.degreeIndex) % 90 != 0) {
                    this.puzzleView.rotate(-this.degrees.get(this.degreeIndex).intValue());
                    this.degrees.remove(this.degreeIndex);
                    this.degrees.add(this.degreeIndex, 0);
                    this.degreeSeekBar.setCurrentDegrees(0);
                    return;
                }
                this.puzzleView.rotate(90.0f);
                int degree = this.degrees.get(this.degreeIndex) + 90;
                if (degree == 360 || degree == -360) {
                    degree = 0;
                }
                this.degrees.remove(this.degreeIndex);
                this.degrees.add(this.degreeIndex, degree);
                this.degreeSeekBar.setCurrentDegrees(this.degrees.get(this.degreeIndex));
                return;
            }
            this.handleSeekBar(2, -360, 360, this.degrees.get(this.degreeIndex).intValue());
            this.toggleIvMenu(R.id.iv_rotate);
        } else if (R.id.iv_mirror == id2) {
            this.degreeSeekBar.setVisibility(8);
            this.controlFlag = -1;
            this.toggleIvMenu(R.id.iv_mirror);
            this.puzzleView.flipHorizontally();
        } else if (R.id.iv_flip == id2) {
            this.controlFlag = -1;
            this.degreeSeekBar.setVisibility(8);
            this.toggleIvMenu(R.id.iv_flip);
            this.puzzleView.flipVertically();
        } else if (R.id.iv_corner == id2) {
            this.handleSeekBar(1, 0, 1000, this.puzzleView.getPieceRadian());
            this.toggleIvMenu(R.id.iv_corner);
        } else if (R.id.iv_padding == id2) {
            this.handleSeekBar(0, 0, 100, this.puzzleView.getPiecePadding());
            this.toggleIvMenu(R.id.iv_padding);
        } else if (R.id.tv_template == id2) {
            this.tvTemplate.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.easy_photos_fg_accent));
            this.tvTextSticker.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.easy_photos_fg_primary));
            this.rvPuzzleTemplet.setAdapter((RecyclerView.Adapter)this.puzzleAdapter);
        } else if (R.id.tv_text_sticker == id2) {
            this.tvTextSticker.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.easy_photos_fg_accent));
            this.tvTemplate.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.easy_photos_fg_primary));
            this.rvPuzzleTemplet.setAdapter((RecyclerView.Adapter)this.textStickerAdapter);
        } else if (R.id.fab == id2) {
            this.processBottomLayout();
        }
    }

    private void processBottomLayout() {
        if (0 == this.mBottomLayout.getVisibility()) {
            this.mBottomLayout.setVisibility(8);
            this.fab.setImageResource(R.drawable.ic_arrow_up_easy_photos);
        } else {
            this.mBottomLayout.setVisibility(0);
            this.fab.setImageResource(R.drawable.ic_arrow_down_easy_photos);
        }
    }

    private void handleSeekBar(int controlFlag, int rangeStart, int rangeEnd, float degrees) {
        this.controlFlag = controlFlag;
        this.degreeSeekBar.setVisibility(0);
        this.degreeSeekBar.setDegreeRange(rangeStart, rangeEnd);
        this.degreeSeekBar.setCurrentDegrees((int)degrees);
    }

    private void savePhoto() {
        this.mBottomLayout.setVisibility(8);
        this.fab.setVisibility(8);
        this.progressBar.setVisibility(0);
        this.findViewById(R.id.tv_done).setVisibility(4);
        this.findViewById(R.id.progress_frame).setVisibility(0);
        this.puzzleView.clearHandling();
        this.puzzleView.invalidate();
        this.stickerModel.save((Activity)this, (ViewGroup)this.mRootView, this.puzzleView, this.puzzleView.getWidth(), this.puzzleView.getHeight(), this.saveDirPath, this.saveNamePrefix, true, new SaveBitmapCallBack(){

            @Override
            public void onSuccess(File file) {
                Intent intent = new Intent();
                intent.putExtra("keyOfEasyPhotosResultPaths", file.getAbsolutePath());
                Photo photo = new Photo(file.getName(), file.getAbsolutePath(), file.lastModified() / 1000L, PuzzleActivity.this.puzzleView.getWidth(), PuzzleActivity.this.puzzleView.getHeight(), file.length(), DurationUtils.getDuration(file.getAbsolutePath()), "image/png");
                intent.putExtra("keyOfEasyPhotosResult", (Parcelable)photo);
                PuzzleActivity.this.setResult(-1, intent);
                PuzzleActivity.this.finish();
            }

            @Override
            public void onIOFailed(IOException exception) {
                PuzzleActivity.this.setResult(-1);
                PuzzleActivity.this.finish();
            }

            @Override
            public void onCreateDirFailed() {
                PuzzleActivity.this.setResult(-1);
                PuzzleActivity.this.finish();
            }
        });
    }

    private void toggleIvMenu(@IdRes int resId) {
        for (ImageView ivMenu : this.ivMenus) {
            if (ivMenu.getId() == resId) {
                ivMenu.setColorFilter(ContextCompat.getColor((Context)this, (int)R.color.easy_photos_fg_accent));
                continue;
            }
            ivMenu.clearColorFilter();
        }
    }

    @Override
    public void onItemClick(int themeType, int themeId) {
        this.puzzleView.setPuzzleLayout(PuzzleUtils.getPuzzleLayout(themeType, this.fileCount, themeId));
        this.loadPhoto();
        this.resetDegress();
    }

    private void resetDegress() {
        this.degreeIndex = -1;
        this.llMenu.setVisibility(8);
        this.degreeSeekBar.setVisibility(8);
        for (int i = 0; i < this.degrees.size(); ++i) {
            this.degrees.remove(i);
            this.degrees.add(i, 0);
        }
    }

    protected void onDestroy() {
        if (null != toClass) {
            toClass.clear();
            toClass = null;
        }
        super.onDestroy();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 14) {
            if (PermissionUtil.checkAndRequestPermissionsInActivity((Activity)this, this.getNeedPermissions())) {
                this.savePhoto();
            }
            return;
        }
        switch (resultCode) {
            case -1: {
                this.degrees.remove(this.degreeIndex);
                this.degrees.add(this.degreeIndex, 0);
                String tempPath = "";
                if (this.fileTypeIsPhoto) {
                    ArrayList photos = data.getParcelableArrayListExtra("keyOfEasyPhotosResult");
                    Photo photo = (Photo)photos.get(0);
                    tempPath = photo.path;
                } else {
                    tempPath = (String)data.getStringArrayListExtra("keyOfEasyPhotosResultPaths").get(0);
                }
                final String path = tempPath;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        final Bitmap bitmap = PuzzleActivity.this.getScaleBitmap(path);
                        PuzzleActivity.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                PuzzleActivity.this.puzzleView.replace(bitmap);
                            }
                        });
                    }
                }).start();
                break;
            }
            case 0: {
                break;
            }
        }
    }

    protected String[] getNeedPermissions() {
        if (Build.VERSION.SDK_INT >= 16) {
            return new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
        }
        return new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"};
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        PermissionUtil.onPermissionResult((Activity)this, permissions, grantResults, new PermissionUtil.PermissionCallBack(){

            @Override
            public void onSuccess() {
                PuzzleActivity.this.savePhoto();
            }

            @Override
            public void onShouldShow() {
                Snackbar.make((View)PuzzleActivity.this.rvPuzzleTemplet, (int)R.string.permissions_again_easy_photos, (int)-2).setAction((CharSequence)"go", new View.OnClickListener(){

                    public void onClick(View view) {
                        if (PermissionUtil.checkAndRequestPermissionsInActivity((Activity)PuzzleActivity.this, PuzzleActivity.this.getNeedPermissions())) {
                            PuzzleActivity.this.savePhoto();
                        }
                    }
                }).show();
            }

            @Override
            public void onFailed() {
                Snackbar.make((View)PuzzleActivity.this.rvPuzzleTemplet, (int)R.string.permissions_die_easy_photos, (int)-2).setAction((CharSequence)"go", new View.OnClickListener(){

                    public void onClick(View view) {
                        SettingsUtils.startMyApplicationDetailsForResult((Activity)PuzzleActivity.this, PuzzleActivity.this.getPackageName());
                    }
                }).show();
            }
        });
    }

    @Override
    public void onItemClick(String stickerValue) {
        if (stickerValue.equals("-1")) {
            if (this.fileTypeIsPhoto) {
                PuzzleLayout puzzleLayout = this.puzzleView.getPuzzleLayout();
                for (int i = 0; i < puzzleLayout.getAreaCount(); ++i) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
                    String date = format.format(this.photos.get((int)i).time);
                    this.stickerModel.addTextSticker((Context)this, this.getSupportFragmentManager(), date, (ViewGroup)this.mRootView);
                    this.stickerModel.currTextSticker.isChecked = true;
                    Area area = puzzleLayout.getArea(i);
                    this.stickerModel.currTextSticker.moveTo(area.centerX(), area.centerY());
                }
            } else {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
                String date = format.format(new Date());
                this.stickerModel.addTextSticker((Context)this, this.getSupportFragmentManager(), date, (ViewGroup)this.mRootView);
            }
            return;
        }
        this.stickerModel.addTextSticker((Context)this, this.getSupportFragmentManager(), stickerValue, (ViewGroup)this.mRootView);
    }

    public void onBackPressed() {
        if (0 == this.mBottomLayout.getVisibility()) {
            this.processBottomLayout();
            return;
        }
        super.onBackPressed();
    }

    private void setClick(int ... ids) {
        for (int id2 : ids) {
            this.findViewById(id2).setOnClickListener((View.OnClickListener)this);
        }
    }

    private void setClick(View ... views) {
        for (View v : views) {
            v.setOnClickListener((View.OnClickListener)this);
        }
    }
}

